/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.genenetwork.GeneNetworkStrings;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.view.GeneNetworkFontFactory;
import edu.colorado.phet.genenetwork.view.LacIGeneToolBoxNode;
import edu.colorado.phet.genenetwork.view.LacIPromoterToolBoxNode;
import edu.colorado.phet.genenetwork.view.LacOperatorToolBoxNode;
import edu.colorado.phet.genenetwork.view.LacPromoterToolBoxNode;
import edu.colorado.phet.genenetwork.view.LacZGeneToolBoxNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public abstract class DnaSegmentToolBoxNode
extends PNode {
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Stroke OUTLINE_STROKE = new BasicStroke(2.0f);
    private static final Font CHECK_BOX_FONT = GeneNetworkFontFactory.getFont(16, 0);
    protected PhetPPath boxNode;
    protected LacIPromoterToolBoxNode lacIPromoter;
    protected LacZGeneToolBoxNode lacZGene;
    protected LacIGeneToolBoxNode lacIGene;
    protected LacOperatorToolBoxNode lacIBindingRegion;
    protected LacPromoterToolBoxNode lacPromoter;
    protected PSwing legendControlCheckBoxPSwing;
    protected PSwing lactoseMeterCheckBoxPSwing;
    PPath dividerLine;
    protected IGeneNetworkModelControl model;
    protected ModelViewTransform2D mvt;
    protected PhetPCanvas canvas;

    public DnaSegmentToolBoxNode(final PhetPCanvas phetPCanvas, final IGeneNetworkModelControl iGeneNetworkModelControl, ModelViewTransform2D modelViewTransform2D) {
        this.canvas = phetPCanvas;
        this.model = iGeneNetworkModelControl;
        this.mvt = modelViewTransform2D;
        phetPCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DnaSegmentToolBoxNode.this.updateLayout(phetPCanvas);
            }
        });
        this.boxNode = new PhetPPath(new RoundRectangle2D.Double(0.0, 0.0, phetPCanvas.getWidth(), 100.0, 15.0, 15.0), BACKGROUND_COLOR, OUTLINE_STROKE, Color.BLACK);
        this.addChild(this.boxNode);
        this.lacIPromoter = new LacIPromoterToolBoxNode(iGeneNetworkModelControl, modelViewTransform2D, phetPCanvas);
        this.addChild(this.lacIPromoter);
        this.lacZGene = new LacZGeneToolBoxNode(iGeneNetworkModelControl, modelViewTransform2D, phetPCanvas);
        this.addChild(this.lacZGene);
        this.lacIGene = new LacIGeneToolBoxNode(iGeneNetworkModelControl, modelViewTransform2D, phetPCanvas);
        this.addChild(this.lacIGene);
        this.lacIBindingRegion = new LacOperatorToolBoxNode(iGeneNetworkModelControl, modelViewTransform2D, phetPCanvas);
        this.addChild(this.lacIBindingRegion);
        this.lacPromoter = new LacPromoterToolBoxNode(iGeneNetworkModelControl, modelViewTransform2D, phetPCanvas);
        this.addChild(this.lacPromoter);
        final JCheckBox jCheckBox = new JCheckBox(GeneNetworkStrings.LACTOSE_METER_VISIBILITY_CONTROL_CAPTION);
        jCheckBox.setFont(CHECK_BOX_FONT);
        jCheckBox.setBackground(BACKGROUND_COLOR);
        jCheckBox.setSelected(iGeneNetworkModelControl.isLegendVisible());
        jCheckBox.setFocusable(false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                iGeneNetworkModelControl.setLactoseMeterVisible(jCheckBox.isSelected());
            }
        });
        this.lactoseMeterCheckBoxPSwing = new PSwing(jCheckBox);
        this.addChild(this.lactoseMeterCheckBoxPSwing);
        final JCheckBox jCheckBox2 = new JCheckBox(GeneNetworkStrings.LEGEND_VISIBILITY_CONTROL_CAPTION);
        jCheckBox2.setFont(CHECK_BOX_FONT);
        jCheckBox2.setBackground(BACKGROUND_COLOR);
        jCheckBox2.setSelected(iGeneNetworkModelControl.isLegendVisible());
        jCheckBox2.setFocusable(false);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                iGeneNetworkModelControl.setLegendVisible(jCheckBox2.isSelected());
            }
        });
        this.legendControlCheckBoxPSwing = new PSwing(jCheckBox2);
        this.addChild(this.legendControlCheckBoxPSwing);
        this.dividerLine = new PhetPPath(OUTLINE_STROKE, (Paint)Color.LIGHT_GRAY);
        this.addChild(this.dividerLine);
        iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

            public void legendVisibilityStateChange() {
                jCheckBox2.setSelected(iGeneNetworkModelControl.isLegendVisible());
            }

            public void lactoseMeterVisibilityStateChange() {
                jCheckBox.setSelected(iGeneNetworkModelControl.isLactoseMeterVisible());
            }
        });
    }

    protected abstract void updateLayout(JComponent var1);
}

