/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.LacY;
import edu.colorado.phet.genenetwork.model.LacYTransformationArrow;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.MessengerRnaSpawningStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class SpawnLacYStrategy
extends MessengerRnaSpawningStrategy {
    private static final Random RAND = new Random(321L);
    private double spawnCountdownTimer = 4.0;
    private int spawnCount = Integer.MAX_VALUE;

    public SpawnLacYStrategy(int n) {
        this.spawnCount = n;
    }

    public SpawnLacYStrategy() {
        this(1 + RAND.nextInt(2));
    }

    public boolean isSpawningComplete() {
        return this.spawnCount == 0;
    }

    public void stepInTime(double d, SimpleModelElement simpleModelElement) {
        if (this.spawnCountdownTimer != Double.POSITIVE_INFINITY) {
            this.spawnCountdownTimer -= d;
            if (this.spawnCountdownTimer <= 0.0) {
                assert (this.spawnCount > 0);
                this.spawnLacY(simpleModelElement);
                --this.spawnCount;
                this.spawnCountdownTimer = this.spawnCount > 0 ? 2.0 : Double.POSITIVE_INFINITY;
            }
        }
    }

    protected void spawnLacY(SimpleModelElement simpleModelElement) {
        Rectangle2D rectangle2D = simpleModelElement.getShape().getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getCenterX() + simpleModelElement.getPositionRef().getX() + 3.0, rectangle2D.getMaxY() + simpleModelElement.getPositionRef().getY() + 1.0);
        LacYTransformationArrow lacYTransformationArrow = new LacYTransformationArrow(simpleModelElement.getModel(), double_, new LacY(simpleModelElement.getModel(), true), 0.7853981633974483);
        lacYTransformationArrow.setMotionStrategy(new LinearMotionStrategy(simpleModelElement.getModel().getInteriorMotionBoundsAboveDna(), (Point2D)double_, new Vector2D(simpleModelElement.getVelocityRef()), 5.0));
        simpleModelElement.getModel().addTransformationArrow(lacYTransformationArrow);
    }
}

