/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.LacY;
import edu.colorado.phet.genenetwork.model.LacYTransformationArrow;
import edu.colorado.phet.genenetwork.model.LacZ;
import edu.colorado.phet.genenetwork.model.LacZTransformationArrow;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.MessengerRnaSpawningStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class SpawnLacYAndLacZStrategy
extends MessengerRnaSpawningStrategy {
    private static final Random RAND = new Random();
    private double spawnCountdownTimer = 1.0;
    private int spawnLacZCount = RAND.nextInt(3) + 2;
    private int spawnLacYCount = Math.max(this.spawnLacZCount / 2, 2);
    private boolean spawnLacZNext = true;

    public boolean isSpawningComplete() {
        return this.spawnLacZCount == 0 && this.spawnLacYCount == 0;
    }

    public void stepInTime(double d, SimpleModelElement simpleModelElement) {
        if (this.spawnCountdownTimer != Double.POSITIVE_INFINITY) {
            this.spawnCountdownTimer -= d;
            if (this.spawnCountdownTimer <= 0.0) {
                assert (this.spawnLacZCount > 0 || this.spawnLacYCount > 0);
                if (this.spawnLacZNext) {
                    this.spawnLacZ(simpleModelElement);
                    --this.spawnLacZCount;
                    if (this.spawnLacYCount > 0) {
                        this.spawnLacZNext = false;
                    }
                } else {
                    this.spawnLacY(simpleModelElement);
                    --this.spawnLacYCount;
                    this.spawnLacZNext = true;
                }
                this.spawnCountdownTimer = this.spawnLacZCount > 0 || this.spawnLacYCount > 0 ? 1.0 : Double.POSITIVE_INFINITY;
            }
        }
    }

    protected void spawnLacY(SimpleModelElement simpleModelElement) {
        Rectangle2D rectangle2D = simpleModelElement.getShape().getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + simpleModelElement.getPositionRef().getX() + rectangle2D.getWidth() * 0.7 + 3.0, rectangle2D.getY() + simpleModelElement.getPositionRef().getY() + rectangle2D.getHeight() * 0.3 + 3.0);
        LacYTransformationArrow lacYTransformationArrow = new LacYTransformationArrow(simpleModelElement.getModel(), double_, new LacY(simpleModelElement.getModel(), true), 0.7853981633974483);
        lacYTransformationArrow.setMotionStrategy(new LinearMotionStrategy(simpleModelElement.getModel().getInteriorMotionBoundsAboveDna(), (Point2D)double_, new Vector2D(simpleModelElement.getVelocityRef()), 5.0));
        simpleModelElement.getModel().addTransformationArrow(lacYTransformationArrow);
    }

    protected void spawnLacZ(SimpleModelElement simpleModelElement) {
        Rectangle2D rectangle2D = simpleModelElement.getShape().getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getX() + simpleModelElement.getPositionRef().getX() + rectangle2D.getWidth() / 3.0 + 3.0, rectangle2D.getMaxY() + simpleModelElement.getPositionRef().getY() + 1.0);
        LacZTransformationArrow lacZTransformationArrow = new LacZTransformationArrow(simpleModelElement.getModel(), double_, new LacZ(simpleModelElement.getModel(), true), 0.7853981633974483);
        lacZTransformationArrow.setMotionStrategy(new LinearMotionStrategy(simpleModelElement.getModel().getInteriorMotionBoundsAboveDna(), (Point2D)double_, new Vector2D(simpleModelElement.getVelocityRef()), 5.0));
        simpleModelElement.getModel().addTransformationArrow(lacZTransformationArrow);
    }
}

