/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.LacI;
import edu.colorado.phet.genenetwork.model.LacITransformationArrow;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.MessengerRnaSpawningStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class SpawnLacIStrategy
extends MessengerRnaSpawningStrategy {
    private static final Random RAND = new Random(4324L);
    private double spawnCountdownTimer = 3.0;
    private int spawnCount = Integer.MAX_VALUE;

    public SpawnLacIStrategy(int n) {
        this.spawnCount = n;
    }

    public SpawnLacIStrategy() {
        this(1 + RAND.nextInt(2));
    }

    public boolean isSpawningComplete() {
        return this.spawnCount == 0;
    }

    public void stepInTime(double d, SimpleModelElement simpleModelElement) {
        if (this.spawnCountdownTimer != Double.POSITIVE_INFINITY) {
            this.spawnCountdownTimer -= d;
            if (this.spawnCountdownTimer <= 0.0) {
                assert (this.spawnCount > 0);
                this.spawnLacI(simpleModelElement);
                --this.spawnCount;
                this.spawnCountdownTimer = this.spawnCount > 0 ? 2.0 : Double.POSITIVE_INFINITY;
            }
        }
    }

    protected void spawnLacI(SimpleModelElement simpleModelElement) {
        Rectangle2D rectangle2D = simpleModelElement.getShape().getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getCenterX() + simpleModelElement.getPositionRef().getX() + 3.0, rectangle2D.getMaxY() + simpleModelElement.getPositionRef().getY() + 1.0);
        LacITransformationArrow lacITransformationArrow = new LacITransformationArrow(simpleModelElement.getModel(), double_, new LacI(simpleModelElement.getModel(), true), 0.7853981633974483);
        lacITransformationArrow.setMotionStrategy(new LinearMotionStrategy(simpleModelElement.getModel().getInteriorMotionBoundsAboveDna(), (Point2D)double_, new Vector2D(simpleModelElement.getVelocityRef()), 5.0));
        simpleModelElement.getModel().addTransformationArrow(lacITransformationArrow);
    }
}

