/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AbstractMotionStrategy;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.IModelElement;
import edu.colorado.phet.genenetwork.model.IModelElementListener;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public abstract class SimpleModelElement
implements IModelElement {
    private Shape shape;
    private Point2D position;
    private Paint paint;
    private double existenceStrength = 1.0;
    private ExistenceState existenceState = ExistenceState.EXISTING;
    private Vector2D velocity = new Vector2D();
    protected ArrayList<IModelElementListener> listeners = new ArrayList();
    private AbstractMotionStrategy motionStrategy = null;
    private final IGeneNetworkModelControl model;
    private boolean dragging;
    private double existenceTimeCountdown;
    private double existenceTime;
    private boolean okayToFade = true;
    private Rectangle2D dragBounds = null;

    public SimpleModelElement(IGeneNetworkModelControl iGeneNetworkModelControl, Shape shape, Point2D point2D, Paint paint, boolean bl, double d) {
        this.model = iGeneNetworkModelControl;
        this.shape = shape;
        this.position = point2D;
        this.paint = paint;
        this.existenceTime = d;
        if (bl) {
            this.setExistenceState(ExistenceState.FADING_IN);
            this.setExistenceStrength(0.01);
        } else {
            this.setExistenceState(ExistenceState.EXISTING);
            this.setExistenceStrength(1.0);
            this.existenceTimeCountdown = d;
        }
    }

    public boolean isUserControlled() {
        return this.dragging;
    }

    public boolean isPartOfDnaStrand() {
        return false;
    }

    public Shape getShape() {
        return this.shape;
    }

    protected IGeneNetworkModelControl getModel() {
        return this.model;
    }

    protected void setOkayToFade(boolean bl) {
        this.okayToFade = bl;
    }

    protected void setShape(Shape shape) {
        this.shape = shape;
        this.notifyShapeChanged();
    }

    public Point2D getPositionRef() {
        return this.position;
    }

    public Rectangle2D getCompensatedBounds() {
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        return new Rectangle2D.Double(this.getPositionRef().getX() + rectangle2D.getMinX(), this.getPositionRef().getY() + rectangle2D.getMinY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setPosition(double d, double d2) {
        if (!(d == this.position.getX() && d2 == this.position.getY() || this.isUserControlled() && this.dragBounds != null && !this.dragBounds.contains(d, d2))) {
            this.position.setLocation(d, d2);
            this.notifyPositionChanged();
        }
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    protected void setDragBounds(Rectangle2D rectangle2D) {
        this.dragBounds = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected Rectangle2D getDragBounds() {
        return new Rectangle2D.Double(this.dragBounds.getX(), this.dragBounds.getY(), this.dragBounds.getWidth(), this.dragBounds.getHeight());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public String getHtmlLabel() {
        return null;
    }

    public void setVelocity(double d, double d2) {
        this.velocity.setComponents(d, d2);
    }

    public void setVelocity(Vector2D vector2D) {
        this.setVelocity(vector2D.getX(), vector2D.getY());
    }

    public Vector2D getVelocityRef() {
        return this.velocity;
    }

    public double getExistenceStrength() {
        return this.existenceStrength;
    }

    protected void setExistenceStrength(double d) {
        if (this.existenceStrength != d) {
            this.existenceStrength = d;
            this.notifyExistenceStrengthChanged();
        }
    }

    protected ExistenceState getExistenceState() {
        return this.existenceState;
    }

    private void setExistenceState(ExistenceState existenceState) {
        this.existenceState = existenceState;
    }

    public void removeFromModel() {
        this.notifyRemovedFromModel();
        this.listeners.clear();
    }

    protected void notifyPositionChanged() {
        for (IModelElementListener iModelElementListener : this.listeners) {
            iModelElementListener.positionChanged();
        }
    }

    protected void removeSelfFromModel() {
        this.setExistenceStrength(0.0);
    }

    private void notifyExistenceStrengthChanged() {
        for (IModelElementListener iModelElementListener : this.listeners) {
            iModelElementListener.existenceStrengthChanged();
        }
    }

    private void notifyRemovedFromModel() {
        for (IModelElementListener iModelElementListener : this.listeners) {
            iModelElementListener.removedFromModel();
        }
    }

    protected void notifyShapeChanged() {
        for (IModelElementListener iModelElementListener : this.listeners) {
            iModelElementListener.shapeChanged();
        }
    }

    public void addListener(IModelElementListener iModelElementListener) {
        if (this.listeners.contains(iModelElementListener)) {
            System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
            assert (false);
            return;
        }
        this.listeners.add(iModelElementListener);
    }

    public void removeListener(IModelElementListener iModelElementListener) {
        this.listeners.remove(iModelElementListener);
    }

    public void stepInTime(double d) {
        if (!this.isUserControlled()) {
            if (this.motionStrategy != null) {
                this.motionStrategy.doUpdatePositionAndMotion(d, this);
            }
            this.doFadeInOut(d);
        }
    }

    private void doFadeInOut(double d) {
        switch (this.getExistenceState()) {
            case FADING_IN: {
                if (this.getExistenceStrength() < 1.0) {
                    this.setExistenceStrength(Math.min(this.getExistenceStrength() + 0.1, 1.0));
                    break;
                }
                this.setExistenceState(ExistenceState.EXISTING);
                this.existenceTimeCountdown = this.existenceTime;
                this.onTransitionToExistingState();
                break;
            }
            case EXISTING: {
                if (this.existenceTime == Double.POSITIVE_INFINITY) break;
                this.existenceTimeCountdown -= d;
                if (!(this.existenceTimeCountdown <= 0.0)) break;
                if (this.okayToFade) {
                    this.setExistenceState(ExistenceState.FADING_OUT);
                    this.onTransitionToFadingOutState();
                    break;
                }
                this.existenceTimeCountdown = 0.0;
                break;
            }
            case FADING_OUT: {
                if (!(this.getExistenceStrength() > 0.0) || !this.okayToFade) break;
                this.setExistenceStrength(Math.max(this.getExistenceStrength() - 0.1, 0.0));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    protected void setMotionStrategy(AbstractMotionStrategy abstractMotionStrategy) {
        if (this.motionStrategy != null) {
            this.motionStrategy.cleanup();
        }
        this.motionStrategy = abstractMotionStrategy;
    }

    protected double getExistenceTimeCountdown() {
        return this.existenceTimeCountdown;
    }

    protected void onTransitionToExistingState() {
    }

    protected void onTransitionToFadingOutState() {
    }

    protected void setExistenceTime(double d) {
        if (this.existenceState == ExistenceState.FADING_OUT) {
            System.err.println(this.getClass().getName() + " - Warning: setExistenceTime called when already fading, this will have no effect.");
        } else {
            this.existenceTime = d;
            this.existenceTimeCountdown = d;
        }
    }

    protected AbstractMotionStrategy getMotionStrategyRef() {
        return this.motionStrategy;
    }

    public void setDragging(boolean bl) {
        if (this.dragging != bl) {
            this.dragging = bl;
            if (!bl) {
                if (this.model.isPointInToolBox(this.getPositionRef()) || !this.isInAllowableLocation()) {
                    this.removeSelfFromModel();
                } else if (this.isPartOfDnaStrand()) {
                    this.setPosition(this.getDefaultLocation());
                }
            }
        }
    }

    protected boolean isInAllowableLocation() {
        return true;
    }

    protected Point2D getDefaultLocation() {
        assert (false);
        return new Point2D.Double(0.0, 0.0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ExistenceState
    extends Enum<ExistenceState> {
        public static final /* enum */ ExistenceState FADING_IN = new ExistenceState();
        public static final /* enum */ ExistenceState EXISTING = new ExistenceState();
        public static final /* enum */ ExistenceState FADING_OUT = new ExistenceState();
        private static final /* synthetic */ ExistenceState[] $VALUES;

        public static ExistenceState[] values() {
            return (ExistenceState[])$VALUES.clone();
        }

        static {
            $VALUES = new ExistenceState[]{FADING_IN, EXISTING, FADING_OUT};
        }
    }
}

