/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AbstractMotionStrategy;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class LinearThenRandomMotionStrategy
extends AbstractMotionStrategy {
    private static final Random RAND = new Random();
    private RandomWalkMotionStrategy randomWalkStrategy;
    private LinearMotionStrategy linearMotionStrategy;
    private boolean movingLinearly = true;

    public LinearThenRandomMotionStrategy(Rectangle2D rectangle2D, Point2D point2D, Vector2D vector2D, double d) {
        this.linearMotionStrategy = new LinearMotionStrategy(rectangle2D, point2D, vector2D, d);
        this.randomWalkStrategy = new RandomWalkMotionStrategy(rectangle2D);
    }

    public void updatePositionAndMotion(double d, SimpleModelElement simpleModelElement) {
        if (this.movingLinearly) {
            this.linearMotionStrategy.updatePositionAndMotion(d, simpleModelElement);
            if (this.linearMotionStrategy.isDestinationReached() || this.linearMotionStrategy.isBoundsReached()) {
                this.movingLinearly = false;
                this.linearMotionStrategy = null;
                simpleModelElement.setVelocity(5.0 * RAND.nextDouble(), 5.0 * RAND.nextDouble());
            }
        } else {
            this.randomWalkStrategy.updatePositionAndMotion(d, simpleModelElement);
        }
    }
}

