/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AbstractMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LinearMotionStrategy
extends AbstractMotionStrategy {
    private boolean initialVelocitySet = false;
    private Vector2D initialVelocity = new Vector2D();
    private boolean isDestinationReached = false;
    private boolean isBoundsReached = false;

    public LinearMotionStrategy(Rectangle2D rectangle2D, Point2D point2D, Point2D point2D2, double d) {
        super(rectangle2D);
        this.setDestination(point2D2.getX(), point2D2.getY());
        double d2 = Math.atan2(this.getDestinationRef().getY() - point2D.getY(), this.getDestinationRef().getX() - point2D.getX());
        this.initialVelocity.setComponents(d * Math.cos(d2), d * Math.sin(d2));
    }

    public LinearMotionStrategy(Rectangle2D rectangle2D, Point2D point2D, Vector2D vector2D, double d) {
        this(rectangle2D, point2D, LinearMotionStrategy.velocityAndTimeToPoint(point2D, vector2D, d), vector2D.getMagnitude());
    }

    public void updatePositionAndMotion(double d, SimpleModelElement simpleModelElement) {
        if (!this.initialVelocitySet) {
            simpleModelElement.setVelocity(this.initialVelocity);
            this.initialVelocitySet = true;
        }
        Point2D point2D = simpleModelElement.getPositionRef();
        Vector2D vector2D = simpleModelElement.getVelocityRef();
        double d2 = this.getDestinationRef().distance(simpleModelElement.getPositionRef());
        double d3 = vector2D.getMagnitude() * d;
        if (d2 > 0.0 && d3 > d2) {
            simpleModelElement.setPosition(this.getDestinationRef());
            simpleModelElement.setVelocity(0.0, 0.0);
            this.isDestinationReached = true;
        } else if (point2D.getX() > this.getBounds().getMaxX() && vector2D.getX() > 0.0 || point2D.getX() < this.getBounds().getMinX() && vector2D.getX() < 0.0 || point2D.getY() > this.getBounds().getMaxY() && vector2D.getY() > 0.0 || point2D.getY() < this.getBounds().getMinY() && vector2D.getY() < 0.0) {
            simpleModelElement.setVelocity(0.0, 0.0);
            this.isBoundsReached = true;
        }
        if (simpleModelElement.getVelocityRef().getMagnitude() > 0.0) {
            simpleModelElement.setPosition(simpleModelElement.getPositionRef().getX() + simpleModelElement.getVelocityRef().getX() * d, simpleModelElement.getPositionRef().getY() + simpleModelElement.getVelocityRef().getY() * d);
        }
    }

    public boolean isDestinationReached() {
        return this.isDestinationReached;
    }

    public boolean isBoundsReached() {
        return this.isBoundsReached;
    }

    private static Point2D velocityAndTimeToPoint(Point2D point2D, Vector2D vector2D, double d) {
        return new Point2D.Double(point2D.getX() + vector2D.getX() * d, point2D.getY() + vector2D.getY() * d);
    }
}

