/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.CloseOnMovingTargetMotionStrategy;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.Lactose;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.PositionWrtCell;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.StillnessMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class LacZ
extends SimpleModelElement {
    private static final Paint ELEMENT_PAINT = new GradientPaint(new Point2D.Double(-10.0, 0.0), new Color(185, 147, 187), new Point2D.Double(50.0, 0.0), Color.WHITE);
    private static final Dimension2D GLUCOSE_ATTACHMENT_POINT_OFFSET = new PDimension(0.0, -5.0);
    private Glucose glucoseAttachmentPartner = null;
    private AttachmentState glucoseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    private double lactoseAttachmentCountdownTimer;
    private double recoverCountdownTimer;

    public LacZ(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, boolean bl) {
        super(iGeneNetworkModelControl, LacZ.createShape(), point2D, ELEMENT_PAINT, bl, LacZ.generateExistenceTime(iGeneNetworkModelControl));
        if (iGeneNetworkModelControl != null) {
            this.setMotionStrategy(new StillnessMotionStrategy());
            this.setDragBounds(this.getModel().getInteriorMotionBounds());
        }
    }

    public LacZ(IGeneNetworkModelControl iGeneNetworkModelControl, boolean bl) {
        this(iGeneNetworkModelControl, new Point2D.Double(), bl);
    }

    public LacZ() {
        this(null, false);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        if (!this.isUserControlled()) {
            if (this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING && this.glucoseAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE) {
                this.glucoseAttachmentPartner = this.getModel().getNearestLactose(this.getPositionRef(), PositionWrtCell.INSIDE_CELL, true);
                this.getEngagedToLactose();
            } else if (this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
                if (this.getGlucoseAttachmentPointLocation().distance(this.glucoseAttachmentPartner.getLacZAttachmentPointLocation()) < 1.0) {
                    this.completeAttachmentOfGlucose();
                }
            } else if (this.glucoseAttachmentState == AttachmentState.ATTACHED) {
                this.lactoseAttachmentCountdownTimer -= d;
                if (this.lactoseAttachmentCountdownTimer <= 0.0) {
                    this.glucoseAttachmentPartner.releaseGalactose();
                    this.glucoseAttachmentPartner.detach(this);
                    this.glucoseAttachmentPartner = null;
                    this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
                    this.setOkayToFade(true);
                    this.recoverCountdownTimer = 0.25;
                }
            } else if (this.glucoseAttachmentState == AttachmentState.UNATTACHED_BUT_UNAVALABLE) {
                this.recoverCountdownTimer -= d;
                if (this.recoverCountdownTimer <= 0.0) {
                    this.glucoseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                }
            }
        }
    }

    private void getEngagedToLactose() {
        if (this.glucoseAttachmentPartner != null) {
            if (!this.glucoseAttachmentPartner.considerProposalFrom(this)) {
                assert (false);
            } else {
                this.glucoseAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                this.setOkayToFade(false);
                PDimension pDimension = new PDimension(Glucose.getLacZAttachmentPointOffset().getWidth() - LacZ.getGlucoseAttachmentPointOffset().getWidth(), Glucose.getLacZAttachmentPointOffset().getHeight() - LacZ.getGlucoseAttachmentPointOffset().getHeight());
                this.setMotionStrategy(new CloseOnMovingTargetMotionStrategy(this.glucoseAttachmentPartner, pDimension, MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBounds(), this)));
            }
        }
    }

    public void setDragging(boolean bl) {
        if (bl && !this.isUserControlled()) {
            if (this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
                this.glucoseAttachmentPartner.detach(this);
                this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
                this.glucoseAttachmentPartner = null;
                this.recoverCountdownTimer = 0.0;
            }
        } else if (!bl && this.isUserControlled() && this.glucoseAttachmentPartner == null) {
            this.checkForNearbyLactoseToGrab();
        }
        super.setDragging(bl);
    }

    private void completeAttachmentOfGlucose() {
        this.glucoseAttachmentPartner.attach(this);
        this.glucoseAttachmentState = AttachmentState.ATTACHED;
        this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
        this.lactoseAttachmentCountdownTimer = 0.5;
    }

    private static Shape createShape() {
        Ellipse2D.Double double_ = new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0);
        Area area = new Area(double_);
        Shape shape = Lactose.getShape();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(0.0, -5.0);
        shape = affineTransform.createTransformedShape(shape);
        area.subtract(new Area(shape));
        return area;
    }

    protected void onTransitionToExistingState() {
        this.setMotionStrategy(new RandomWalkMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this)));
    }

    public void detach(Glucose glucose) {
        assert (glucose == this.glucoseAttachmentPartner);
        assert (this.glucoseAttachmentState == AttachmentState.ATTACHED || this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
        this.glucoseAttachmentPartner = null;
        this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        this.recoverCountdownTimer = 0.25;
        this.setOkayToFade(true);
    }

    public boolean requestImmediateAttach(Glucose glucose) {
        assert (glucose != this.glucoseAttachmentPartner);
        if (this.glucoseAttachmentState == AttachmentState.ATTACHED) {
            return false;
        }
        if (this.glucoseAttachmentPartner != null) {
            this.glucoseAttachmentPartner.detach(this);
        }
        if (!glucose.considerProposalFrom(this)) {
            System.err.println(this.getClass().getName() + "- Error: Proposal refused by element that requested attachment.");
            assert (false);
        }
        this.glucoseAttachmentPartner = glucose;
        this.completeAttachmentOfGlucose();
        return true;
    }

    public Point2D getGlucoseAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + GLUCOSE_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + GLUCOSE_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public static Dimension2D getGlucoseAttachmentPointOffset() {
        return new PDimension(GLUCOSE_ATTACHMENT_POINT_OFFSET);
    }

    private void checkForNearbyLactoseToGrab() {
        assert (this.glucoseAttachmentPartner == null);
        Glucose glucose = this.getModel().getNearestLactose(this.getPositionRef(), PositionWrtCell.INSIDE_CELL, false);
        if (glucose != null && glucose.getPositionRef().distance(this.getPositionRef()) < 15.0 && glucose.breakOffPendingAttachments(this)) {
            this.glucoseAttachmentPartner = glucose;
            this.getEngagedToLactose();
            if (glucose.getPositionRef().distance(this.getPositionRef()) < 7.0) {
                this.completeAttachmentOfGlucose();
            }
        }
    }

    private static double generateExistenceTime(IGeneNetworkModelControl iGeneNetworkModelControl) {
        int n = 20;
        double d = 2.0;
        double d2 = iGeneNetworkModelControl == null || iGeneNetworkModelControl.getLactoseLevel() < n ? 25.0 : 25.0 * d;
        return d2;
    }
}

