/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.AttachmentState;
import edu.colorado.phet.genenetwork.model.Glucose;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.InjectionMotionStrategy;
import edu.colorado.phet.genenetwork.model.Lactose;
import edu.colorado.phet.genenetwork.model.LinearMotionStrategy;
import edu.colorado.phet.genenetwork.model.MotionBoundsTrimmer;
import edu.colorado.phet.genenetwork.model.PositionWrtCell;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.colorado.phet.genenetwork.model.StillnessMotionStrategy;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class LacY
extends SimpleModelElement {
    private static final Paint ELEMENT_PAINT = new GradientPaint(new Point2D.Double(-8.0, 0.0), new Color(0, 200, 0), new Point2D.Double(40.0, 0.0), Color.WHITE);
    private static final Dimension2D GLUCOSE_ATTACHMENT_POINT_OFFSET = new PDimension(0.0, 4.0);
    private Glucose glucoseAttachmentPartner = null;
    private AttachmentState glucoseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
    private double lactoseTraversalCoundownTimer;
    private double recoverCountdownTimer;
    private double lactoseTraversalDistance;
    private Point2D membraneDestination = new Point2D.Double();

    public LacY(IGeneNetworkModelControl iGeneNetworkModelControl, Point2D point2D, boolean bl) {
        super(iGeneNetworkModelControl, LacY.createShape(), point2D, ELEMENT_PAINT, bl, 45.0);
        if (iGeneNetworkModelControl != null) {
            this.setMotionStrategy(new StillnessMotionStrategy());
            Rectangle2D rectangle2D = this.getModel().getInteriorMotionBounds();
            rectangle2D.add(new Point2D.Double(rectangle2D.getX(), rectangle2D.getMaxY() + this.getShape().getBounds2D().getHeight()));
            this.setDragBounds(rectangle2D);
        }
        this.lactoseTraversalDistance = this.getShape().getBounds2D().getHeight();
    }

    public LacY(IGeneNetworkModelControl iGeneNetworkModelControl, boolean bl) {
        this(iGeneNetworkModelControl, new Point2D.Double(), bl);
    }

    public LacY() {
        this(null, false);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        if (!this.isUserControlled()) {
            if (this.getExistenceState() == SimpleModelElement.ExistenceState.EXISTING && this.glucoseAttachmentState == AttachmentState.UNATTACHED_AND_AVAILABLE && this.isEmbeddedInMembrane()) {
                this.glucoseAttachmentPartner = this.getModel().getNearestLactose(this.getPositionRef(), PositionWrtCell.OUTSIDE_CELL, true);
                this.getEngagedToLactose();
            } else if (this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
                if (this.getGlucoseAttachmentPointLocation().distance(this.glucoseAttachmentPartner.getLacYAttachmentPointLocation()) < 2.0) {
                    this.completeAttachmentOfGlucose();
                }
            } else if (this.glucoseAttachmentState == AttachmentState.ATTACHED) {
                this.lactoseTraversalCoundownTimer -= d;
                double d2 = (1.0 - this.lactoseTraversalCoundownTimer / 0.5) * this.lactoseTraversalDistance;
                this.glucoseAttachmentPartner.setPosition(this.glucoseAttachmentPartner.getPositionRef().getX(), this.getGlucoseAttachmentPointLocation().getY() - d2);
                if (this.lactoseTraversalCoundownTimer <= 0.0) {
                    this.glucoseAttachmentPartner.detach(this);
                    this.glucoseAttachmentPartner.setMotionStrategy(new InjectionMotionStrategy(MotionBoundsTrimmer.trim(this.getModel().getInteriorMotionBoundsAboveDna(), this.glucoseAttachmentPartner), new Vector2D(0.0, -15.0)));
                    this.glucoseAttachmentPartner.setUpDraggableBounds(PositionWrtCell.INSIDE_CELL);
                    this.glucoseAttachmentPartner = null;
                    this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
                    this.recoverCountdownTimer = 0.15;
                    this.setOkayToFade(true);
                }
            } else if (this.glucoseAttachmentState == AttachmentState.UNATTACHED_BUT_UNAVALABLE) {
                this.recoverCountdownTimer -= d;
                if (this.recoverCountdownTimer <= 0.0) {
                    this.glucoseAttachmentState = AttachmentState.UNATTACHED_AND_AVAILABLE;
                }
            }
        }
    }

    private void getEngagedToLactose() {
        if (this.glucoseAttachmentPartner != null) {
            if (!this.glucoseAttachmentPartner.considerProposalFrom(this)) {
                assert (false);
            } else {
                this.glucoseAttachmentState = AttachmentState.MOVING_TOWARDS_ATTACHMENT;
                this.setOkayToFade(false);
            }
        }
    }

    public void setDragging(boolean bl) {
        if (bl && !this.isUserControlled()) {
            if (this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT) {
                this.glucoseAttachmentPartner.detach(this);
                this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
                this.glucoseAttachmentPartner = null;
                this.recoverCountdownTimer = 0.0;
            }
        } else if (!bl && this.isUserControlled() && !this.isEmbeddedInMembrane()) {
            if (Math.abs(this.getPositionRef().getY() - this.getModel().getCellMembraneRect().getCenterY()) < 5.0) {
                this.setPosition(this.getPositionRef().getX(), this.getModel().getCellMembraneRect().getCenterY());
                this.setMotionStrategy(new StillnessMotionStrategy());
            } else {
                Rectangle2D rectangle2D = this.getModel().getInteriorMotionBoundsAboveDna();
                rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + this.getModel().getCellMembraneRect().getHeight());
                this.setMotionStrategy(new LinearMotionStrategy(rectangle2D, this.getPositionRef(), this.getMembraneDestinationRef(), 10.0));
            }
        }
        super.setDragging(bl);
    }

    public void setPosition(double d, double d2) {
        if (!this.isUserControlled() || !this.isEmbeddedInMembrane()) {
            super.setPosition(d, d2);
        }
    }

    private void completeAttachmentOfGlucose() {
        this.glucoseAttachmentPartner.attach(this);
        this.glucoseAttachmentState = AttachmentState.ATTACHED;
        this.lactoseTraversalCoundownTimer = 0.5;
    }

    private static Shape createShape() {
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(-4.0, -4.0, 8.0, 8.0, 2.6666666666666665, 2.6666666666666665);
        Area area = new Area(double_);
        Shape shape = Lactose.getShape();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(0.0, 4.0);
        shape = affineTransform.createTransformedShape(shape);
        area.subtract(new Area(shape));
        return area;
    }

    protected void onTransitionToExistingState() {
        Rectangle2D rectangle2D = this.getModel().getInteriorMotionBoundsAboveDna();
        rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + this.getModel().getCellMembraneRect().getHeight());
        this.setMembraneDestination(this.getModel().getOpenSpotForLacY());
        this.setMotionStrategy(new LinearMotionStrategy(rectangle2D, this.getPositionRef(), this.getMembraneDestinationRef(), 14.0));
    }

    public void detach(Glucose glucose) {
        assert (glucose == this.glucoseAttachmentPartner);
        assert (this.glucoseAttachmentState == AttachmentState.ATTACHED || this.glucoseAttachmentState == AttachmentState.MOVING_TOWARDS_ATTACHMENT);
        this.glucoseAttachmentPartner = null;
        this.glucoseAttachmentState = AttachmentState.UNATTACHED_BUT_UNAVALABLE;
        this.recoverCountdownTimer = 0.15;
        this.setOkayToFade(true);
    }

    public boolean requestImmediateAttach(Glucose glucose) {
        assert (glucose != this.glucoseAttachmentPartner);
        if (this.glucoseAttachmentState == AttachmentState.ATTACHED) {
            return false;
        }
        if (this.glucoseAttachmentPartner != null) {
            this.glucoseAttachmentPartner.detach(this);
        }
        if (!glucose.considerProposalFrom(this)) {
            System.err.println(this.getClass().getName() + "- Error: Proposal refused by element that requested attachment.");
            assert (false);
        }
        this.glucoseAttachmentPartner = glucose;
        this.completeAttachmentOfGlucose();
        return true;
    }

    public Point2D getGlucoseAttachmentPointLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + GLUCOSE_ATTACHMENT_POINT_OFFSET.getWidth(), this.getPositionRef().getY() + GLUCOSE_ATTACHMENT_POINT_OFFSET.getHeight());
    }

    public boolean isEmbeddedInMembrane() {
        boolean bl = false;
        Rectangle2D rectangle2D = this.getModel().getCellMembraneRect();
        if (rectangle2D != null && this.getPositionRef().getY() + 0.01 > rectangle2D.getCenterY() && this.getPositionRef().getY() - 0.01 < rectangle2D.getCenterY()) {
            bl = true;
        }
        return bl;
    }

    protected Point2D getMembraneDestinationRef() {
        return this.membraneDestination;
    }

    protected void setMembraneDestination(Point2D point2D) {
        this.membraneDestination.setLocation(point2D);
    }
}

