/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.genenetwork.model.GeneNetworkModelAdapter;
import edu.colorado.phet.genenetwork.model.IGeneNetworkModelControl;
import edu.colorado.phet.genenetwork.model.LacIGene;
import edu.colorado.phet.genenetwork.model.LacIPromoter;
import edu.colorado.phet.genenetwork.model.LacOperator;
import edu.colorado.phet.genenetwork.model.LacPromoter;
import edu.colorado.phet.genenetwork.model.LacZGene;
import edu.colorado.phet.genenetwork.model.ModelElementListenerAdapter;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaStrand {
    protected IGeneNetworkModelControl model;
    private DoubleGeneralPath strand1Shape = new DoubleGeneralPath();
    private DoubleGeneralPath strand2Shape = new DoubleGeneralPath();
    private final Dimension2D size;
    private Point2D position = new Point2D.Double();
    private DnaSegmentSpace lacIPromoterSpace;
    private DnaSegmentSpace lacIGeneSpace;
    private DnaSegmentSpace lacPromoterSpace;
    private DnaSegmentSpace lacOperatorSpace;
    private DnaSegmentSpace lacZGeneSpace;
    protected ArrayList<DnaSegmentSpace> shapeList = new ArrayList();

    public DnaStrand(IGeneNetworkModelControl iGeneNetworkModelControl, Dimension2D dimension2D, Point2D point2D) {
        this.model = iGeneNetworkModelControl;
        this.size = new PDimension(dimension2D);
        this.setPosition(point2D);
        this.updateStrandShapes();
        this.lacIPromoterSpace = new DnaSegmentSpace(this, new LacIPromoter(null).getShape(), new Point2D.Double(-52.0, 0.0));
        this.lacIGeneSpace = new DnaSegmentSpace(this, new LacIGene(null).getShape(), new Point2D.Double(-35.0, 0.0));
        this.lacPromoterSpace = new DnaSegmentSpace(this, new LacPromoter(null).getShape(), new Point2D.Double(5.0, 0.0));
        this.lacOperatorSpace = new DnaSegmentSpace(this, new LacOperator(null).getShape(), new Point2D.Double(15.0, 0.0));
        this.lacZGeneSpace = new DnaSegmentSpace(this, new LacZGene(null).getShape(), new Point2D.Double(30.0, 0.0));
        this.shapeList.add(this.lacIPromoterSpace);
        this.shapeList.add(this.lacIGeneSpace);
        this.shapeList.add(this.lacPromoterSpace);
        this.shapeList.add(this.lacOperatorSpace);
        this.shapeList.add(this.lacZGeneSpace);
        iGeneNetworkModelControl.addListener(new GeneNetworkModelAdapter(){

            public void modelElementAdded(SimpleModelElement simpleModelElement) {
                DnaStrand.this.handleModelElementAdded(simpleModelElement);
            }
        });
    }

    public Point2D getPositionRef() {
        return this.position;
    }

    public void setPosition(double d, double d2) {
        this.position.setLocation(d, d2);
    }

    public void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public Shape getStrand1Shape() {
        return this.strand1Shape.getGeneralPath();
    }

    public Shape getStrand2Shape() {
        return this.strand2Shape.getGeneralPath();
    }

    public boolean isOnLacZGeneSpace(Point2D point2D) {
        Rectangle2D rectangle2D = this.lacZGeneSpace.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + this.lacZGeneSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX(), rectangle2D.getY() + this.lacZGeneSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + 3.0);
        return double_.contains(point2D);
    }

    public boolean isOnLacYGeneSpace(Point2D point2D) {
        return false;
    }

    public boolean isLacZGeneInPlace() {
        LacZGene lacZGene = this.model.getLacZGene();
        boolean bl = false;
        if (lacZGene != null) {
            double d = this.lacZGeneSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX();
            double d2 = this.lacZGeneSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY();
            if (lacZGene.getPositionRef().getX() + 0.01 > d && lacZGene.getPositionRef().getX() - 0.01 < d && lacZGene.getPositionRef().getY() + 0.01 > d2 && lacZGene.getPositionRef().getY() - 0.01 < d2) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isLacYGeneInPlace() {
        return false;
    }

    public boolean isOnLacIGeneSpace(Point2D point2D) {
        Rectangle2D rectangle2D = this.lacIGeneSpace.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + this.lacIGeneSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX(), rectangle2D.getY() + this.lacIGeneSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + 3.0);
        return double_.contains(point2D);
    }

    public boolean isLacIGeneInPlace() {
        LacIGene lacIGene = this.model.getLacIGene();
        boolean bl = false;
        if (lacIGene != null) {
            double d = this.lacIGeneSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX();
            double d2 = this.lacIGeneSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY();
            if (lacIGene.getPositionRef().getX() + 0.01 > d && lacIGene.getPositionRef().getX() - 0.01 < d && lacIGene.getPositionRef().getY() + 0.01 > d2 && lacIGene.getPositionRef().getY() - 0.01 < d2) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isOnLacOperatorSpace(Point2D point2D) {
        Rectangle2D rectangle2D = this.lacOperatorSpace.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + this.lacOperatorSpace.getOffsetFromDnaStrandPosRef().getX() + this.getPositionRef().getX(), rectangle2D.getY() + this.lacOperatorSpace.getOffsetFromDnaStrandPosRef().getY() + this.getPositionRef().getY(), rectangle2D.getWidth(), rectangle2D.getHeight() + 3.0);
        return double_.contains(point2D);
    }

    public Point2D getLacZGeneLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + this.lacZGeneSpace.getOffsetFromDnaStrandPosRef().getX(), this.getPositionRef().getY() + this.lacZGeneSpace.getOffsetFromDnaStrandPosRef().getY());
    }

    public Point2D getLacYGeneLocation() {
        return null;
    }

    public Point2D getLacIGeneLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + this.lacIGeneSpace.getOffsetFromDnaStrandPosRef().getX(), this.getPositionRef().getY() + this.lacIGeneSpace.getOffsetFromDnaStrandPosRef().getY());
    }

    public Point2D getLacPromoterLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + this.lacPromoterSpace.getOffsetFromDnaStrandPosRef().getX(), this.getPositionRef().getY() + this.lacPromoterSpace.getOffsetFromDnaStrandPosRef().getY());
    }

    public Point2D getLacIPromoterLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + this.lacIPromoterSpace.getOffsetFromDnaStrandPosRef().getX(), this.getPositionRef().getY() + this.lacPromoterSpace.getOffsetFromDnaStrandPosRef().getY());
    }

    public Point2D getLacOperatorLocation() {
        return new Point2D.Double(this.getPositionRef().getX() + this.lacOperatorSpace.getOffsetFromDnaStrandPosRef().getX(), this.getPositionRef().getY() + this.lacOperatorSpace.getOffsetFromDnaStrandPosRef().getY());
    }

    public ArrayList<DnaSegmentSpace> getDnaSegmentSpaces() {
        ArrayList<DnaSegmentSpace> arrayList = new ArrayList<DnaSegmentSpace>(this.shapeList);
        return arrayList;
    }

    protected void handleModelElementAdded(SimpleModelElement simpleModelElement) {
        if (simpleModelElement instanceof LacIPromoter) {
            this.lacIPromoterSpace.setEyeCatching(true);
            this.lacIPromoterSpace.setModelElement(simpleModelElement);
        } else if (simpleModelElement instanceof LacIGene) {
            this.lacIGeneSpace.setEyeCatching(true);
            this.lacIGeneSpace.setModelElement(simpleModelElement);
        } else if (simpleModelElement instanceof LacZGene) {
            this.lacZGeneSpace.setEyeCatching(true);
            this.lacZGeneSpace.setModelElement(simpleModelElement);
        } else if (simpleModelElement instanceof LacPromoter) {
            this.lacPromoterSpace.setEyeCatching(true);
            this.lacPromoterSpace.setModelElement(simpleModelElement);
        } else if (simpleModelElement instanceof LacOperator) {
            this.lacOperatorSpace.setEyeCatching(true);
            this.lacOperatorSpace.setModelElement(simpleModelElement);
        }
    }

    private void updateStrandShapes() {
        double d = -this.size.getWidth() / 2.0;
        double d2 = 0.0;
        this.strand1Shape.moveTo(d, d2);
        this.strand2Shape.moveTo(d + 0.75, d2);
        double d3 = 0.0;
        double d4 = 1.0471975511965976;
        double d5 = d;
        while (d5 - d - 0.75 < this.size.getWidth()) {
            this.strand1Shape.lineTo((float)d5, (float)(-Math.sin(d3) * this.size.getHeight() / 2.0));
            this.strand2Shape.lineTo((double)((float)d5) + 0.75, (float)(-Math.sin(d3) * this.size.getHeight() / 2.0));
            d3 += d4;
            d5 += 0.5;
        }
    }

    public static class DnaSegmentSpace
    extends Area {
        private final DnaStrand dnaStrand;
        private final Point2D offsetFromDnaStrandPos = new Point2D.Double();
        private SimpleModelElement modelElement = null;
        private boolean eyeCatching = false;
        private boolean occupied = false;
        private ModelElementListenerAdapter modelElementListener = new ModelElementListenerAdapter(){

            public void positionChanged() {
                DnaSegmentSpace.this.updateOccupancyState();
            }

            public void removedFromModel() {
                DnaSegmentSpace.this.setEyeCatching(false);
                DnaSegmentSpace.this.modelElement = null;
                DnaSegmentSpace.this.updateOccupancyState();
            }
        };
        protected ArrayList<Listener> listeners = new ArrayList();

        public DnaSegmentSpace(DnaStrand dnaStrand, Shape shape, Point2D point2D) {
            super(shape);
            this.dnaStrand = dnaStrand;
            this.offsetFromDnaStrandPos.setLocation(point2D);
        }

        public void setModelElement(SimpleModelElement simpleModelElement) {
            this.modelElement = simpleModelElement;
            simpleModelElement.addListener(this.modelElementListener);
            this.updateOccupancyState();
        }

        public void addListener(Listener listener) {
            if (this.listeners.contains(listener)) {
                System.err.println(this.getClass().getName() + "- Warning: Attempting to re-add a listener that is already listening.");
                assert (false);
                return;
            }
            this.listeners.add(listener);
        }

        public Point2D getOffsetFromDnaStrandPosRef() {
            return this.offsetFromDnaStrandPos;
        }

        public boolean isEyeCatching() {
            return this.eyeCatching;
        }

        public void setEyeCatching(boolean bl) {
            if (this.eyeCatching != bl) {
                this.eyeCatching = bl;
                this.notifyEyeCatchingStateChanged();
            }
        }

        private Point2D getAbsolutePosition() {
            return new Point2D.Double(this.dnaStrand.getPositionRef().getX() + this.offsetFromDnaStrandPos.getX(), this.dnaStrand.getPositionRef().getY() + this.offsetFromDnaStrandPos.getY());
        }

        public boolean isOccupied() {
            return this.occupied;
        }

        private void updateOccupancyState() {
            if (!this.occupied) {
                if (this.modelElement != null && this.modelElement.getPositionRef().distance(this.getAbsolutePosition()) < 1.0) {
                    this.occupied = true;
                    this.notifyOccupiedStateChanged();
                }
            } else if (this.occupied && (this.modelElement == null || this.modelElement.getPositionRef().distance(this.getAbsolutePosition()) > 1.0)) {
                this.occupied = false;
                this.notifyOccupiedStateChanged();
            }
        }

        private void notifyEyeCatchingStateChanged() {
            for (Listener listener : this.listeners) {
                listener.eyeCatchingStateChange();
            }
        }

        private void notifyOccupiedStateChanged() {
            for (Listener listener : this.listeners) {
                listener.occupiedStateChange();
            }
        }

        public static interface Listener {
            public void eyeCatchingStateChange();

            public void occupiedStateChange();
        }
    }
}

