/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.genenetwork.model.RandomWalkMotionStrategy;
import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class DetachFromDnaThenRandomMotionWalkStrategy
extends RandomWalkMotionStrategy {
    private static double MOVE_UP_TIME = 3.0;
    private static Random RAND = new Random();
    private double delayCounter;
    private double linearMotionCountdown = MOVE_UP_TIME;
    private Vector2D initialVelocity = new Vector2D();

    public DetachFromDnaThenRandomMotionWalkStrategy(Rectangle2D rectangle2D, double d, Vector2D vector2D, double d2) {
        super(rectangle2D);
        this.delayCounter = d;
        if (d2 >= 0.0) {
            this.linearMotionCountdown = d2;
        }
        if (vector2D != null) {
            this.initialVelocity.setComponents(vector2D.getX(), vector2D.getY());
        } else {
            double d3 = RAND.nextDouble() * 10.0 + 5.0;
            double d4 = 0.7853981633974483 + RAND.nextDouble() * 1.5707963267948966;
            this.initialVelocity.setX(d3 * Math.cos(d4));
            this.initialVelocity.setY(d3 * Math.sin(d4));
        }
    }

    public void updatePositionAndMotion(double d, SimpleModelElement simpleModelElement) {
        if (this.delayCounter > 0.0) {
            this.delayCounter -= d;
        } else if (this.linearMotionCountdown > 0.0) {
            this.linearMotionCountdown -= d;
            Point2D point2D = simpleModelElement.getPositionRef();
            simpleModelElement.setPosition(point2D.getX() + this.initialVelocity.getX() * d, point2D.getY() + this.initialVelocity.getY() * d);
        } else {
            super.updatePositionAndMotion(d, simpleModelElement);
        }
    }
}

