/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.genenetwork.model;

import edu.colorado.phet.genenetwork.model.SimpleModelElement;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractMotionStrategy {
    private Point2D destination = null;
    private Rectangle2D bounds = new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public AbstractMotionStrategy(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            this.bounds.setFrame(rectangle2D);
        }
    }

    public AbstractMotionStrategy() {
        this(null);
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
    }

    public void doUpdatePositionAndMotion(double d, SimpleModelElement simpleModelElement) {
        if (!simpleModelElement.isUserControlled()) {
            this.updatePositionAndMotion(d, simpleModelElement);
        }
    }

    public abstract void updatePositionAndMotion(double var1, SimpleModelElement var3);

    public void setDestination(double d, double d2) {
        if (this.destination == null) {
            this.destination = new Point2D.Double();
        }
        this.destination.setLocation(d, d2);
    }

    public void setDestination(Point2D point2D) {
        if (point2D == null) {
            this.destination = null;
        } else {
            this.setDestination(point2D.getX(), point2D.getY());
        }
    }

    public void cleanup() {
    }

    protected Point2D getDestinationRef() {
        return this.destination;
    }
}

