/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.common.piccolophet.nodes.slider.HSliderNode;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LogarithmicParameterSliderNode
extends PNode {
    private static final Font TITLE_FONT = new PhetFont(14);
    private static final Font LABEL_FONT = new PhetFont(12);

    LogarithmicParameterSliderNode(IUserComponent iUserComponent, final double d, final double d2, final SettableProperty<Double> settableProperty, String string) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Can't have a value of 0 or less for a logarithmic slider.");
        }
        if (d > d2) {
            throw new IllegalArgumentException("min value must be smaller than max value.");
        }
        HTMLNode hTMLNode = new HTMLNode(string){
            {
                this.setFont(TITLE_FONT);
            }
        };
        double d3 = Math.log10(d);
        double d4 = Math.log10(d2);
        final Property<Double> property = new Property<Double>(Math.log10((Double)settableProperty.get()));
        HSliderNode hSliderNode = new HSliderNode(iUserComponent, d3, d4, 4.0, 100.0, property, new BooleanProperty(true)){
            {
                this.setTrackFillPaint(Color.black);
            }
        };
        property.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d3) {
                settableProperty.set(MathUtil.clamp(d, Math.pow(10.0, d3), d2));
            }
        });
        settableProperty.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                property.set(Math.log10(d));
            }
        });
        hSliderNode.addLabel(d3, new PText(GeneExpressionBasicsResources.Strings.LOW){
            {
                this.setFont(LABEL_FONT);
            }
        });
        hSliderNode.addLabel(d4, new PText(GeneExpressionBasicsResources.Strings.HIGH){
            {
                this.setFont(LABEL_FONT);
            }
        });
        this.addChild(new VBox(0.0, hTMLNode, hSliderNode));
    }
}

