/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ObservableList;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.geneexpressionbasics.multiplecells.model.Cell;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleCellsModel
implements Resettable {
    private final ConstantDtClock clock = new ConstantDtClock(30.0);
    private final List<Cell> cellList = new ArrayList<Cell>();
    public final ObservableList<Cell> visibleCellList = new ObservableList();
    public final Property<Integer> numberOfVisibleCells = new Property<Integer>(1);
    public final Property<Integer> transcriptionFactorLevel = new Property<Integer>(2000);
    public final Property<Double> proteinDegradationRate = new Property<Double>((double)4.0E-4f);
    public final Property<Double> transcriptionFactorAssociationProbability = new Property<Double>(2.5E-6);
    public final Property<Double> polymeraseAssociationProbability = new Property<Double>(9.5E-7);
    public final Property<Double> mRnaDegradationRate = new Property<Double>(0.01);
    public final Property<Double> averageProteinLevel = new Property<Double>(0.0);

    public MultipleCellsModel() {
        this.clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                MultipleCellsModel.this.stepInTime(clockEvent.getSimulationTimeChange());
            }
        });
        Random random = new Random(5L);
        Random random2 = new Random(226L);
        while (this.cellList.size() < 90) {
            Cell cell;
            if (this.cellList.isEmpty()) {
                cell = new Cell(Cell.DEFAULT_CELL_SIZE, new Point2D.Double(0.0, 0.0), 0.0, 0L);
            } else {
                double d = Math.max(Cell.DEFAULT_CELL_SIZE.getWidth() * (random.nextDouble() / 2.0 + 0.75), Cell.DEFAULT_CELL_SIZE.getHeight() * 2.0);
                cell = new Cell(new PDimension(d, Cell.DEFAULT_CELL_SIZE.getHeight()), new Point2D.Double(0.0, 0.0), Math.PI * 2 * random.nextDouble(), this.cellList.size());
                MultipleCellsModel.placeCellInOpenLocation(cell, this.cellList, random2);
            }
            this.cellList.add(cell);
        }
        this.numberOfVisibleCells.addObserver(new VoidFunction1<Integer>(){

            @Override
            public void apply(Integer n) {
                assert (n >= 1 && n <= 90);
                MultipleCellsModel.this.setNumVisibleCells(n);
            }
        });
        this.transcriptionFactorLevel.addObserver(new VoidFunction1<Integer>(){

            @Override
            public void apply(Integer n) {
                for (Cell cell : MultipleCellsModel.this.cellList) {
                    cell.setTranscriptionFactorCount(n);
                }
            }
        });
        this.polymeraseAssociationProbability.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                for (Cell cell : MultipleCellsModel.this.cellList) {
                    cell.setPolymeraseAssociationRate(d);
                }
            }
        });
        this.transcriptionFactorAssociationProbability.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                for (Cell cell : MultipleCellsModel.this.cellList) {
                    cell.setGeneTranscriptionFactorAssociationRate(d);
                }
            }
        });
        this.proteinDegradationRate.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                for (Cell cell : MultipleCellsModel.this.cellList) {
                    cell.setProteinDegradationRate(d);
                }
            }
        });
        this.mRnaDegradationRate.addObserver(new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                for (Cell cell : MultipleCellsModel.this.cellList) {
                    cell.setMRnaDegradationRate(d);
                }
            }
        });
    }

    private void stepInTime(double d) {
        for (Cell object : this.cellList) {
            object.stepInTime(d);
        }
        int n = 0;
        for (Cell cell : this.visibleCellList) {
            cell.stepInTime(d);
            n += cell.proteinCount.get().intValue();
        }
        this.averageProteinLevel.set((double)n / (double)this.visibleCellList.size());
    }

    public IClock getClock() {
        return this.clock;
    }

    @Override
    public void reset() {
        this.numberOfVisibleCells.reset();
        this.transcriptionFactorLevel.reset();
        this.proteinDegradationRate.reset();
        this.transcriptionFactorAssociationProbability.reset();
        this.polymeraseAssociationProbability.reset();
        this.mRnaDegradationRate.reset();
        this.setNumVisibleCells(this.numberOfVisibleCells.get());
        for (int i = 0; i < 1000; ++i) {
            this.stepInTime(this.clock.getDt());
        }
    }

    private void setNumVisibleCells(int n) {
        block4: {
            block3: {
                assert (n > 0 && n <= 90);
                n = MathUtil.clamp(1, n, 90);
                if (this.visibleCellList.size() >= n) break block3;
                while (this.visibleCellList.size() < n) {
                    this.visibleCellList.add(this.cellList.get(this.visibleCellList.size()));
                }
                break block4;
            }
            if (this.visibleCellList.size() <= n) break block4;
            while (this.visibleCellList.size() > n) {
                this.visibleCellList.remove(this.visibleCellList.size() - 1);
            }
        }
    }

    private static void placeCellInOpenLocation(Cell cell, List<Cell> list, Random random) {
        double d = Cell.DEFAULT_CELL_SIZE.getWidth() * 20.0;
        double d2 = d * 0.35;
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
        for (int i = 0; i < (int)Math.ceil(Math.sqrt(list.size())); ++i) {
            double d3 = (double)(i + 1) * Cell.DEFAULT_CELL_SIZE.getWidth() * (random.nextDouble() / 2.0 + 0.75);
            int n = 0;
            while ((double)n < d3 * Math.PI / (Cell.DEFAULT_CELL_SIZE.getHeight() * 2.0)) {
                double d4 = random.nextDouble() * 2.0 * Math.PI;
                cell.setPosition(d3 * Math.cos(d4), d3 * Math.sin(d4));
                if (double_.contains(cell.getPosition().toPoint2D())) {
                    boolean bl = false;
                    for (Cell cell2 : list) {
                        if (!MultipleCellsModel.rectanglesOverlap(cell.getEnclosingRectVertices(), cell2.getEnclosingRectVertices())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return;
                    }
                }
                ++n;
            }
        }
        System.out.println("Warning: Exiting placement loop without having found open location.");
    }

    public Rectangle2D getVisibleCellCollectionBounds() {
        double d = 0.0;
        double d2 = 0.0;
        for (Cell cell : this.visibleCellList) {
            Rectangle2D rectangle2D = cell.getShape().getBounds2D();
            d = Math.max(d, Math.abs(rectangle2D.getMinX()));
            d = Math.max(d, Math.abs(rectangle2D.getMaxX()));
            d2 = Math.max(d2, Math.abs(rectangle2D.getMinY()));
            d2 = Math.max(d2, Math.abs(rectangle2D.getMaxY()));
        }
        return new Rectangle2D.Double(-d, -d2, 2.0 * d, 2.0 * d2);
    }

    private static boolean rectanglesOverlap(List<Point2D> list, List<Point2D> list2) {
        if (list.size() != 4 || list2.size() != 4) {
            throw new IllegalArgumentException("Rectangles must have exactly four vertices.");
        }
        boolean bl = false;
        for (int i = 0; i < 4; ++i) {
            MutableVector2D mutableVector2D = new MutableVector2D(list.get(i).getX() - list.get((i + 1) % 4).getX(), list.get(i).getY() - list.get((i + 1) % 4).getY());
            mutableVector2D.setComponents(-mutableVector2D.getY(), mutableVector2D.getX());
            double d = 0.0;
            for (int j = 0; j < 4; ++j) {
                d += MultipleCellsModel.sideSign(mutableVector2D, list.get(i), list2.get(j));
            }
            if (Math.abs(d) != 4.0) continue;
            double d2 = 0.0;
            for (int j = 0; j < 4; ++j) {
                d2 += MultipleCellsModel.sideSign(mutableVector2D, list.get(i), list.get(j));
            }
            assert (Math.abs(d2) == 2.0);
            if (Math.signum(d) != -Math.signum(d2)) continue;
            bl = true;
            break;
        }
        return !bl;
    }

    private static double sideSign(MutableVector2D mutableVector2D, Point2D point2D, Point2D point2D2) {
        return Math.signum(mutableVector2D.getX() * (point2D2.getX() - point2D.getX()) + mutableVector2D.getY() * (point2D2.getY() - point2D.getY()));
    }
}

