/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.multiplecells.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.geneexpressionbasics.common.model.BioShapeUtils;
import edu.colorado.phet.geneexpressionbasics.common.model.ShapeChangingModelElement;
import edu.colorado.phet.geneexpressionbasics.multiplecells.model.CellProteinSynthesisSimulator;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cell
extends ShapeChangingModelElement {
    public static final Dimension2D DEFAULT_CELL_SIZE = new PDimension(2.0E-6, 7.5E-7);
    private final CellProteinSynthesisSimulator proteinSynthesisSimulator = new CellProteinSynthesisSimulator(100);
    public final Property<Integer> proteinCount = new Property<Integer>(0);
    private final List<Point2D> enclosingRectVertices = new ArrayList<Point2D>(4);

    public Cell(Dimension2D dimension2D, Point2D point2D, double d, long l) {
        super(Cell.createShape(dimension2D, point2D, d, l));
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d);
        affineTransform.concatenate(AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY()));
        this.enclosingRectVertices.add(affineTransform.transform(new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight() / 2.0), null));
        this.enclosingRectVertices.add(affineTransform.transform(new Point2D.Double(dimension2D.getWidth() / 2.0, -dimension2D.getHeight() / 2.0), null));
        this.enclosingRectVertices.add(affineTransform.transform(new Point2D.Double(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight() / 2.0), null));
        this.enclosingRectVertices.add(affineTransform.transform(new Point2D.Double(-dimension2D.getWidth() / 2.0, dimension2D.getHeight() / 2.0), null));
    }

    public void stepInTime(double d) {
        this.proteinSynthesisSimulator.stepInTime(d * 1000.0);
        this.proteinCount.set(this.proteinSynthesisSimulator.getProteinCount());
    }

    private static Shape createShape(Dimension2D dimension2D, Point2D point2D, double d, long l) {
        return BioShapeUtils.createEColiLikeShape(point2D, dimension2D.getWidth(), dimension2D.getHeight(), d, l);
    }

    public List<Point2D> getEnclosingRectVertices() {
        return this.enclosingRectVertices;
    }

    @Override
    public void translate(Vector2D vector2D) {
        super.translate(vector2D);
        for (Point2D point2D : this.enclosingRectVertices) {
            point2D.setLocation(point2D.getX() + vector2D.getX(), point2D.getY() + vector2D.getY());
        }
    }

    public void setTranscriptionFactorCount(int n) {
        this.proteinSynthesisSimulator.setTranscriptionFactorCount(n);
    }

    public void setGeneTranscriptionFactorAssociationRate(double d) {
        this.proteinSynthesisSimulator.setGeneTranscriptionFactorAssociationRate(d);
    }

    public void setPolymeraseAssociationRate(double d) {
        this.proteinSynthesisSimulator.setPolymeraseAssociationRate(d);
    }

    public void setProteinDegradationRate(double d) {
        this.proteinSynthesisSimulator.setProteinDegradationRate(d);
    }

    public void setMRnaDegradationRate(double d) {
        this.proteinSynthesisSimulator.setMrnaDegradationRate(d);
    }
}

