/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.mrnaproduction.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.common.view.DnaMoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.mrnaproduction.view.AffinityController;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolymeraseAffinityControlPanel
extends PNode {
    private static final ModelViewTransform POLYMERASE_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.08);
    private static final ModelViewTransform DNA_AND_TF_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.08);

    public PolymeraseAffinityControlPanel(TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig, double d, Property<Double> property) {
        PText pText = new PText(GeneExpressionBasicsResources.Strings.RNA_POLYMERASE){
            {
                this.setFont(new PhetFont(16, true));
            }
        };
        MobileBiomoleculeNode mobileBiomoleculeNode = new MobileBiomoleculeNode(POLYMERASE_MVT, new RnaPolymerase());
        DnaMoleculeNode dnaMoleculeNode = new DnaMoleculeNode(new DnaMolecule(21, 0.0, true), DNA_AND_TF_MVT, 2.0f, false);
        MobileBiomoleculeNode mobileBiomoleculeNode2 = new MobileBiomoleculeNode(DNA_AND_TF_MVT, new TranscriptionFactor(transcriptionFactorConfig));
        mobileBiomoleculeNode2.setOffset(25.0, 0.0);
        dnaMoleculeNode.addChild(mobileBiomoleculeNode2);
        SpacerNode spacerNode = new SpacerNode();
        SpacerNode spacerNode2 = new SpacerNode();
        VBox vBox = new VBox(20.0, pText, spacerNode, new AffinityController(mobileBiomoleculeNode, dnaMoleculeNode, new Property<Double>(0.0)), spacerNode2);
        ControlPanelNode controlPanelNode = new ControlPanelNode((PNode)vBox);
        double d2 = d - controlPanelNode.getFullBoundsReference().height;
        spacerNode.setSize(1.0E-7, d2 * 0.25);
        spacerNode2.setSize(1.0E-7, d2 * 0.75);
        VBox vBox2 = new VBox(20.0, pText, spacerNode, new AffinityController(mobileBiomoleculeNode, dnaMoleculeNode, property), spacerNode2);
        ControlPanelNode controlPanelNode2 = new ControlPanelNode((PNode)vBox2);
        this.addChild(controlPanelNode2);
    }

    private static class SpacerNode
    extends PNode {
        private final PPath spacer;

        public SpacerNode() {
            this(1.0E-7, 1.0E-7);
        }

        public SpacerNode(double d, double d2) {
            this.spacer = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, d, d2), (Paint)new Color(0, 0, 0, 0));
            this.addChild(this.spacer);
        }

        public void setSize(double d, double d2) {
            this.spacer.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
        }
    }
}

