/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.Gene;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRnaDestroyer;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Ribosome;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.ManualGeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.BiomoleculeCreatorNode;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.ManualGeneExpressionCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.swing.SwingLayoutNode;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class BiomoleculeToolBoxNode
extends PNode {
    private static final Font TITLE_FONT = new PhetFont(20, true);
    private final ManualGeneExpressionModel model;
    private final ManualGeneExpressionCanvas canvas;
    protected final ModelViewTransform mvt;
    private final List<BiomoleculeCreatorNode> biomoleculeCreatorNodeList = new ArrayList<BiomoleculeCreatorNode>();

    public BiomoleculeToolBoxNode(ManualGeneExpressionModel manualGeneExpressionModel, ManualGeneExpressionCanvas manualGeneExpressionCanvas, ModelViewTransform modelViewTransform, final Gene gene) {
        this.model = manualGeneExpressionModel;
        this.canvas = manualGeneExpressionCanvas;
        this.mvt = modelViewTransform;
        SwingLayoutNode swingLayoutNode = new SwingLayoutNode(new GridBagLayout()){
            {
                super(layoutManager);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 2;
                this.addChild(new PText(GeneExpressionBasicsResources.Strings.BIOMOLECULE_TOOLBOX){
                    {
                        this.setFont(TITLE_FONT);
                    }
                }, gridBagConstraints);
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 21;
                gridBagConstraints.insets.top = 10;
                gridBagConstraints.insets.left = 0;
                for (TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig : gene.getTranscriptionFactorConfigs()) {
                    if (!transcriptionFactorConfig.isPositive) continue;
                    this.addChild(new RowLabel(GeneExpressionBasicsResources.Strings.POSITIVE_TRANSCRIPTION_FACTOR_HTML), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.insets.left = 20;
                    this.addChild(new HBox(BiomoleculeToolBoxNode.this.addCreatorNode(new TranscriptionFactorCreatorNode(BiomoleculeToolBoxNode.this, transcriptionFactorConfig))), gridBagConstraints);
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.insets.left = 0;
                }
                this.addChild(new RowLabel(GeneExpressionBasicsResources.Strings.RNA_POLYMERASE), gridBagConstraints);
                ++gridBagConstraints.gridx;
                gridBagConstraints.insets.left = 20;
                this.addChild(new HBox(BiomoleculeToolBoxNode.this.addCreatorNode(new RnaPolymeraseCreatorNode(BiomoleculeToolBoxNode.this)), BiomoleculeToolBoxNode.this.addCreatorNode(new RnaPolymeraseCreatorNode(BiomoleculeToolBoxNode.this))), gridBagConstraints);
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets.left = 0;
                this.addChild(new RowLabel(GeneExpressionBasicsResources.Strings.RIBOSOME), gridBagConstraints);
                ++gridBagConstraints.gridx;
                gridBagConstraints.insets.left = 20;
                this.addChild(new HBox(BiomoleculeToolBoxNode.this.addCreatorNode(new RibosomeCreatorNode(BiomoleculeToolBoxNode.this)), BiomoleculeToolBoxNode.this.addCreatorNode(new RibosomeCreatorNode(BiomoleculeToolBoxNode.this))), gridBagConstraints);
                gridBagConstraints.gridx = 0;
                ++gridBagConstraints.gridy;
                gridBagConstraints.insets.left = 0;
                this.addChild(new RowLabel(GeneExpressionBasicsResources.Strings.MRNA_DESTROYER), gridBagConstraints);
                ++gridBagConstraints.gridx;
                gridBagConstraints.insets.left = 20;
                this.addChild(new HBox(BiomoleculeToolBoxNode.this.addCreatorNode(new MessengerRnaDestroyerCreatorNode(BiomoleculeToolBoxNode.this)), BiomoleculeToolBoxNode.this.addCreatorNode(new MessengerRnaDestroyerCreatorNode(BiomoleculeToolBoxNode.this))), gridBagConstraints);
                for (TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig : gene.getTranscriptionFactorConfigs()) {
                    if (transcriptionFactorConfig.isPositive) continue;
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.insets.left = 0;
                    this.addChild(new RowLabel(GeneExpressionBasicsResources.Strings.NEGATIVE_TRANSCRIPTION_FACTOR_HTML), gridBagConstraints);
                    ++gridBagConstraints.gridx;
                    gridBagConstraints.insets.left = 20;
                    this.addChild(new HBox(BiomoleculeToolBoxNode.this.addCreatorNode(new TranscriptionFactorCreatorNode(BiomoleculeToolBoxNode.this, transcriptionFactorConfig))), gridBagConstraints);
                }
            }
        };
        this.addChild(new ControlPanelNode((PNode)swingLayoutNode, new Color(250, 250, 250)));
    }

    public void reset() {
        for (BiomoleculeCreatorNode biomoleculeCreatorNode : this.biomoleculeCreatorNodeList) {
            biomoleculeCreatorNode.reset();
        }
    }

    private BiomoleculeCreatorNode addCreatorNode(BiomoleculeCreatorNode biomoleculeCreatorNode) {
        this.biomoleculeCreatorNodeList.add(biomoleculeCreatorNode);
        return biomoleculeCreatorNode;
    }

    private static class MessengerRnaDestroyerCreatorNode
    extends BiomoleculeCreatorNode {
        private static final ModelViewTransform SCALING_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.07);

        private MessengerRnaDestroyerCreatorNode(BiomoleculeToolBoxNode biomoleculeToolBoxNode) {
            super(new MobileBiomoleculeNode(SCALING_MVT, new MessengerRnaDestroyer(new StubGeneExpressionModel())), biomoleculeToolBoxNode.canvas, biomoleculeToolBoxNode.mvt, new Function1<Vector2D, MobileBiomolecule>(){

                @Override
                public MobileBiomolecule apply(Vector2D vector2D) {
                    MessengerRnaDestroyer messengerRnaDestroyer = new MessengerRnaDestroyer(BiomoleculeToolBoxNode.this.model, vector2D);
                    BiomoleculeToolBoxNode.this.model.addMobileBiomolecule(messengerRnaDestroyer);
                    return messengerRnaDestroyer;
                }
            }, new VoidFunction1<MobileBiomolecule>(){

                @Override
                public void apply(MobileBiomolecule mobileBiomolecule) {
                    BiomoleculeToolBoxNode.this.model.removeMobileBiomolecule(mobileBiomolecule);
                }
            }, biomoleculeToolBoxNode);
        }
    }

    private static class RibosomeCreatorNode
    extends BiomoleculeCreatorNode {
        private static final ModelViewTransform SCALING_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.07);

        private RibosomeCreatorNode(BiomoleculeToolBoxNode biomoleculeToolBoxNode) {
            super(new MobileBiomoleculeNode(SCALING_MVT, new Ribosome(new StubGeneExpressionModel())), biomoleculeToolBoxNode.canvas, biomoleculeToolBoxNode.mvt, new Function1<Vector2D, MobileBiomolecule>(){

                @Override
                public MobileBiomolecule apply(Vector2D vector2D) {
                    Ribosome ribosome = new Ribosome(BiomoleculeToolBoxNode.this.model, vector2D);
                    BiomoleculeToolBoxNode.this.model.addMobileBiomolecule(ribosome);
                    return ribosome;
                }
            }, new VoidFunction1<MobileBiomolecule>(){

                @Override
                public void apply(MobileBiomolecule mobileBiomolecule) {
                    BiomoleculeToolBoxNode.this.model.removeMobileBiomolecule(mobileBiomolecule);
                }
            }, biomoleculeToolBoxNode);
        }
    }

    private static class RnaPolymeraseCreatorNode
    extends BiomoleculeCreatorNode {
        private static final ModelViewTransform SCALING_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.07);

        private RnaPolymeraseCreatorNode(BiomoleculeToolBoxNode biomoleculeToolBoxNode) {
            super(new MobileBiomoleculeNode(SCALING_MVT, new RnaPolymerase()), biomoleculeToolBoxNode.canvas, biomoleculeToolBoxNode.mvt, new Function1<Vector2D, MobileBiomolecule>(){

                @Override
                public MobileBiomolecule apply(Vector2D vector2D) {
                    RnaPolymerase rnaPolymerase = new RnaPolymerase(BiomoleculeToolBoxNode.this.model, vector2D);
                    BiomoleculeToolBoxNode.this.model.addMobileBiomolecule(rnaPolymerase);
                    return rnaPolymerase;
                }
            }, new VoidFunction1<MobileBiomolecule>(){

                @Override
                public void apply(MobileBiomolecule mobileBiomolecule) {
                    BiomoleculeToolBoxNode.this.model.removeMobileBiomolecule(mobileBiomolecule);
                }
            }, biomoleculeToolBoxNode);
        }
    }

    private static class RowLabel
    extends HTMLNode {
        private RowLabel(String string) {
            super(string);
            this.setFont(new PhetFont(16));
        }
    }

    private static class TranscriptionFactorCreatorNode
    extends BiomoleculeCreatorNode {
        private static final ModelViewTransform SCALING_MVT = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), 0.07);

        private TranscriptionFactorCreatorNode(BiomoleculeToolBoxNode biomoleculeToolBoxNode, final TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
            super(new MobileBiomoleculeNode(SCALING_MVT, new TranscriptionFactor((GeneExpressionModel)new StubGeneExpressionModel(), transcriptionFactorConfig, new Vector2D(0.0, 0.0))), biomoleculeToolBoxNode.canvas, biomoleculeToolBoxNode.mvt, new Function1<Vector2D, MobileBiomolecule>(){

                @Override
                public MobileBiomolecule apply(Vector2D vector2D) {
                    TranscriptionFactor transcriptionFactor = new TranscriptionFactor((GeneExpressionModel)BiomoleculeToolBoxNode.this.model, transcriptionFactorConfig, vector2D);
                    BiomoleculeToolBoxNode.this.model.addMobileBiomolecule(transcriptionFactor);
                    return transcriptionFactor;
                }
            }, new VoidFunction1<MobileBiomolecule>(){

                @Override
                public void apply(MobileBiomolecule mobileBiomolecule) {
                    BiomoleculeToolBoxNode.this.model.removeMobileBiomolecule(mobileBiomolecule);
                }
            }, biomoleculeToolBoxNode);
        }
    }
}

