/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.view.ManualGeneExpressionCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BiomoleculeCreatorNode
extends PComposite {
    private MobileBiomolecule biomolecule = null;
    private final ModelViewTransform mvt;
    private final ManualGeneExpressionCanvas canvas;
    private VoidFunction1<Boolean> observer;
    private final PNode appearanceNode;

    public BiomoleculeCreatorNode(PPath pPath, ManualGeneExpressionCanvas manualGeneExpressionCanvas, final ModelViewTransform modelViewTransform, final Function1<Vector2D, MobileBiomolecule> function1, final VoidFunction1<MobileBiomolecule> voidFunction1, final PNode pNode) {
        this.canvas = manualGeneExpressionCanvas;
        this.mvt = modelViewTransform;
        this.appearanceNode = pPath;
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                BiomoleculeCreatorNode.this.appearanceNode.setTransparency(0.3f);
                BiomoleculeCreatorNode.this.setPickable(false);
                BiomoleculeCreatorNode.this.setChildrenPickable(false);
                BiomoleculeCreatorNode.this.biomolecule = (MobileBiomolecule)function1.apply(new Vector2D(BiomoleculeCreatorNode.this.getModelPosition(pInputEvent.getCanvasPosition())));
                ((BiomoleculeCreatorNode)BiomoleculeCreatorNode.this).biomolecule.userControlled.set(true);
                final MobileBiomolecule mobileBiomolecule = BiomoleculeCreatorNode.this.biomolecule;
                BiomoleculeCreatorNode.this.observer = new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        if (!bl.booleanValue() && pNode.getFullBoundsReference().contains(modelViewTransform.modelToView(mobileBiomolecule.getPosition()).toPoint2D())) {
                            voidFunction1.apply(mobileBiomolecule);
                            mobileBiomolecule.userControlled.removeObserver(this);
                            BiomoleculeCreatorNode.this.appearanceNode.setTransparency(1.0f);
                            BiomoleculeCreatorNode.this.setPickable(true);
                            BiomoleculeCreatorNode.this.setChildrenPickable(true);
                        }
                    }
                };
                ((BiomoleculeCreatorNode)BiomoleculeCreatorNode.this).biomolecule.userControlled.addObserver(BiomoleculeCreatorNode.this.observer);
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                BiomoleculeCreatorNode.this.biomolecule.setPosition(new Vector2D(BiomoleculeCreatorNode.this.getModelPosition(pInputEvent.getCanvasPosition())));
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                ((BiomoleculeCreatorNode)BiomoleculeCreatorNode.this).biomolecule.userControlled.set(false);
                BiomoleculeCreatorNode.this.biomolecule = null;
            }
        });
        this.addChild(pPath);
    }

    public void reset() {
        if (this.biomolecule != null) {
            this.biomolecule.userControlled.removeObserver(this.observer);
            this.biomolecule = null;
        }
        this.appearanceNode.setTransparency(1.0f);
        this.setPickable(true);
        this.setChildrenPickable(true);
    }

    private Point2D getModelPosition(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        this.canvas.getPhetRootNode().screenToWorld(double_);
        Point2D.Double double_2 = new Point2D.Double(((Point2D)double_).getX() - this.canvas.getViewportOffset().getX(), ((Point2D)double_).getY() - this.canvas.getViewportOffset().getY());
        return this.mvt.viewToModel(double_2);
    }
}

