/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.multiplecells.view.ColorChangingCellNode;
import java.awt.Color;
import java.awt.Shape;

public class ProteinC
extends Protein {
    private static final Color BASE_COLOR = ColorChangingCellNode.FLORESCENT_FILL_COLOR;

    public ProteinC() {
        this(new StubGeneExpressionModel());
    }

    protected ProteinC(GeneExpressionModel geneExpressionModel) {
        super(geneExpressionModel, ProteinC.createInitialShape(), BASE_COLOR);
    }

    protected Shape getUntranslatedShape(double d) {
        return ProteinC.createShape(d);
    }

    public Protein createInstance() {
        return new ProteinC(this.model);
    }

    public void setAttachmentPointPosition(Vector2D vector2D) {
        this.setPosition(vector2D.getX() + 38.4 * this.getFullSizeProportion(), vector2D.getY() + 144.0 * this.getFullSizeProportion());
    }

    private static Shape createInitialShape() {
        return ProteinC.createShape(0.0);
    }

    private static Shape createShape(double d) {
        double d2 = MathUtil.clamp(0.01, d, 1.0) * 320.0;
        double d3 = d2 * 1.4;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        double d4 = 0.55;
        double d5 = 0.4;
        doubleGeneralPath.moveTo(-d2 * 0.45, d3 * 0.45);
        doubleGeneralPath.curveTo(-d2 * 0.33, d3 * d4, d2 * 0.3, d3 * d4, d2 * 0.45, d3 * 0.45);
        doubleGeneralPath.curveTo(d2 * d5, d3 * 0.33, d2 * d5, -d3 * 0.33, d2 * 0.45, -d3 * 0.45);
        doubleGeneralPath.curveTo(d2 * 0.33, -d3 * d4, -d2 * 0.3, -d3 * d4, -d2 * 0.45, -d3 * 0.45);
        doubleGeneralPath.curveTo(-d2 * d5, -d3 * 0.33, -d2 * d5, d3 * 0.33, -d2 * 0.45, d3 * 0.45);
        return doubleGeneralPath.getGeneralPath();
    }
}

