/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.view;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.MessengerRna;
import edu.colorado.phet.geneexpressionbasics.common.view.MobileBiomoleculeNode;
import edu.colorado.phet.geneexpressionbasics.common.view.PlacementHintNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.Timer;

public class MessengerRnaNode
extends MobileBiomoleculeNode {
    public MessengerRnaNode(final ModelViewTransform modelViewTransform, final MessengerRna messengerRna) {
        super(modelViewTransform, messengerRna, new BasicStroke(2.0f));
        this.addChild(new PlacementHintNode(modelViewTransform, messengerRna.ribosomePlacementHint));
        this.addChild(new PlacementHintNode(modelViewTransform, messengerRna.mRnaDestroyerPlacementHint));
        final FadeLabel fadeLabel = new FadeLabel(GeneExpressionBasicsResources.Strings.M_RNA, false, messengerRna.existenceStrength);
        this.addChild(fadeLabel);
        messengerRna.beingSynthesized.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    fadeLabel.startFadeIn(3000.0);
                } else {
                    fadeLabel.startFadeOut(1000.0);
                }
            }
        });
        messengerRna.addShapeChangeObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                Point2D point2D = modelViewTransform.modelToView(new Point2D.Double(messengerRna.getShape().getBounds2D().getMaxX(), messengerRna.getShape().getBounds().getMaxY()));
                fadeLabel.setOffset(point2D.getX(), point2D.getY());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FadeLabel
    extends PNode {
        private static final Font FONT = new PhetFont(14);
        private final Timer fadeInTimer;
        private final Timer fadeOutTimer;
        private double opacity;
        private double fadeDelta;
        private final Property<Double> existenceStrength;

        public FadeLabel(String string, boolean bl, final Property<Double> property) {
            this.existenceStrength = property;
            PText pText = new PText(string){
                {
                    this.setFont(FONT);
                }
            };
            this.addChild(pText);
            if (!bl) {
                this.setTransparency(0.0f);
                this.opacity = 0.0;
            } else {
                this.opacity = 1.0;
            }
            this.fadeInTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FadeLabel.this.opacity = Math.min(FadeLabel.this.opacity + FadeLabel.this.fadeDelta, (Double)property.get());
                    FadeLabel.this.updateTransparency();
                    if (FadeLabel.this.opacity >= 1.0) {
                        FadeLabel.this.fadeInTimer.stop();
                    }
                }
            });
            this.fadeOutTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FadeLabel.this.opacity = Math.min(Math.max(FadeLabel.this.opacity - FadeLabel.this.fadeDelta, 0.0), (Double)property.get());
                    FadeLabel.this.updateTransparency();
                    if (FadeLabel.this.opacity <= 0.0) {
                        FadeLabel.this.fadeOutTimer.stop();
                    }
                }
            });
            property.addObserver(new SimpleObserver(){

                public void update() {
                    FadeLabel.this.updateTransparency();
                }
            });
        }

        public void startFadeIn(double d) {
            if (this.fadeOutTimer.isRunning()) {
                this.fadeOutTimer.stop();
            }
            this.fadeDelta = 100.0 / d;
            this.fadeInTimer.restart();
        }

        public void startFadeOut(double d) {
            if (this.fadeInTimer.isRunning()) {
                this.fadeInTimer.stop();
            }
            this.fadeDelta = 100.0 / d;
            this.fadeOutTimer.restart();
        }

        private void updateTransparency() {
            this.setTransparency((float)Math.min(this.existenceStrength.get(), this.opacity));
        }
    }
}

