/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.view;

import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.geneexpressionbasics.GeneExpressionBasicsResources;
import edu.colorado.phet.geneexpressionbasics.common.model.BasePair;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.view.GeneNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public class DnaMoleculeNode
extends PNode {
    private static final Color STRAND_1_COLOR = new Color(31, 163, 223);
    private static final Color STRAND_2_COLOR = new Color(214, 87, 107);
    private final PNode dnaBackboneBackLayer = new PNode();
    private final PNode dnaBackboneFrontLayer = new PNode();

    public DnaMoleculeNode(DnaMolecule dnaMolecule, ModelViewTransform modelViewTransform, float f, boolean bl) {
        PNode pNode = new PNode();
        this.addChild(pNode);
        this.addChild(this.dnaBackboneBackLayer);
        PNode pNode2 = new PNode();
        this.addChild(pNode2);
        this.addChild(this.dnaBackboneFrontLayer);
        for (int i = 0; i < dnaMolecule.getGenes().size(); ++i) {
            pNode.addChild(new GeneNode(modelViewTransform, dnaMolecule.getGenes().get(i), dnaMolecule, GeneExpressionBasicsResources.Strings.GENE + (i + 1), bl));
        }
        for (DnaMolecule.DnaStrandSegment object : dnaMolecule.getStrand1Segments()) {
            this.addStrand(modelViewTransform, object, new BasicStroke(f), STRAND_1_COLOR);
        }
        for (DnaMolecule.DnaStrandSegment dnaStrandSegment : dnaMolecule.getStrand2Segments()) {
            this.addStrand(modelViewTransform, dnaStrandSegment, new BasicStroke(f), STRAND_2_COLOR);
        }
        for (BasePair basePair : dnaMolecule.getBasePairs()) {
            pNode2.addChild(new PhetPPath(modelViewTransform.modelToView(basePair.getShape()), (Paint)Color.DARK_GRAY));
        }
    }

    private void addStrand(ModelViewTransform modelViewTransform, DnaMolecule.DnaStrandSegment dnaStrandSegment, Stroke stroke, Color color) {
        DnaStrandSegmentNode dnaStrandSegmentNode = new DnaStrandSegmentNode(dnaStrandSegment, modelViewTransform, stroke, color);
        if (dnaStrandSegment.inFront) {
            this.dnaBackboneFrontLayer.addChild(dnaStrandSegmentNode);
        } else {
            this.dnaBackboneBackLayer.addChild(dnaStrandSegmentNode);
        }
    }

    private class DnaStrandSegmentNode
    extends PNode {
        private DnaStrandSegmentNode(DnaMolecule.DnaStrandSegment dnaStrandSegment, final ModelViewTransform modelViewTransform, Stroke stroke, Color color) {
            final PhetPPath phetPPath = new PhetPPath(stroke, (Paint)color);
            this.addChild(phetPPath);
            dnaStrandSegment.addShapeChangeObserver(new VoidFunction1<Shape>(){

                @Override
                public void apply(Shape shape) {
                    phetPPath.setPathTo(modelViewTransform.modelToView(shape));
                }
            });
        }
    }
}

