/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines;

import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.common.model.Ribosome;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentState;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.AttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.attachmentstatemachines.GenericAttachmentStateMachine;
import edu.colorado.phet.geneexpressionbasics.common.model.motionstrategies.RibosomeTranslatingRnaMotionStrategy;

public class RibosomeAttachmentStateMachine
extends GenericAttachmentStateMachine {
    private final Ribosome ribosome;
    private Protein proteinBeingSynthesized;

    public RibosomeAttachmentStateMachine(MobileBiomolecule mobileBiomolecule) {
        super(mobileBiomolecule);
        this.ribosome = (Ribosome)mobileBiomolecule;
        this.setDestinationOffset(Ribosome.OFFSET_TO_TRANSLATION_CHANNEL_ENTRANCE);
        this.attachedState = new RibosomeAttachedState();
    }

    public void forceImmediateUnattachedAndAvailable() {
        if (this.ribosome.getMessengerRnaBeingTranslated() != null) {
            this.ribosome.releaseMessengerRna();
        }
        super.forceImmediateUnattachedAndAvailable();
    }

    protected class RibosomeAttachedState
    extends AttachmentState {
        protected RibosomeAttachedState() {
        }

        public void stepInTime(AttachmentStateMachine attachmentStateMachine, double d) {
            assert (attachmentStateMachine.attachmentSite != null);
            assert (attachmentStateMachine.attachmentSite.attachedOrAttachingMolecule.get() == RibosomeAttachmentStateMachine.this.biomolecule);
            RibosomeAttachmentStateMachine.this.proteinBeingSynthesized.setFullSizeProportion(RibosomeAttachmentStateMachine.this.ribosome.getMessengerRnaBeingTranslated().getProportionOfRnaTranslated(RibosomeAttachmentStateMachine.this.ribosome));
            RibosomeAttachmentStateMachine.this.proteinBeingSynthesized.setAttachmentPointPosition(RibosomeAttachmentStateMachine.this.ribosome.getProteinAttachmentPoint());
            boolean bl = RibosomeAttachmentStateMachine.this.ribosome.advanceMessengerRnaTranslation(750.0 * d);
            if (bl) {
                RibosomeAttachmentStateMachine.this.ribosome.releaseMessengerRna();
                RibosomeAttachmentStateMachine.this.proteinBeingSynthesized.release();
                RibosomeAttachmentStateMachine.this.proteinBeingSynthesized = null;
                attachmentStateMachine.detach();
            }
        }

        public void entered(AttachmentStateMachine attachmentStateMachine) {
            RibosomeAttachmentStateMachine.this.ribosome.initiateTranslation();
            RibosomeAttachmentStateMachine.this.ribosome.setMotionStrategy(new RibosomeTranslatingRnaMotionStrategy(RibosomeAttachmentStateMachine.this.ribosome));
            RibosomeAttachmentStateMachine.this.proteinBeingSynthesized = RibosomeAttachmentStateMachine.this.ribosome.getMessengerRnaBeingTranslated().getProteinPrototype().createInstance();
            RibosomeAttachmentStateMachine.this.proteinBeingSynthesized.setAttachmentPointPosition(RibosomeAttachmentStateMachine.this.ribosome.getProteinAttachmentPoint());
            RibosomeAttachmentStateMachine.this.ribosome.getModel().addMobileBiomolecule(RibosomeAttachmentStateMachine.this.proteinBeingSynthesized);
            attachmentStateMachine.biomolecule.movableByUser.set(false);
        }
    }
}

