/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.geneexpressionbasics.common.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.geneexpressionbasics.common.model.AttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.DnaMolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.GeneExpressionModel;
import edu.colorado.phet.geneexpressionbasics.common.model.MobileBiomolecule;
import edu.colorado.phet.geneexpressionbasics.common.model.PlacementHint;
import edu.colorado.phet.geneexpressionbasics.common.model.Protein;
import edu.colorado.phet.geneexpressionbasics.common.model.RnaPolymerase;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactor;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactorAttachmentSite;
import edu.colorado.phet.geneexpressionbasics.common.model.TranscriptionFactorPlacementHint;
import edu.colorado.phet.geneexpressionbasics.manualgeneexpression.model.StubGeneExpressionModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Gene {
    private final DnaMolecule dnaMolecule;
    private final Color regulatoryRegionColor;
    private final Color transcribedRegionColor;
    private final IntegerRange regulatoryRegion;
    private final IntegerRange transcribedRegion;
    private final AttachmentSite polymeraseAttachmentSite;
    private final PlacementHint rnaPolymerasePlacementHint = new PlacementHint(new RnaPolymerase());
    private final List<TranscriptionFactorPlacementHint> transcriptionFactorPlacementHints = new ArrayList<TranscriptionFactorPlacementHint>();
    private final List<TranscriptionFactorAttachmentSite> transcriptionFactorAttachmentSites = new ArrayList<TranscriptionFactorAttachmentSite>();
    private final Map<Integer, TranscriptionFactor> transcriptionFactorMap = new HashMap<Integer, TranscriptionFactor>();
    private final Property<Double> polymeraseAffinityProperty = new Property<Double>(1.0);

    protected Gene(DnaMolecule dnaMolecule, IntegerRange integerRange, Color color, IntegerRange integerRange2, Color color2) {
        this.dnaMolecule = dnaMolecule;
        this.regulatoryRegion = integerRange;
        this.regulatoryRegionColor = color;
        this.transcribedRegion = integerRange2;
        this.transcribedRegionColor = color2;
        this.polymeraseAttachmentSite = new AttachmentSite(new Vector2D(dnaMolecule.getBasePairXOffsetByIndex(integerRange.getMax()), 0.0), 1.0);
        this.rnaPolymerasePlacementHint.setPosition(this.polymeraseAttachmentSite.locationProperty.get());
    }

    public Color getRegulatoryRegionColor() {
        return this.regulatoryRegionColor;
    }

    public Color getTranscribedRegionColor() {
        return this.transcribedRegionColor;
    }

    public double getCenterX() {
        return this.getStartX() + (this.getEndX() - this.getStartX()) / 2.0;
    }

    public double getStartX() {
        return this.dnaMolecule.getBasePairXOffsetByIndex(this.regulatoryRegion.getMin());
    }

    public double getEndX() {
        return this.dnaMolecule.getBasePairXOffsetByIndex(this.transcribedRegion.getMax());
    }

    public IntegerRange getRegulatoryRegion() {
        return this.regulatoryRegion;
    }

    public IntegerRange getTranscribedRegion() {
        return this.transcribedRegion;
    }

    public AttachmentSite getPolymeraseAttachmentSite(int n) {
        if (n == this.regulatoryRegion.getMax()) {
            return this.polymeraseAttachmentSite;
        }
        return this.dnaMolecule.createDefaultAffinityAttachmentSite(this.dnaMolecule.getBasePairXOffsetByIndex(n));
    }

    public AttachmentSite getPolymeraseAttachmentSite() {
        return this.polymeraseAttachmentSite;
    }

    public void updateAffinities() {
        if (this.transcriptionFactorsSupportTranscription()) {
            this.polymeraseAttachmentSite.affinityProperty.set(this.polymeraseAffinityProperty.get());
        } else {
            this.polymeraseAttachmentSite.affinityProperty.set(0.05);
        }
    }

    protected void addTranscriptionFactor(int n, TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
        this.transcriptionFactorMap.put(n, new TranscriptionFactor(transcriptionFactorConfig));
        Vector2D vector2D = new Vector2D(this.dnaMolecule.getBasePairXOffsetByIndex(n + this.regulatoryRegion.getMin()), 0.0);
        this.transcriptionFactorPlacementHints.add(new TranscriptionFactorPlacementHint(new TranscriptionFactor((GeneExpressionModel)new StubGeneExpressionModel(), transcriptionFactorConfig, vector2D)));
        this.transcriptionFactorAttachmentSites.add(new TranscriptionFactorAttachmentSite(vector2D, transcriptionFactorConfig, 1.0));
    }

    public boolean transcriptionFactorsSupportTranscription() {
        if (this.transcriptionFactorsBlockTranscription()) {
            return false;
        }
        int n = 0;
        for (TranscriptionFactor object : this.transcriptionFactorMap.values()) {
            if (!object.getConfig().isPositive) continue;
            ++n;
        }
        int n2 = 0;
        for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
            TranscriptionFactor transcriptionFactor;
            if (transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.get() == null || (transcriptionFactor = (TranscriptionFactor)transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.get()).getPosition().distance(transcriptionFactorAttachmentSite.locationProperty.get()) != 0.0 || !transcriptionFactor.isPositive()) continue;
            ++n2;
        }
        return n2 == n;
    }

    private boolean transcriptionFactorsBlockTranscription() {
        for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
            if (transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.get() == null || ((TranscriptionFactor)transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.get()).isPositive()) continue;
            return true;
        }
        return false;
    }

    public AttachmentSite getTranscriptionFactorAttachmentSite(int n, TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
        AttachmentSite attachmentSite = this.dnaMolecule.createDefaultAffinityAttachmentSite(this.dnaMolecule.getBasePairXOffsetByIndex(n));
        for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
            if (!transcriptionFactorAttachmentSite.configurationMatches(transcriptionFactorConfig) || transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.get() != null || !(Math.abs(((Vector2D)transcriptionFactorAttachmentSite.locationProperty.get()).getX() - this.dnaMolecule.getBasePairXOffsetByIndex(n)) < 17.0)) continue;
            attachmentSite = transcriptionFactorAttachmentSite;
            break;
        }
        return attachmentSite;
    }

    public AttachmentSite getMatchingSite(TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
        for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
            if (!transcriptionFactorAttachmentSite.configurationMatches(transcriptionFactorConfig)) continue;
            return transcriptionFactorAttachmentSite;
        }
        return null;
    }

    public Property<Double> getTranscriptionFactorAffinityProperty(TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
        AttachmentSite.BoundedDoubleProperty boundedDoubleProperty = null;
        for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
            if (!transcriptionFactorAttachmentSite.configurationMatches(transcriptionFactorConfig)) continue;
            boundedDoubleProperty = transcriptionFactorAttachmentSite.affinityProperty;
            break;
        }
        return boundedDoubleProperty;
    }

    public Property<Double> getPolymeraseAffinityProperty() {
        return this.polymeraseAffinityProperty;
    }

    public boolean containsBasePair(int n) {
        return this.regulatoryRegion.contains(n) || this.transcribedRegion.contains(n);
    }

    public void activateHints(MobileBiomolecule mobileBiomolecule) {
        block4: {
            block3: {
                if (!this.rnaPolymerasePlacementHint.isMatchingBiomolecule(mobileBiomolecule)) break block3;
                if (this.transcriptionFactorsBlockTranscription()) break block4;
                this.rnaPolymerasePlacementHint.active.set(true);
                for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
                    if (transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.get() != null || !transcriptionFactorAttachmentSite.getTfConfig().isPositive) continue;
                    this.activateTranscriptionFactorHint(transcriptionFactorAttachmentSite.getTfConfig());
                }
                break block4;
            }
            if (mobileBiomolecule instanceof TranscriptionFactor) {
                for (TranscriptionFactorPlacementHint transcriptionFactorPlacementHint : this.transcriptionFactorPlacementHints) {
                    transcriptionFactorPlacementHint.activateIfMatch(mobileBiomolecule);
                }
            }
        }
    }

    private void activateTranscriptionFactorHint(TranscriptionFactor.TranscriptionFactorConfig transcriptionFactorConfig) {
        for (TranscriptionFactorPlacementHint transcriptionFactorPlacementHint : this.transcriptionFactorPlacementHints) {
            transcriptionFactorPlacementHint.activateIfConfigMatch(transcriptionFactorConfig);
        }
    }

    public void deactivateHints() {
        this.rnaPolymerasePlacementHint.active.set(false);
        for (TranscriptionFactorPlacementHint transcriptionFactorPlacementHint : this.transcriptionFactorPlacementHints) {
            transcriptionFactorPlacementHint.active.set(false);
        }
    }

    public List<PlacementHint> getPlacementHints() {
        return new ArrayList<PlacementHint>(){
            {
                this.add(Gene.this.rnaPolymerasePlacementHint);
                for (TranscriptionFactorPlacementHint transcriptionFactorPlacementHint : Gene.this.transcriptionFactorPlacementHints) {
                    this.add(transcriptionFactorPlacementHint);
                }
            }
        };
    }

    public void clearAttachmentSites() {
        this.polymeraseAttachmentSite.attachedOrAttachingMolecule.set(null);
        for (TranscriptionFactorAttachmentSite transcriptionFactorAttachmentSite : this.transcriptionFactorAttachmentSites) {
            transcriptionFactorAttachmentSite.attachedOrAttachingMolecule.set(null);
        }
    }

    public abstract Protein getProteinPrototype();

    public List<TranscriptionFactor.TranscriptionFactorConfig> getTranscriptionFactorConfigs() {
        ArrayList<TranscriptionFactor.TranscriptionFactorConfig> arrayList = new ArrayList<TranscriptionFactor.TranscriptionFactorConfig>();
        for (TranscriptionFactor transcriptionFactor : this.transcriptionFactorMap.values()) {
            arrayList.add(transcriptionFactor.getConfig());
        }
        return arrayList;
    }
}

