/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.dialogs;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.dialogs.StackTraceDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ErrorDialog
extends PaintImmediateDialog {
    private static final String TITLE = PhetCommonResources.getString("Common.title.error");
    private static final String CLOSE_BUTTON = PhetCommonResources.getString("Common.choice.close");
    private static final String DETAILS_BUTTON = PhetCommonResources.getString("Common.ErrorDialog.detailsButton");
    private static final String DETAILS_TITLE = PhetCommonResources.getString("Common.ErrorDialog.detailsTitle");
    private static final String CONTACT_PHET = PhetCommonResources.getString("Common.ErrorDialog.contactPhet");

    public ErrorDialog(Frame frame, String string) {
        this(frame, string, null);
    }

    public ErrorDialog(Frame frame, String string, Exception exception) {
        super(frame, TITLE);
        this.init(string, exception);
    }

    public ErrorDialog(JDialog jDialog, String string, Exception exception) {
        super((Dialog)jDialog, TITLE);
        this.init(string, exception);
    }

    private void init(String string, final Exception exception) {
        JComponent jComponent;
        this.setResizable(false);
        this.setModal(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        String string2 = HTMLUtils.createStyledHTMLFromFragment(string);
        HTMLUtils.InteractiveHTMLPane interactiveHTMLPane = new HTMLUtils.InteractiveHTMLPane(string2);
        jPanel.add(interactiveHTMLPane);
        interactiveHTMLPane.setBackground(jPanel.getBackground());
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton(CLOSE_BUTTON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErrorDialog.this.dispose();
            }
        });
        jPanel2.add(jButton);
        if (exception != null) {
            jComponent = new JButton(DETAILS_BUTTON);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ErrorDialog.getContactPhetMessageHTML();
                    StackTraceDialog stackTraceDialog = new StackTraceDialog(ErrorDialog.this, DETAILS_TITLE, string, exception);
                    SwingUtils.centerDialogInParent(stackTraceDialog);
                    stackTraceDialog.setModal(ErrorDialog.this.isModal());
                    stackTraceDialog.setVisible(true);
                }
            });
            jPanel2.add(jComponent);
        }
        jComponent = new JPanel();
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)jComponent);
        jComponent.setLayout(easyGridBagLayout);
        int n = 0;
        int n2 = 0;
        easyGridBagLayout.addComponent(jPanel, n++, n2);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n++, n2, 2);
        easyGridBagLayout.addAnchoredComponent(jPanel2, n++, n2, 10);
        this.setContentPane(jComponent);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private static String getContactPhetMessageHTML() {
        Object[] objectArray = new Object[]{HTMLUtils.getPhetMailtoHref()};
        String string = MessageFormat.format(CONTACT_PHET, objectArray);
        return HTMLUtils.createStyledHTMLFromFragment(string);
    }
}

