/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.tools;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.view.tools.AbstractWavePacketMeasurementTool;
import java.awt.Component;

public class WavePacketSpacingTool
extends AbstractWavePacketMeasurementTool {
    public WavePacketSpacingTool(Component component, GaussianWavePacket gaussianWavePacket, Chart chart) {
        super(component, gaussianWavePacket, chart);
    }

    public void updateTool() {
        double d = this.getWavePacket().getK1();
        float f = (float)this.getChart().transformXDouble(d);
        this.setToolWidth(f);
        Domain domain = this.getDomain();
        if (domain == Domain.SPACE) {
            if (d == 0.0) {
                this.setLabel("<html>k<sub>1</sub>=0</html>");
            } else {
                this.setLabel("<html>k<sub>1</sub></html>");
            }
        } else if (domain == Domain.TIME) {
            if (d == 0.0) {
                this.setLabel("<html>" + MathStrings.C_OMEGA + "<sub>1</sub>=0</html>");
            } else {
                this.setLabel("<html>" + MathStrings.C_OMEGA + "<sub>1</sub></html>");
            }
        }
    }
}

