/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.tools;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.fourier.event.HarmonicColorChangeEvent;
import edu.colorado.phet.fourier.event.HarmonicColorChangeListener;
import edu.colorado.phet.fourier.event.HarmonicFocusEvent;
import edu.colorado.phet.fourier.event.HarmonicFocusListener;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.HarmonicColors;
import edu.colorado.phet.fourier.view.tools.MeasurementTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public abstract class AbstractHarmonicMeasurementTool
extends MeasurementTool
implements Chart.Listener,
HarmonicColorChangeListener {
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Font LABEL_FONT = new PhetFont(1, 16);
    private static final Stroke BAR_STROKE = new BasicStroke(1.0f);
    private static final Color BAR_BORDER_COLOR = Color.BLACK;
    private Chart _chart;
    private Harmonic _harmonic;
    private EventListenerList _listenerList;

    public AbstractHarmonicMeasurementTool(Component component, Harmonic harmonic, Chart chart) {
        super(component);
        this._harmonic = harmonic;
        this._chart = chart;
        this._chart.addListener(this);
        this.setLabelColor(LABEL_COLOR);
        this.setLabelFont(LABEL_FONT);
        this.setBorderColor(BAR_BORDER_COLOR);
        this.setStroke(BAR_STROKE);
        this.addMouseInputListener(new MouseFocusListener());
        this._listenerList = new EventListenerList();
        HarmonicColors.getInstance().addHarmonicColorChangeListener(this);
        this.updateTool();
    }

    public void setHarmonic(Harmonic harmonic) {
        this._harmonic = harmonic;
        this.updateTool();
    }

    protected Harmonic getHarmonic() {
        return this._harmonic;
    }

    protected Chart getChart() {
        return this._chart;
    }

    protected abstract void updateTool();

    public void transformChanged(Chart chart) {
        this.updateTool();
    }

    public void addHarmonicFocusListener(HarmonicFocusListener harmonicFocusListener) {
        this._listenerList.add(HarmonicFocusListener.class, harmonicFocusListener);
    }

    private void fireHarmonicFocusEvent(boolean bl) {
        HarmonicFocusEvent harmonicFocusEvent = new HarmonicFocusEvent(this, this._harmonic, bl);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != HarmonicFocusListener.class) continue;
            HarmonicFocusListener harmonicFocusListener = (HarmonicFocusListener)objectArray[i + 1];
            if (bl) {
                harmonicFocusListener.focusGained(harmonicFocusEvent);
                continue;
            }
            harmonicFocusListener.focusLost(harmonicFocusEvent);
        }
    }

    public void harmonicColorChanged(HarmonicColorChangeEvent harmonicColorChangeEvent) {
        if (harmonicColorChangeEvent.getOrder() == this._harmonic.getOrder()) {
            Color color = HarmonicColors.getInstance().getColor(this._harmonic);
            this.setFillColor(color);
        }
    }

    private class MouseFocusListener
    extends MouseInputAdapter {
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractHarmonicMeasurementTool.this.fireHarmonicFocusEvent(true);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractHarmonicMeasurementTool.this.fireHarmonicFocusEvent(false);
        }
    }
}

