/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.discrete;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.charts.SinePlot;
import edu.colorado.phet.common.charts.StringLabelTable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetZoomControl;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.FourierSumPlot;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.Preset;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.model.FourierSeries;
import edu.colorado.phet.fourier.view.AnimationCycleController;
import edu.colorado.phet.fourier.view.discrete.DiscreteSumChart;
import edu.colorado.phet.fourier.view.discrete.DiscreteSumEquation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.JCheckBox;

public class DiscreteSumView
extends GraphicLayerSet
implements SimpleObserver,
PhetZoomControl.ZoomListener,
AnimationCycleController.AnimationCycleListener {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 216);
    private static final Color BACKGROUND_COLOR = new Color(215, 215, 215);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Point TITLE_LOCATION = new Point(40, 135);
    private static final Range2D CHART_RANGE = new Range2D(-0.5, -1.2732395447351628, 0.5, 1.2732395447351628);
    private static final Dimension CHART_SIZE = new Dimension(540, 135);
    private static final Stroke SUM_STROKE = new BasicStroke(1.0f);
    private static final Color SUM_COLOR = Color.BLACK;
    private static final Stroke PRESET_STROKE = new BasicStroke(4.0f);
    private static final Color PRESET_COLOR = Color.LIGHT_GRAY;
    private FourierSeries _fourierSeries;
    private PhetShapeGraphic _backgroundGraphic;
    private PhetTextGraphic _titleGraphic;
    private PhetImageGraphic _minimizeButton;
    private DiscreteSumChart _chartGraphic;
    private DiscreteSumEquation _mathGraphic;
    private FourierSumPlot _sumPlot;
    private LinePlot _presetPlot;
    private SinePlot _sineCosinePresetPlot;
    private PhetZoomControl _horizontalZoomControl;
    private PhetZoomControl _verticalZoomControl;
    private JCheckBox _autoScaleCheckBox;
    private PhetGraphic _autoScaleGraphic;
    private int _xZoomLevel;
    private Domain _domain;
    private MathForm _mathForm;
    private boolean _presetEnabled;
    private int _previousNumberOfHarmonics;
    private Preset _previousPreset;
    private WaveType _previousWaveType;

    public DiscreteSumView(Component component, FourierSeries fourierSeries) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new Rectangle(0, 0, DiscreteSumView.BACKGROUND_SIZE.width, DiscreteSumView.BACKGROUND_SIZE.height));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this._backgroundGraphic.setStroke(BACKGROUND_STROKE);
        this._backgroundGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        this.addGraphic(this._backgroundGraphic, 1.0);
        this._backgroundGraphic.setLocation(0, 0);
        String string = FourierResources.getString("DiscreteSumView.title");
        this._titleGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.centerRegistrationPoint();
        this._titleGraphic.rotate(-1.5707963267948966);
        this._titleGraphic.setLocation(TITLE_LOCATION);
        this.addGraphic(this._titleGraphic, 2.0);
        this._chartGraphic = new DiscreteSumChart(component, CHART_RANGE, CHART_SIZE);
        this.addGraphic(this._chartGraphic, 3.0);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(60, 50);
        this._sineCosinePresetPlot = new SinePlot(this.getComponent(), this._chartGraphic);
        this._sineCosinePresetPlot.setAmplitude(1.0);
        this._sineCosinePresetPlot.setPeriod(1.0);
        this._sineCosinePresetPlot.setPixelsPerPoint(1.0);
        this._sineCosinePresetPlot.setStroke(PRESET_STROKE);
        this._sineCosinePresetPlot.setBorderColor(PRESET_COLOR);
        this._sineCosinePresetPlot.setStartX(0.0);
        this._chartGraphic.addDataSetGraphic(this._sineCosinePresetPlot);
        this._presetPlot = new LinePlot(this.getComponent(), this._chartGraphic, new DataSet(), PRESET_STROKE, PRESET_COLOR);
        this._chartGraphic.addDataSetGraphic(this._presetPlot);
        this._sumPlot = new FourierSumPlot(this.getComponent(), (Chart)this._chartGraphic, this._fourierSeries);
        this._sumPlot.setPeriod(1.0);
        this._sumPlot.setPixelsPerPoint(1.0);
        this._sumPlot.setStroke(SUM_STROKE);
        this._sumPlot.setBorderColor(SUM_COLOR);
        this._chartGraphic.addDataSetGraphic(this._sumPlot);
        this._minimizeButton = new PhetImageGraphic(component, FourierConstants.MINIMIZE_BUTTON_IMAGE);
        this.addGraphic(this._minimizeButton, 4.0);
        this._minimizeButton.centerRegistrationPoint();
        this._minimizeButton.setLocation(this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getHeight() / 2 + 5);
        this._horizontalZoomControl = new PhetZoomControl(component, 0);
        this.addGraphic(this._horizontalZoomControl, 4.0);
        int n = this._chartGraphic.getX() + DiscreteSumView.CHART_SIZE.width + 20;
        int n2 = this._chartGraphic.getY();
        this._horizontalZoomControl.setLocation(n, n2);
        this._autoScaleCheckBox = new JCheckBox(FourierResources.getString("DiscreteSumView.autoScale"));
        this._autoScaleCheckBox.setBackground(new Color(255, 255, 255, 0));
        this._autoScaleGraphic = PhetJComponent.newInstance(component, this._autoScaleCheckBox);
        this.addGraphic(this._autoScaleGraphic, 4.0);
        this._autoScaleGraphic.setLocation(this._horizontalZoomControl.getX(), this._chartGraphic.getY() + this._chartGraphic.getHeight() - this._autoScaleGraphic.getHeight());
        this._verticalZoomControl = new PhetZoomControl(component, 1);
        this.addGraphic(this._verticalZoomControl, 4.0);
        this._verticalZoomControl.setLocation(this._horizontalZoomControl.getX(), this._autoScaleGraphic.getY() - this._verticalZoomControl.getHeight() - 5);
        this._mathGraphic = new DiscreteSumEquation(component);
        this.addGraphic(this._mathGraphic, 5.0);
        this._mathGraphic.centerRegistrationPoint();
        n = this._chartGraphic.getX() + DiscreteSumView.CHART_SIZE.width / 2;
        n2 = 30;
        this._mathGraphic.setLocation(n, n2);
        this._backgroundGraphic.setIgnoreMouse(true);
        this._titleGraphic.setIgnoreMouse(true);
        this._chartGraphic.setIgnoreMouse(true);
        this._mathGraphic.setIgnoreMouse(true);
        this._minimizeButton.setCursorHand();
        this._horizontalZoomControl.addZoomListener(this);
        this._verticalZoomControl.addZoomListener(this);
        this._autoScaleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscreteSumView.this.updateZoomButtons();
                DiscreteSumView.this.update();
            }
        });
        this.reset();
    }

    public void reset() {
        this._xZoomLevel = 0;
        this._chartGraphic.setRange(CHART_RANGE);
        this._autoScaleCheckBox.setSelected(false);
        this.updateLabelsAndLines();
        this.updateZoomButtons();
        this._presetPlot.setVisible(false);
        this._sineCosinePresetPlot.setVisible(false);
        this._domain = Domain.SPACE;
        this._mathForm = MathForm.WAVE_NUMBER;
        this._mathGraphic.setVisible(false);
        this.updateMath();
        this._previousNumberOfHarmonics = 0;
        this._previousPreset = Preset.UNDEFINED;
        this._previousWaveType = WaveType.UNDEFINED;
        this._presetEnabled = false;
        this.update();
    }

    public PhetZoomControl getHorizontalZoomControl() {
        return this._horizontalZoomControl;
    }

    public void setMathEnabled(boolean bl) {
        this._mathGraphic.setVisible(bl);
        this.updateLabelsAndLines();
    }

    public void setDomainAndMathForm(Domain domain, MathForm mathForm) {
        this._domain = domain;
        this._mathForm = mathForm;
        this.updateLabelsAndLines();
        this.updateMath();
        this._previousPreset = Preset.UNDEFINED;
        this.update();
    }

    public void setPresetEnabled(boolean bl) {
        this._presetEnabled = bl;
        this._sineCosinePresetPlot.setVisible(false);
        this._presetPlot.setVisible(false);
        if (this._presetEnabled) {
            if (this._fourierSeries.getPreset() == Preset.SINE_COSINE) {
                this._sineCosinePresetPlot.setVisible(true);
                this._sineCosinePresetPlot.setCosineEnabled(this._fourierSeries.getWaveType() == WaveType.COSINES);
            } else {
                this._presetPlot.setVisible(true);
            }
        }
    }

    public PhetImageGraphic getMinimizeButton() {
        return this._minimizeButton;
    }

    public void setHeight(int n) {
        if (n >= 150) {
            this._backgroundGraphic.setShape(new Rectangle(0, 0, DiscreteSumView.BACKGROUND_SIZE.width, n));
            this._chartGraphic.setChartSize(DiscreteSumView.CHART_SIZE.width, n - 75);
            this._titleGraphic.setLocation(DiscreteSumView.TITLE_LOCATION.x, n / 2);
            this._autoScaleGraphic.setLocation(this._horizontalZoomControl.getX(), this._chartGraphic.getY() + (int)this._chartGraphic.getChartSize().getHeight() - this._autoScaleGraphic.getHeight() + 15);
            this._verticalZoomControl.setLocation(this._horizontalZoomControl.getX(), this._autoScaleGraphic.getY() - this._verticalZoomControl.getHeight() - 5);
            this.setBoundsDirty();
        }
    }

    public void update() {
        if (this.isVisible()) {
            this._sumPlot.updateDataSet();
            if (this._autoScaleCheckBox.isSelected()) {
                Range2D range2D = this._chartGraphic.getRange();
                double d = this._sumPlot.getMaxAmplitude() * 1.05;
                if (d < 1.2732395447351628) {
                    d = 1.2732395447351628;
                }
                if (d != range2D.getMaxY()) {
                    range2D.setMinY(-d);
                    range2D.setMaxY(d);
                    this._chartGraphic.setRange(range2D);
                    this.updateLabelsAndLines();
                    this.updateZoomButtons();
                }
            }
            int n = this._fourierSeries.getNumberOfHarmonics();
            Preset preset = this._fourierSeries.getPreset();
            WaveType waveType = this._fourierSeries.getWaveType();
            if (n != this._previousNumberOfHarmonics || preset != this._previousPreset || waveType != this._previousWaveType) {
                this._sumPlot.setStartX(0.0);
                this._sineCosinePresetPlot.setStartX(0.0);
                this._presetPlot.getDataSet().clear();
                Point2D[] point2DArray = Preset.getPresetPoints(preset, waveType);
                if (point2DArray != null) {
                    Point2D[] point2DArray2 = new Point2D[point2DArray.length];
                    for (int i = 0; i < point2DArray.length; ++i) {
                        point2DArray2[i] = new Point2D.Double(point2DArray[i].getX(), point2DArray[i].getY());
                    }
                    this._presetPlot.getDataSet().addAllPoints(point2DArray2);
                }
                this._sineCosinePresetPlot.setVisible(false);
                this._presetPlot.setVisible(false);
                if (this._presetEnabled) {
                    if (this._fourierSeries.getPreset() == Preset.SINE_COSINE) {
                        this._sineCosinePresetPlot.setVisible(true);
                        this._sineCosinePresetPlot.setCosineEnabled(this._fourierSeries.getWaveType() == WaveType.COSINES);
                    } else {
                        this._presetPlot.setVisible(true);
                    }
                }
                this.updateMath();
                this._previousNumberOfHarmonics = n;
                this._previousPreset = preset;
                this._previousWaveType = waveType;
            }
        }
    }

    public void zoomPerformed(PhetZoomControl.ZoomEvent zoomEvent) {
        int n = zoomEvent.getZoomType();
        if (n == 2 || n == 3) {
            this.handleHorizontalZoom(n);
        } else if (n == 0 || n == 1) {
            this.handleVerticalZoom(n);
        } else {
            throw new IllegalArgumentException("unexpected event: " + zoomEvent);
        }
    }

    private void handleHorizontalZoom(int n) {
        this._xZoomLevel = n == 2 ? ++this._xZoomLevel : --this._xZoomLevel;
        double d = Math.pow(2.0, (double)Math.abs(this._xZoomLevel) / 2.0);
        Range2D range2D = this._chartGraphic.getRange();
        double d2 = this._xZoomLevel == 0 ? 0.5 : (this._xZoomLevel > 0 ? 0.5 / d : 0.5 * d);
        range2D.setMaxX(d2);
        range2D.setMinX(-d2);
        this._chartGraphic.setRange(range2D);
        this.updateLabelsAndLines();
        this.updateZoomButtons();
    }

    private void handleVerticalZoom(int n) {
        Range2D range2D = this._chartGraphic.getRange();
        double d = range2D.getMaxY();
        if (d % 2.0 > 0.0) {
            d = (int)(d / 2.0) * 2;
        }
        d = n == 0 ? (d -= 2.0) : (d += 2.0);
        if (d < 1.2732395447351628) {
            d = 1.2732395447351628;
        } else if (d > 12.0) {
            d = 12.0;
        }
        range2D.setMaxY(d);
        range2D.setMinY(-d);
        this._chartGraphic.setRange(range2D);
        this.updateLabelsAndLines();
        this.updateZoomButtons();
    }

    private void updateLabelsAndLines() {
        StringLabelTable stringLabelTable;
        boolean bl = this._mathGraphic.isVisible();
        if (bl) {
            stringLabelTable = this._xZoomLevel > -3 ? (this._domain == Domain.TIME ? this._chartGraphic.getSymbolicTimeLabels1() : this._chartGraphic.getSymbolicSpaceLabels1()) : (this._domain == Domain.TIME ? this._chartGraphic.getSymbolicTimeLabels2() : this._chartGraphic.getSymbolicSpaceLabels2());
        } else {
            double d = this._xZoomLevel > 0 ? 0.25 : (this._xZoomLevel == 0 || this._xZoomLevel == -1 ? 0.5 : (this._xZoomLevel == -2 || this._xZoomLevel == -3 ? 1.0 : 2.0));
            stringLabelTable = this._domain == Domain.TIME ? this._chartGraphic.getActualTimeLabels(d) : this._chartGraphic.getActualSpaceLabels(d);
        }
        this._chartGraphic.getHorizontalTicks().setMajorLabels(stringLabelTable);
        if (this._domain == Domain.TIME) {
            if (this._mathGraphic.isVisible()) {
                this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.t"));
            } else {
                this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.t.units"));
            }
        } else if (this._mathGraphic.isVisible()) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x"));
        } else {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x.units"));
        }
        Range2D range2D = this._chartGraphic.getRange();
        double d = range2D.getMaxY() < 2.0 ? 0.5 : (range2D.getMaxY() < 5.0 ? 1.0 : 5.0);
        this._chartGraphic.getVerticalTicks().setMajorTickSpacing(d);
        this._chartGraphic.getHorizonalGridlines().setMajorTickSpacing(d);
    }

    private void updateZoomButtons() {
        Range2D range2D = this._chartGraphic.getRange();
        if (range2D.getMaxX() >= 2.0) {
            this._horizontalZoomControl.setZoomOutEnabled(false);
            this._horizontalZoomControl.setZoomInEnabled(true);
        } else if (range2D.getMaxX() <= 0.25) {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(false);
        } else {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(true);
        }
        if (this._autoScaleCheckBox.isSelected()) {
            this._verticalZoomControl.setZoomOutEnabled(false);
            this._verticalZoomControl.setZoomInEnabled(false);
        } else if (range2D.getMaxY() >= 12.0) {
            this._verticalZoomControl.setZoomOutEnabled(false);
            this._verticalZoomControl.setZoomInEnabled(true);
        } else if (range2D.getMaxY() <= 1.2732395447351628) {
            this._verticalZoomControl.setZoomOutEnabled(true);
            this._verticalZoomControl.setZoomInEnabled(false);
        } else {
            this._verticalZoomControl.setZoomOutEnabled(true);
            this._verticalZoomControl.setZoomInEnabled(true);
        }
    }

    private void updateMath() {
        this._mathGraphic.setForm(this._domain, this._mathForm, this._fourierSeries.getNumberOfHarmonics(), this._fourierSeries.getWaveType());
        this._mathGraphic.centerRegistrationPoint();
    }

    public void animate(AnimationCycleController.AnimationCycleEvent animationCycleEvent) {
        if (this._domain == Domain.SPACE_AND_TIME) {
            double d = animationCycleEvent.getCyclePoint() * 1.0;
            this._sumPlot.setStartX(d);
            if (this._fourierSeries.getPreset() == Preset.SINE_COSINE) {
                this._sineCosinePresetPlot.setStartX(d);
            } else {
                double d2 = animationCycleEvent.getDelta() * 1.0;
                Point2D[] point2DArray = this._presetPlot.getDataSet().getPoints();
                if (point2DArray != null) {
                    this._presetPlot.getDataSet().clear();
                    for (int i = 0; i < point2DArray.length; ++i) {
                        point2DArray[i].setLocation(point2DArray[i].getX() + d2, point2DArray[i].getY());
                    }
                    this._presetPlot.getDataSet().addAllPoints(point2DArray);
                }
            }
        }
    }
}

