/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.d2c;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class D2CSumChart
extends Chart {
    private static final Color AXIS_COLOR = Color.BLACK;
    private static final Stroke AXIS_STROKE = new BasicStroke(0.5f);
    private static final Font AXIS_TITLE_FONT = new PhetFont(1, 16);
    private static final Color AXIS_TITLE_COLOR = Color.BLACK;
    private static final NumberFormat RANGE_LABELS_FORMAT = new DecimalFormat("0.00");
    private static final Stroke MAJOR_TICK_STROKE = new BasicStroke(1.0f);
    private static final Font MAJOR_TICK_FONT = new PhetFont(1, 12);
    private static final Stroke MINOR_TICK_STROKE = MAJOR_TICK_STROKE;
    private static final Font MINOR_TICK_FONT = MAJOR_TICK_FONT;
    private PhetTextGraphic _xAxisTitleGraphic;

    public D2CSumChart(Component component, Range2D range2D, Dimension dimension) {
        super(component, range2D, dimension);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.getXAxis().setStroke(AXIS_STROKE);
        this.getXAxis().setColor(AXIS_COLOR);
        this._xAxisTitleGraphic = new PhetTextGraphic(component, AXIS_TITLE_FONT, "", AXIS_TITLE_COLOR);
        this.setXAxisTitle(this._xAxisTitleGraphic);
        this.getXAxis().setMajorTicksVisible(false);
        this.getXAxis().setMajorTickLabelsVisible(false);
        this.getXAxis().setMinorTicksVisible(false);
        this.getXAxis().setMinorTickLabelsVisible(false);
        this.getHorizontalTicks().setMajorTicksVisible(true);
        this.getHorizontalTicks().setMajorTickLabelsVisible(true);
        this.getHorizontalTicks().setMajorTickSpacing(0.5);
        this.getHorizontalTicks().setMajorTickStroke(MAJOR_TICK_STROKE);
        this.getHorizontalTicks().setMajorTickFont(MAJOR_TICK_FONT);
        this.getHorizontalTicks().setMinorTicksVisible(true);
        this.getHorizontalTicks().setMinorTickLabelsVisible(false);
        this.getHorizontalTicks().setMinorTickSpacing(0.1);
        this.getHorizontalTicks().setMinorTickStroke(MINOR_TICK_STROKE);
        this.getHorizontalTicks().setMinorTickFont(MINOR_TICK_FONT);
        this.getVerticalGridlines().setMajorGridlinesVisible(false);
        this.getVerticalGridlines().setMinorGridlinesVisible(false);
        this.getYAxis().setStroke(AXIS_STROKE);
        this.getYAxis().setColor(AXIS_COLOR);
        this.getYAxis().setMajorTicksVisible(false);
        this.getYAxis().setMajorTickLabelsVisible(false);
        this.getYAxis().setMinorTicksVisible(false);
        this.getYAxis().setMinorTickLabelsVisible(false);
        this.getVerticalTicks().setRangeLabelsVisible(false);
        this.getVerticalTicks().setRangeLabelsNumberFormat(RANGE_LABELS_FORMAT);
        this.getVerticalTicks().setMajorTicksVisible(true);
        this.getVerticalTicks().setMajorTickLabelsVisible(true);
        this.getVerticalTicks().setMajorTickSpacing(0.5);
        this.getVerticalTicks().setMajorTickStroke(MAJOR_TICK_STROKE);
        this.getVerticalTicks().setMajorTickFont(MAJOR_TICK_FONT);
        this.getVerticalTicks().setMinorTicksVisible(false);
        this.getHorizonalGridlines().setMajorGridlinesVisible(false);
        this.getHorizonalGridlines().setMinorGridlinesVisible(false);
    }

    public void setXAxisTitle(String string) {
        this._xAxisTitleGraphic.setText(string);
        this._xAxisTitleGraphic.setRegistrationPoint(-4, -this._xAxisTitleGraphic.getHeight() / 2);
    }

    public void autoscaleY(double d) {
        DecimalFormat decimalFormat;
        double d2 = 0.0;
        double d3 = 0.0;
        if (d > 2.0) {
            d2 = 1.0;
            d3 = 0.5;
            decimalFormat = new DecimalFormat("#.#");
        } else {
            d2 = 0.5;
            d3 = 0.1;
            decimalFormat = new DecimalFormat(".##");
        }
        Range2D range2D = this.getRange();
        if (d > range2D.getMaxY()) {
            this.getVerticalTicks().setMajorNumberFormat(decimalFormat);
            this.getVerticalTicks().setMajorTickSpacing(d2);
            this.getVerticalTicks().setMinorTickSpacing(d3);
            this.getHorizonalGridlines().setMajorTickSpacing(d2);
            range2D.setMaxY(d);
            range2D.setMinY(-d);
            this.setRange(range2D);
        } else {
            range2D.setMaxY(d);
            range2D.setMinY(-d);
            this.setRange(range2D);
            this.getVerticalTicks().setMajorNumberFormat(decimalFormat);
            this.getVerticalTicks().setMajorTickSpacing(d2);
            this.getVerticalTicks().setMinorTickSpacing(d3);
            this.getHorizonalGridlines().setMajorTickSpacing(d2);
        }
    }
}

