/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.d2c;

import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetZoomControl;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierConstants;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.charts.FlattenedChart;
import edu.colorado.phet.fourier.charts.HarmonicPlot;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.WaveType;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.model.Harmonic;
import edu.colorado.phet.fourier.view.HarmonicsEquation;
import edu.colorado.phet.fourier.view.d2c.D2CComponentsChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class D2CComponentsView
extends GraphicLayerSet
implements SimpleObserver,
PhetZoomControl.ZoomListener {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 150);
    private static final Color BACKGROUND_COLOR = new Color(215, 215, 215);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Point TITLE_LOCATION = new Point(40, 115);
    private static final Font CANNOT_SHOW_MESSAGE_FONT = new PhetFont(0, 16);
    private static final Color CANNOT_SHOW_MESSAGE_COLOR = Color.RED;
    private static final Font MINIMIZE_MESSAGE_FONT = new PhetFont(0, 12);
    private static final Color MINIMIZE_MESSAGE_COLOR = Color.RED;
    private static final Range2D CHART_RANGE = new Range2D(-2.0, -1.0, 2.0, 1.0);
    private static final Dimension CHART_SIZE = new Dimension(540, 100);
    private static final Stroke HARMONIC_STROKE = new BasicStroke(1.0f);
    private GaussianWavePacket _wavePacket;
    private PhetShapeGraphic _backgroundGraphic;
    private PhetTextGraphic _titleGraphic;
    private PhetImageGraphic _minimizeButton;
    private PhetZoomControl _horizontalZoomControl;
    private D2CComponentsChart _chartGraphic;
    private HarmonicsEquation _mathGraphic;
    private Domain _domain;
    private WaveType _waveType;
    private int _xZoomLevel;
    private HTMLGraphic _cannotShowGraphic;
    private FlattenedChart _flattenedChart;
    private boolean _updateRequired;

    public D2CComponentsView(Component component, GaussianWavePacket gaussianWavePacket) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._wavePacket = gaussianWavePacket;
        this._wavePacket.addObserver(this);
        this._backgroundGraphic = new PhetShapeGraphic(component);
        this._backgroundGraphic.setShape(new Rectangle(0, 0, D2CComponentsView.BACKGROUND_SIZE.width, D2CComponentsView.BACKGROUND_SIZE.height));
        this._backgroundGraphic.setPaint(BACKGROUND_COLOR);
        this._backgroundGraphic.setStroke(BACKGROUND_STROKE);
        this._backgroundGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        this._backgroundGraphic.setLocation(0, 0);
        this.addGraphic(this._backgroundGraphic, 1.0);
        String string = FourierResources.getString("D2CHarmonicsView.title");
        this._titleGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        this._titleGraphic.centerRegistrationPoint();
        this._titleGraphic.rotate(-1.5707963267948966);
        this._titleGraphic.setLocation(40, D2CComponentsView.BACKGROUND_SIZE.height / 2);
        this.addGraphic(this._titleGraphic, 2.0);
        this._chartGraphic = new D2CComponentsChart(component, CHART_RANGE, CHART_SIZE);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(0, 0);
        int n = 25;
        int n2 = 25;
        this._flattenedChart = new FlattenedChart(component, this._chartGraphic, n, n2);
        this.addGraphic(this._flattenedChart, 4.0);
        this._flattenedChart.setRegistrationPoint(0, 0);
        this._flattenedChart.setLocation(60 - n, 50 - n2);
        String string2 = FourierResources.getString("D2CHarmonicsView.cannotShow");
        this._cannotShowGraphic = new HTMLGraphic(component, CANNOT_SHOW_MESSAGE_FONT, string2, CANNOT_SHOW_MESSAGE_COLOR);
        this.addGraphic(this._cannotShowGraphic, 3.0);
        this._cannotShowGraphic.setRegistrationPoint(0, this._cannotShowGraphic.getHeight() / 2);
        this._cannotShowGraphic.setLocation(125, D2CComponentsView.BACKGROUND_SIZE.height / 2);
        this._minimizeButton = new PhetImageGraphic(component, FourierConstants.MINIMIZE_BUTTON_IMAGE);
        this.addGraphic(this._minimizeButton, 5.0);
        this._minimizeButton.centerRegistrationPoint();
        this._minimizeButton.setLocation(this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getHeight() / 2 + 5);
        String string3 = FourierResources.getString("D2CHarmonicsView.minimize");
        HTMLGraphic hTMLGraphic = new HTMLGraphic(component, MINIMIZE_MESSAGE_FONT, string3, MINIMIZE_MESSAGE_COLOR);
        this.addGraphic(hTMLGraphic, 3.0);
        hTMLGraphic.setRegistrationPoint(0, hTMLGraphic.getHeight() / 2);
        hTMLGraphic.setLocation(this._minimizeButton.getX() + this._minimizeButton.getWidth() / 2 + 10, this._minimizeButton.getY() + 5);
        this._horizontalZoomControl = new PhetZoomControl(component, 0);
        this.addGraphic(this._horizontalZoomControl, 5.0);
        this._horizontalZoomControl.setLocation(620, 50);
        this._mathGraphic = new HarmonicsEquation(component);
        this.addGraphic(this._mathGraphic, 6.0);
        this._mathGraphic.centerRegistrationPoint();
        this._mathGraphic.setLocation(330, 28);
        this._backgroundGraphic.setIgnoreMouse(true);
        this._titleGraphic.setIgnoreMouse(true);
        this._flattenedChart.setIgnoreMouse(true);
        this._mathGraphic.setIgnoreMouse(true);
        this._cannotShowGraphic.setIgnoreMouse(true);
        hTMLGraphic.setIgnoreMouse(true);
        this._horizontalZoomControl.addZoomListener(this);
        this._minimizeButton.setCursorHand();
        this.reset();
    }

    public void reset() {
        this.setDomain(Domain.SPACE);
        this._waveType = WaveType.SINES;
        this._xZoomLevel = 0;
        this._chartGraphic.setRange(CHART_RANGE);
        this.refreshChart();
        this.updateZoomButtons();
        this.update();
        this._updateRequired = false;
    }

    public PhetZoomControl getHorizontalZoomControl() {
        return this._horizontalZoomControl;
    }

    public void setDomain(Domain domain) {
        this._domain = domain;
        this.updateMath();
        this.updateAxisTitles();
    }

    public void setWaveType(WaveType waveType) {
        this._waveType = waveType;
        this.update();
        this.updateMath();
    }

    public PhetImageGraphic getMinimizeButton() {
        return this._minimizeButton;
    }

    public void setHeight(int n) {
        if (n >= 150) {
            this._backgroundGraphic.setShape(new Rectangle(0, 0, D2CComponentsView.BACKGROUND_SIZE.width, n));
            this._titleGraphic.setLocation(D2CComponentsView.TITLE_LOCATION.x, n / 2);
            this._cannotShowGraphic.setLocation(125, n / 2);
            this._chartGraphic.setChartSize(D2CComponentsView.CHART_SIZE.width, n - 75);
            this.refreshChart();
            this.setBoundsDirty();
        }
    }

    public void setVisible(boolean bl) {
        if (bl != super.isVisible()) {
            super.setVisible(bl);
            if (bl && this._updateRequired) {
                this.update();
            }
        }
    }

    public void zoomPerformed(PhetZoomControl.ZoomEvent zoomEvent) {
        int n = zoomEvent.getZoomType();
        if (n != 2 && n != 3) {
            throw new IllegalArgumentException("unexpected event: " + zoomEvent);
        }
        this.handleHorizontalZoom(n);
    }

    private void handleHorizontalZoom(int n) {
        this._xZoomLevel = n == 2 ? ++this._xZoomLevel : --this._xZoomLevel;
        double d = Math.pow(2.0, (double)Math.abs(this._xZoomLevel) / 2.0);
        Range2D range2D = this._chartGraphic.getRange();
        double d2 = this._xZoomLevel == 0 ? 2.0 : (this._xZoomLevel > 0 ? 2.0 / d : 2.0 * d);
        if (d2 > 3.0) {
            this._chartGraphic.getHorizontalTicks().setMinorTicksVisible(false);
            this._chartGraphic.getHorizontalTicks().setMajorTickSpacing(1.0);
            range2D.setMaxX(d2);
            range2D.setMinX(-d2);
            this._chartGraphic.setRange(range2D);
        } else {
            range2D.setMaxX(d2);
            range2D.setMinX(-d2);
            this._chartGraphic.setRange(range2D);
            this._chartGraphic.getHorizontalTicks().setMinorTicksVisible(true);
            this._chartGraphic.getHorizontalTicks().setMajorTickSpacing(0.5);
        }
        this.refreshChart();
        this.updateZoomButtons();
    }

    private void updateZoomButtons() {
        Range2D range2D = this._chartGraphic.getRange();
        if (range2D.getMaxX() >= 8.0) {
            this._horizontalZoomControl.setZoomOutEnabled(false);
            this._horizontalZoomControl.setZoomInEnabled(true);
        } else if (range2D.getMaxX() <= 0.5) {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(false);
        } else {
            this._horizontalZoomControl.setZoomOutEnabled(true);
            this._horizontalZoomControl.setZoomInEnabled(true);
        }
    }

    public void update() {
        this._updateRequired = true;
        if (this.isVisible()) {
            this._updateRequired = false;
            DataSetGraphic[] dataSetGraphicArray = this._chartGraphic.getDataSetGraphics();
            for (int i = 0; i < dataSetGraphicArray.length; ++i) {
                if (!(dataSetGraphicArray[i] instanceof HarmonicPlot)) continue;
                dataSetGraphicArray[i].cleanup();
            }
            this._chartGraphic.removeAllDataSetGraphics();
            double d = this._wavePacket.getK1();
            double d2 = this._wavePacket.getK0();
            double d3 = this._wavePacket.getDeltaK();
            int n = this._wavePacket.getNumberOfComponents();
            if (n < Integer.MAX_VALUE) {
                this._flattenedChart.setVisible(true);
                this._horizontalZoomControl.setVisible(true);
                this._mathGraphic.setVisible(true);
                this._cannotShowGraphic.setVisible(false);
                int n2 = -230 / n;
                double d4 = 0.0;
                double d5 = Math.PI * 2 / d;
                for (int i = n - 1; i >= 0; --i) {
                    double d6 = (double)(i + 1) * d;
                    double d7 = d * GaussianWavePacket.getAmplitude(d6, d2, d3);
                    Harmonic harmonic = new Harmonic(i);
                    harmonic.setAmplitude(d7);
                    if (Math.abs(d7) > d4) {
                        d4 = Math.abs(d7);
                    }
                    int n3 = 0 - i * n2;
                    int n4 = 0 - i * n2;
                    int n5 = 0 - i * n2;
                    Color color = new Color(n3, n4, n5);
                    HarmonicPlot harmonicPlot = new HarmonicPlot(this.getComponent(), this._chartGraphic);
                    harmonicPlot.setHarmonic(harmonic);
                    harmonicPlot.setPeriod(d5 / (double)(i + 1));
                    harmonicPlot.setWaveType(this._waveType);
                    harmonicPlot.setPixelsPerPoint(1.0);
                    harmonicPlot.setStroke(HARMONIC_STROKE);
                    harmonicPlot.setBorderColor(color);
                    harmonicPlot.setStartX(0.0);
                    this._chartGraphic.addDataSetGraphic(harmonicPlot);
                }
                this._chartGraphic.autoscaleY(d4 * 1.05);
                this.refreshChart();
            } else {
                this._flattenedChart.setVisible(false);
                this._horizontalZoomControl.setVisible(false);
                this._mathGraphic.setVisible(false);
                this._cannotShowGraphic.setVisible(true);
            }
        }
    }

    private void updateMath() {
        int n = this._wavePacket.getNumberOfComponents();
        if (this._domain == Domain.SPACE) {
            this._mathGraphic.setForm(this._domain, MathForm.WAVE_NUMBER, this._waveType);
        } else if (this._domain == Domain.TIME) {
            this._mathGraphic.setForm(this._domain, MathForm.ANGULAR_FREQUENCY, this._waveType);
        }
        this._mathGraphic.centerRegistrationPoint();
    }

    private void updateAxisTitles() {
        if (this._domain == Domain.SPACE) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.x.units"));
        } else if (this._domain == Domain.TIME) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("axis.t.units"));
        }
        this.refreshChart();
    }

    private void refreshChart() {
        this._flattenedChart.flatten();
    }
}

