/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view.d2c;

import edu.colorado.phet.common.charts.BarPlot;
import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.charts.LinePlot;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.charts.ClosedPathPlot;
import edu.colorado.phet.fourier.charts.FlattenedChart;
import edu.colorado.phet.fourier.charts.WavePacketKWidthPlot;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.model.GaussianWavePacket;
import edu.colorado.phet.fourier.view.d2c.D2CAmplitudesChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class D2CAmplitudesView
extends GraphicLayerSet
implements SimpleObserver {
    private static final Dimension BACKGROUND_SIZE = new Dimension(800, 195);
    private static final Color BACKGROUND_COLOR = new Color(195, 195, 195);
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BACKGROUND_BORDER_COLOR = Color.BLACK;
    private static final Font TITLE_FONT = new PhetFont(0, 20);
    private static final Color TITLE_COLOR = Color.BLUE;
    private static final Range2D CHART_RANGE = new Range2D(0.0, 0.0, 75.39822368615503, 1.0);
    private static final Dimension CHART_SIZE = new Dimension(575, 140);
    private static final Color ENVELOPE_COLOR = Color.LIGHT_GRAY;
    private static final Stroke ENVELOPE_STROKE = new BasicStroke(4.0f);
    private static final Font MATH_FONT = new PhetFont(0, 20);
    private static final Color MATH_COLOR = Color.BLACK;
    private GaussianWavePacket _wavePacket;
    private D2CAmplitudesChart _chartGraphic;
    private FlattenedChart _flattenedChart;
    private LinePlot _envelopeGraphic;
    private boolean _envelopeEnabled;
    private ClosedPathPlot _gradientPlot;
    private HTMLGraphic _mathGraphic;
    private Domain _domain;
    private WavePacketKWidthPlot _kWidthPlot;

    public D2CAmplitudesView(Component component, GaussianWavePacket gaussianWavePacket) {
        super(component);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._wavePacket = gaussianWavePacket;
        this._wavePacket.addObserver(this);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(component);
        phetShapeGraphic.setShape(new Rectangle(0, 0, D2CAmplitudesView.BACKGROUND_SIZE.width, D2CAmplitudesView.BACKGROUND_SIZE.height));
        phetShapeGraphic.setPaint(BACKGROUND_COLOR);
        phetShapeGraphic.setStroke(BACKGROUND_STROKE);
        phetShapeGraphic.setBorderColor(BACKGROUND_BORDER_COLOR);
        phetShapeGraphic.setLocation(0, 0);
        this.addGraphic(phetShapeGraphic, 1.0);
        String string = FourierResources.getString("D2CAmplitudesView.title");
        PhetTextGraphic phetTextGraphic = new PhetTextGraphic(component, TITLE_FONT, string, TITLE_COLOR);
        phetTextGraphic.centerRegistrationPoint();
        phetTextGraphic.rotate(-1.5707963267948966);
        phetTextGraphic.setLocation(40, D2CAmplitudesView.BACKGROUND_SIZE.height / 2);
        this.addGraphic(phetTextGraphic, 2.0);
        this._chartGraphic = new D2CAmplitudesChart(component, CHART_RANGE, CHART_SIZE);
        this._chartGraphic.setRegistrationPoint(0, 0);
        this._chartGraphic.setLocation(0, 0);
        this._kWidthPlot = new WavePacketKWidthPlot(component, (Chart)this._chartGraphic, this._wavePacket);
        this._chartGraphic.addDataSetGraphic(this._kWidthPlot);
        int n = 25;
        int n2 = 25;
        this._flattenedChart = new FlattenedChart(component, this._chartGraphic, n, n2);
        this.addGraphic(this._flattenedChart, 3.0);
        this._flattenedChart.setRegistrationPoint(0, 0);
        this._flattenedChart.setLocation(60 - n, 35 - n2);
        Color color = new Color(0, 0, 0);
        Color color2 = new Color(230, 230, 230);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, D2CAmplitudesView.CHART_SIZE.width, 0.0f, color2);
        this._gradientPlot = new ClosedPathPlot(this.getComponent(), (Chart)this._chartGraphic, gradientPaint);
        this._envelopeGraphic = new LinePlot(component, this._chartGraphic);
        this._envelopeGraphic.setBorderColor(ENVELOPE_COLOR);
        this._envelopeGraphic.setStroke(ENVELOPE_STROKE);
        this._envelopeGraphic.setDataSet(new DataSet());
        this._mathGraphic = new HTMLGraphic(component, MATH_FONT, "", MATH_COLOR);
        this.addGraphic(this._mathGraphic, 4.0);
        this._mathGraphic.centerRegistrationPoint();
        this._mathGraphic.setLocation(350, 17);
        this.setIgnoreMouse(true);
        this.reset();
    }

    public void reset() {
        this._envelopeEnabled = false;
        this._envelopeGraphic.setVisible(this._envelopeEnabled);
        this.setDomain(Domain.SPACE);
        this.update();
    }

    public void setDomain(Domain domain) {
        this._domain = domain;
        this._kWidthPlot.setDomain(domain);
        this.updateMath();
        this.updateAxisTitles();
    }

    public Chart getChart() {
        return this._chartGraphic;
    }

    public void setEnvelopeEnabled(boolean bl) {
        this._envelopeEnabled = bl;
        if (bl) {
            this.updateEnvelope();
        }
        this._envelopeGraphic.setVisible(bl);
        this.refreshChart();
    }

    public boolean isEnvelopeEnabled() {
        return this._envelopeEnabled;
    }

    public void setKWidthVisible(boolean bl) {
        this._kWidthPlot.setVisible(bl);
        this.refreshChart();
    }

    public void update() {
        this.updateMath();
        DataSetGraphic[] dataSetGraphicArray = this._chartGraphic.getDataSetGraphics();
        for (int i = 0; i < dataSetGraphicArray.length; ++i) {
            if (!(dataSetGraphicArray[i] instanceof BarPlot)) continue;
            dataSetGraphicArray[i].cleanup();
        }
        this._chartGraphic.removeAllDataSetGraphics();
        this._envelopeGraphic.setVisible(this._envelopeEnabled);
        this._chartGraphic.addDataSetGraphic(this._envelopeGraphic);
        double d = this._wavePacket.getK1();
        if (d > 0.0) {
            this.addBarPlots();
        } else {
            this.addGeneralPathPlot();
        }
        if (this._envelopeEnabled) {
            this.updateEnvelope();
        }
        this._kWidthPlot.update();
        this._chartGraphic.addDataSetGraphic(this._kWidthPlot);
        this.refreshChart();
    }

    private void addBarPlots() {
        double d = this._wavePacket.getK1();
        assert (d > 0.0);
        double d2 = this._wavePacket.getK0();
        double d3 = this._wavePacket.getDeltaK();
        int n = this._wavePacket.getNumberOfComponents();
        int n2 = -230 / n;
        double d4 = 0.5890486225480862;
        for (int i = 0; i < n; ++i) {
            int n3 = 0 - i * n2;
            int n4 = 0 - i * n2;
            int n5 = 0 - i * n2;
            Color color = new Color(n3, n4, n5);
            BarPlot barPlot = new BarPlot(this.getComponent(), (Chart)this._chartGraphic, d4);
            barPlot.setFillColor(color);
            this._chartGraphic.addDataSetGraphic(barPlot);
            double d5 = (double)(i + 1) * d;
            double d6 = GaussianWavePacket.getAmplitude(d5, d2, d3) * d;
            DataSet dataSet = barPlot.getDataSet();
            dataSet.addPoint(new Point2D.Double(d5, d6));
        }
        double d7 = GaussianWavePacket.getAmplitude(d2, d2, d3) * d;
        this._chartGraphic.autoscaleY(d7 * 1.05);
    }

    private void addGeneralPathPlot() {
        double d;
        DataSet dataSet = this._gradientPlot.getDataSet();
        dataSet.clear();
        double d2 = this._wavePacket.getK0();
        double d3 = this._wavePacket.getDeltaK();
        double d4 = 0.0;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        arrayList.add(new Point2D.Double(d, 0.0));
        for (d = 0.0; d <= 78.53981633974483; d += 0.3141592653589793) {
            double d5 = GaussianWavePacket.getAmplitude(d, d2, d3);
            arrayList.add(new Point2D.Double(d, d5));
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        arrayList.add(new Point2D.Double(d, 0.0));
        dataSet.addPoints(arrayList.toArray(new Point2D.Double[arrayList.size()]));
        this._chartGraphic.addDataSetGraphic(this._gradientPlot);
        this._chartGraphic.autoscaleY(d4 * 1.05);
    }

    private void updateEnvelope() {
        DataSet dataSet = this._envelopeGraphic.getDataSet();
        dataSet.clear();
        double d = this._wavePacket.getDeltaK();
        double d2 = this._wavePacket.getK0();
        double d3 = this._wavePacket.getK1();
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (double d4 = 0.0; d4 <= 78.53981633974483; d4 += 0.3141592653589793) {
            double d5 = GaussianWavePacket.getAmplitude(d4, d2, d);
            if (d3 != 0.0) {
                d5 *= d3;
            }
            arrayList.add(new Point2D.Double(d4, d5));
        }
        dataSet.addPoints(arrayList.toArray(new Point2D.Double[arrayList.size()]));
    }

    private void updateMath() {
        if (this._wavePacket.getK1() != 0.0) {
            this._mathGraphic.setHTML("<html>A<sub>n</sub></html>");
        } else if (this._domain == Domain.SPACE) {
            this._mathGraphic.setHTML("<html>A(k)</html>");
        } else if (this._domain == Domain.TIME) {
            this._mathGraphic.setHTML("<html>A(" + MathStrings.C_OMEGA + ")</html>");
        }
        this._mathGraphic.centerRegistrationPoint();
    }

    private void updateAxisTitles() {
        if (this._domain == Domain.SPACE) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("D2CAmplitudesView.xTitleSpace"));
        } else if (this._domain == Domain.TIME) {
            this._chartGraphic.setXAxisTitle(FourierResources.getString("D2CAmplitudesView.xTitleTime"));
        }
        this.refreshChart();
    }

    private void refreshChart() {
        this._flattenedChart.flatten();
    }
}

