/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.EventListenerList;

public class AnimationCycleController
extends ClockAdapter {
    private double _ticksPerCycle;
    private boolean _enabled;
    private double _cyclePoint;
    private EventListenerList _listenerList;

    public AnimationCycleController(double d) {
        this._ticksPerCycle = d;
        this._enabled = true;
        this._cyclePoint = 0.0;
        this._listenerList = new EventListenerList();
    }

    public void reset() {
        double d = -this._cyclePoint;
        this._cyclePoint = 0.0;
        this.fireAnimationCycleEvent(this._cyclePoint, d);
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public void addAnimationCycleListener(AnimationCycleListener animationCycleListener) {
        this._listenerList.add(AnimationCycleListener.class, animationCycleListener);
    }

    private void fireAnimationCycleEvent(double d, double d2) {
        AnimationCycleEvent animationCycleEvent = new AnimationCycleEvent(this, d, d2);
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != AnimationCycleListener.class) continue;
            ((AnimationCycleListener)objectArray[i + 1]).animate(animationCycleEvent);
        }
    }

    public void clockTicked(ClockEvent clockEvent) {
        if (this._enabled) {
            double d = (this._cyclePoint + clockEvent.getSimulationTimeChange() / this._ticksPerCycle) % 1.0;
            double d2 = d - this._cyclePoint;
            this._cyclePoint = d;
            this.fireAnimationCycleEvent(this._cyclePoint, d2);
        }
    }

    public static class AnimationCycleEvent
    extends EventObject {
        private double _cyclePoint;
        private double _delta;

        public AnimationCycleEvent(Object object, double d, double d2) {
            super(object);
            assert (d >= 0.0 && d <= 1.0);
            assert (d2 >= -1.0 && d2 <= 1.0);
            this._cyclePoint = d;
            this._delta = d2;
        }

        public double getCyclePoint() {
            return this._cyclePoint;
        }

        public double getDelta() {
            return this._delta;
        }
    }

    public static interface AnimationCycleListener
    extends EventListener {
        public void animate(AnimationCycleEvent var1);
    }
}

