/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.help;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphicListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;

public class HelpBubble
extends CompositePhetGraphic
implements PhetGraphicListener {
    private static final Color ARROW_FILL_COLOR = new Color(250, 250, 170, 175);
    private static final Color ARROW_BORDER_COLOR = Color.BLACK;
    private static final Stroke ARROW_STROKE = new BasicStroke(1.0f);
    private static final Font TEXT_FONT = new PhetFont(0, 14);
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Color BUBBLE_FILL_COLOR = ARROW_FILL_COLOR;
    private static final Color BUBBLE_BORDER_COLOR = ARROW_BORDER_COLOR;
    private static final Stroke BUBBLE_STROKE = ARROW_STROKE;
    private CompositePhetGraphic _bubbleTextGraphic;
    private PhetShapeGraphic _bubbleGraphic;
    private HTMLGraphic _textGraphic;
    private PhetShapeGraphic _arrowGraphic;
    private PhetGraphic _target;
    private int _arrowPosition;
    private int _arrowLength;

    public HelpBubble(Component component, String string) {
        super(component);
        assert (component != null);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._textGraphic = new HTMLGraphic(component);
        this._textGraphic.setFont(TEXT_FONT);
        this._textGraphic.setHTML(string);
        this._textGraphic.setColor(TEXT_COLOR);
        this._textGraphic.setLocation(4, 4);
        this._bubbleGraphic = new PhetShapeGraphic(component);
        int n = this._textGraphic.getWidth() + 8;
        int n2 = this._textGraphic.getHeight() + 8;
        this._bubbleGraphic.setShape(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 15.0, 15.0));
        this._bubbleGraphic.setColor(BUBBLE_FILL_COLOR);
        this._bubbleGraphic.setBorderColor(BUBBLE_BORDER_COLOR);
        this._bubbleGraphic.setStroke(BUBBLE_STROKE);
        this._bubbleGraphic.setLocation(0, 0);
        this._bubbleTextGraphic = new CompositePhetGraphic(component);
        this._bubbleTextGraphic.addGraphic(this._bubbleGraphic);
        this._bubbleTextGraphic.addGraphic(this._textGraphic);
        this._bubbleTextGraphic.setLocation(0, 0);
        this._arrowGraphic = new PhetShapeGraphic(component);
        this._arrowGraphic.setColor(ARROW_FILL_COLOR);
        this._arrowGraphic.setStroke(ARROW_STROKE);
        this._arrowGraphic.setBorderColor(ARROW_BORDER_COLOR);
        this._arrowGraphic.setLocation(0, 0);
        this.addGraphic(this._arrowGraphic, 1.0);
        this.addGraphic(this._bubbleTextGraphic, 2.0);
        this._target = null;
        this._arrowLength = 0;
        this.setIgnoreMouse(true);
    }

    public void phetGraphicChanged(PhetGraphic phetGraphic) {
        if (this._target != null) {
            this.trackTarget();
        }
    }

    public void phetGraphicVisibilityChanged(PhetGraphic phetGraphic) {
        this.setVisible(this._target.isVisible());
    }

    private void trackTarget() {
        int n = 0;
        int n2 = 0;
        switch (this._arrowPosition) {
            case 0: 
            case 1: 
            case 2: {
                n = this._target.getBounds().x + this._target.getWidth() / 2;
                n2 = this._target.getBounds().y + this._target.getHeight();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n = this._target.getBounds().x + this._target.getWidth() / 2;
                n2 = this._target.getBounds().y;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n = this._target.getBounds().x + this._target.getWidth();
                n2 = this._target.getBounds().y + this._target.getHeight() / 2;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                n = this._target.getBounds().x;
                n2 = this._target.getBounds().y + this._target.getHeight() / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal arrow position: " + this._arrowPosition);
            }
        }
        this.setLocation(n, n2);
    }

    public void pointAt(PhetGraphic phetGraphic, int n, int n2) {
        if (!this.isValidArrowPostion(n)) {
            throw new IllegalArgumentException("illegal arrowPosition: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("arrowLength must be > 0: " + n2);
        }
        this._arrowPosition = n;
        this._arrowLength = n2;
        this.layout();
        if (this._target != null) {
            this._target.removePhetGraphicListener(this);
        }
        this._target = phetGraphic;
        if (this._target != null) {
            this._target.addPhetGraphicListener(this);
            this.setRegistrationPoint(0, 0);
            this.trackTarget();
        }
    }

    public void pointAt(Point point, int n, int n2) {
        this.pointAt(point.x, point.y, n, n2);
    }

    public void pointAt(int n, int n2, int n3, int n4) {
        if (!this.isValidArrowPostion(n3)) {
            throw new IllegalArgumentException("illegal arrowPosition: " + n3);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("arrowLength must be > 0: " + n4);
        }
        this._arrowPosition = n3;
        this._arrowLength = n4;
        this.layout();
        this.setRegistrationPoint(0, 0);
        this.setLocation(n, n2);
    }

    private void layout() {
        int n = this._textGraphic.getWidth() + 8;
        int n2 = this._textGraphic.getHeight() + 8;
        this._bubbleGraphic.setShape(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 15.0, 15.0));
        if (this._arrowLength == 0) {
            this._arrowGraphic.setShape(null);
            this._bubbleGraphic.setLocation(0, 0);
            return;
        }
        Point point = new Point(0, 0);
        Point point2 = new Point();
        switch (this._arrowPosition) {
            case 0: 
            case 1: 
            case 2: {
                point2.setLocation(0, this._arrowLength);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                point2.setLocation(0, -this._arrowLength);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                point2.setLocation(this._arrowLength, 0);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                point2.setLocation(-this._arrowLength, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal arrow position: " + this._arrowPosition);
            }
        }
        Arrow arrow = new Arrow(point2, point, 10.0, 10.0, 3.0);
        this._arrowGraphic.setShape(arrow.getShape());
        int n3 = 0;
        int n4 = 0;
        switch (this._arrowPosition) {
            case 0: {
                n3 = -this._arrowGraphic.getWidth();
                n4 = this._arrowGraphic.getHeight() + 0;
                break;
            }
            case 1: {
                n3 = -this._bubbleTextGraphic.getWidth() / 2;
                n4 = this._arrowGraphic.getHeight() + 0;
                break;
            }
            case 2: {
                n3 = -(this._bubbleTextGraphic.getWidth() - this._arrowGraphic.getWidth());
                n4 = this._arrowGraphic.getHeight() + 0;
                break;
            }
            case 3: {
                n3 = -this._arrowGraphic.getWidth();
                n4 = -(this._bubbleTextGraphic.getHeight() + this._arrowGraphic.getHeight() + 0);
                break;
            }
            case 4: {
                n3 = -this._bubbleTextGraphic.getWidth() / 2;
                n4 = -(this._bubbleTextGraphic.getHeight() + this._arrowGraphic.getHeight() + 0);
                break;
            }
            case 5: {
                n3 = -(this._bubbleTextGraphic.getWidth() - this._arrowGraphic.getWidth());
                n4 = -(this._bubbleTextGraphic.getHeight() + this._arrowGraphic.getHeight() + 0);
                break;
            }
            case 6: {
                n3 = this._arrowGraphic.getWidth() + 0;
                n4 = -this._arrowGraphic.getHeight();
                break;
            }
            case 7: {
                n3 = this._arrowGraphic.getWidth() + 0;
                n4 = -this._bubbleTextGraphic.getHeight() / 2;
                break;
            }
            case 8: {
                n3 = this._arrowGraphic.getWidth() + 0;
                n4 = -(this._bubbleTextGraphic.getHeight() - this._arrowGraphic.getHeight());
                break;
            }
            case 9: {
                n3 = -(this._bubbleTextGraphic.getWidth() + this._arrowGraphic.getWidth() + 0);
                n4 = -this._arrowGraphic.getHeight();
                break;
            }
            case 10: {
                n3 = -(this._bubbleTextGraphic.getWidth() + this._arrowGraphic.getWidth() + 0);
                n4 = -this._bubbleTextGraphic.getHeight() / 2;
                break;
            }
            case 11: {
                n3 = -(this._bubbleTextGraphic.getWidth() + this._arrowGraphic.getWidth() + 0);
                n4 = -(this._bubbleTextGraphic.getHeight() - this._arrowGraphic.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal arrow position: " + this._arrowPosition);
            }
        }
        this._bubbleTextGraphic.setLocation(n3, n4);
    }

    public boolean isValidArrowPostion(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 10 || n == 11;
    }
}

