/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.event;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;

public class FourierDragHandler
extends MouseInputAdapter {
    private PhetGraphic _graphic;
    private boolean _dragEnabled;
    private Point _previousPoint;
    private Rectangle _dragBounds;

    public FourierDragHandler(PhetGraphic phetGraphic) {
        assert (phetGraphic != null);
        this._graphic = phetGraphic;
        this._dragEnabled = true;
        this._previousPoint = new Point();
        this._dragBounds = null;
    }

    public void setDragBounds(int n, int n2, int n3, int n4) {
        if (this._dragBounds == null) {
            this._dragBounds = new Rectangle();
        }
        this._dragBounds.setBounds(n, n2, n3, n4);
    }

    public void setDragBounds(Rectangle rectangle) {
        this.setDragBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this._dragEnabled = true;
        this._previousPoint.setLocation(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._dragEnabled && this._graphic.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this._dragEnabled = true;
            this._previousPoint.setLocation(mouseEvent.getPoint());
        }
        if (this._dragEnabled) {
            int n = mouseEvent.getX() - this._previousPoint.x;
            int n2 = mouseEvent.getY() - this._previousPoint.y;
            boolean bl = false;
            if (this._dragBounds != null) {
                boolean bl2 = bl = !this._dragBounds.contains(mouseEvent.getPoint());
            }
            if (bl) {
                this._dragEnabled = false;
            } else {
                int n3 = this._graphic.getX() + n;
                int n4 = this._graphic.getY() + n2;
                this._graphic.setLocation(n3, n4);
                this._previousPoint.setLocation(mouseEvent.getPoint());
            }
        }
    }
}

