/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.enums;

import edu.colorado.phet.fourier.enums.FourierEnum;
import edu.colorado.phet.fourier.enums.WaveType;
import java.awt.geom.Point2D;

public class Preset
extends FourierEnum {
    public static final Preset UNDEFINED = new Preset("undefined");
    public static final Preset SINE_COSINE = new Preset("sineCosine");
    public static final Preset SQUARE = new Preset("square");
    public static final Preset SAWTOOTH = new Preset("sawtooth");
    public static final Preset TRIANGLE = new Preset("triangle");
    public static final Preset WAVE_PACKET = new Preset("wavePacket");
    public static final Preset CUSTOM = new Preset("custom");
    private static final double[] SINE_COSINE_AMPLITUDES = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] SINE_SQUARE_AMPLITUDES = new double[]{1.2732395447351628, 0.0, 0.4244131815783876, 0.0, 0.25464790894703254, 0.0, 0.18189136353359467, 0.0, 0.1414710605261292, 0.0, 0.11574904952137845};
    private static final double[] COSINE_SQUARE_AMPLITUDES = new double[]{1.2732395447351628, 0.0, -0.4244131815783876, 0.0, 0.25464790894703254, 0.0, -0.18189136353359467, 0.0, 0.1414710605261292, 0.0, -0.11574904952137845};
    private static final double[] SINE_TRIANGLE_AMPLITUDES = new double[]{0.8105694691387022, 0.0, -0.09006327434874468, 0.0, 0.03242277876554809, 0.0, -0.01654223406405515, 0.0, 0.010007030483193855, 0.0, -0.006698921232551258};
    private static final double[] COSINE_TRIANGLE_AMPLITUDES = new double[]{0.8105694691387022, 0.0, 0.09006327434874468, 0.0, 0.03242277876554809, 0.0, 0.01654223406405515, 0.0, 0.010007030483193855, 0.0, 0.006698921232551258};
    private static final double[] SINE_SAWTOOTH_AMPLITUDES = new double[]{0.6366197723675814, -0.3183098861837907, 0.2122065907891938, -0.15915494309189535, 0.12732395447351627, -0.1061032953945969, 0.09094568176679733, -0.07957747154594767, 0.0707355302630646, -0.06366197723675814, 0.057874524760689224};
    private static final double[][] WAVE_PACKET_AMPLITUDES = new double[][]{{1.0}, {0.457833, 0.457833}, {0.249352, 1.0, 0.249352}, {0.172422, 0.822578, 0.822578, 0.172422}, {0.135335, 0.606531, 1.0, 0.606531, 0.135335}, {0.114162, 0.457833, 0.916855, 0.916855, 0.457833, 0.114162}, {0.100669, 0.360448, 0.774837, 1.0, 0.774837, 0.360448, 0.100669}, {0.091394, 0.295023, 0.644389, 0.952345, 0.952345, 0.644389, 0.295023, 0.091394}, {0.084658, 0.249352, 0.539408, 0.856997, 1.0, 0.856997, 0.539408, 0.249352, 0.084658}, {0.07956, 0.216255, 0.457833, 0.75484, 0.969233, 0.969233, 0.75484, 0.457833, 0.216255, 0.07956}, {0.075574, 0.191495, 0.394652, 0.661515, 0.901851, 1.0, 0.901851, 0.661515, 0.394652, 0.191495, 0.075574}};
    private static final Point2D[] SINE_SQUARE_POINTS = new Point2D[]{new Point2D.Double(-3.0, -1.0), new Point2D.Double(-3.0, 1.0), new Point2D.Double(-2.5, 1.0), new Point2D.Double(-2.5, -1.0), new Point2D.Double(-2.0, -1.0), new Point2D.Double(-2.0, 1.0), new Point2D.Double(-1.5, 1.0), new Point2D.Double(-1.5, -1.0), new Point2D.Double(-1.0, -1.0), new Point2D.Double(-1.0, 1.0), new Point2D.Double(-0.5, 1.0), new Point2D.Double(-0.5, -1.0), new Point2D.Double(0.0, -1.0), new Point2D.Double(0.0, 1.0), new Point2D.Double(0.5, 1.0), new Point2D.Double(0.5, -1.0), new Point2D.Double(1.0, -1.0), new Point2D.Double(1.0, 1.0), new Point2D.Double(1.5, 1.0), new Point2D.Double(1.5, -1.0), new Point2D.Double(2.0, -1.0), new Point2D.Double(2.0, 1.0)};
    private static final Point2D[] COSINE_SQUARE_POINTS = new Point2D[]{new Point2D.Double(-3.25, 1.0), new Point2D.Double(-2.75, 1.0), new Point2D.Double(-2.75, -1.0), new Point2D.Double(-2.25, -1.0), new Point2D.Double(-2.25, 1.0), new Point2D.Double(-1.75, 1.0), new Point2D.Double(-1.75, -1.0), new Point2D.Double(-1.25, -1.0), new Point2D.Double(-1.25, 1.0), new Point2D.Double(-0.75, 1.0), new Point2D.Double(-0.75, -1.0), new Point2D.Double(-0.25, -1.0), new Point2D.Double(-0.25, 1.0), new Point2D.Double(0.25, 1.0), new Point2D.Double(0.25, -1.0), new Point2D.Double(0.75, -1.0), new Point2D.Double(0.75, 1.0), new Point2D.Double(1.25, 1.0), new Point2D.Double(1.25, -1.0), new Point2D.Double(1.75, -1.0), new Point2D.Double(1.75, 1.0), new Point2D.Double(2.25, 1.0)};
    private static final Point2D[] SINE_TRIANGLE_POINTS = new Point2D[]{new Point2D.Double(-3.25, -1.0), new Point2D.Double(-2.75, 1.0), new Point2D.Double(-2.25, -1.0), new Point2D.Double(-1.75, 1.0), new Point2D.Double(-1.25, -1.0), new Point2D.Double(-0.75, 1.0), new Point2D.Double(-0.25, -1.0), new Point2D.Double(0.25, 1.0), new Point2D.Double(0.75, -1.0), new Point2D.Double(1.25, 1.0), new Point2D.Double(1.75, -1.0), new Point2D.Double(2.25, 1.0)};
    private static final Point2D[] COSINE_TRIANGLE_POINTS = new Point2D[]{new Point2D.Double(-3.0, 1.0), new Point2D.Double(-2.5, -1.0), new Point2D.Double(-2.0, 1.0), new Point2D.Double(-1.5, -1.0), new Point2D.Double(-1.0, 1.0), new Point2D.Double(-0.5, -1.0), new Point2D.Double(0.0, 1.0), new Point2D.Double(0.5, -1.0), new Point2D.Double(1.0, 1.0), new Point2D.Double(1.5, -1.0), new Point2D.Double(2.0, 1.0)};
    private static final Point2D[] SINE_SAWTOOTH_POINTS = new Point2D[]{new Point2D.Double(-3.5, -1.0), new Point2D.Double(-2.5, 1.0), new Point2D.Double(-2.5, -1.0), new Point2D.Double(-1.5, 1.0), new Point2D.Double(-1.5, -1.0), new Point2D.Double(-0.5, 1.0), new Point2D.Double(-0.5, -1.0), new Point2D.Double(0.5, 1.0), new Point2D.Double(0.5, -1.0), new Point2D.Double(1.5, 1.0), new Point2D.Double(1.5, -1.0), new Point2D.Double(2.5, 1.0)};

    private Preset(String string) {
        super(string);
    }

    public static Preset getByName(String string) {
        Preset preset = null;
        if (SINE_COSINE.isNamed(string)) {
            preset = SINE_COSINE;
        } else if (SQUARE.isNamed(string)) {
            preset = SQUARE;
        } else if (SAWTOOTH.isNamed(string)) {
            preset = SAWTOOTH;
        } else if (TRIANGLE.isNamed(string)) {
            preset = TRIANGLE;
        } else if (WAVE_PACKET.isNamed(string)) {
            preset = WAVE_PACKET;
        } else if (CUSTOM.isNamed(string)) {
            preset = CUSTOM;
        } else if (UNDEFINED.isNamed(string)) {
            preset = UNDEFINED;
        }
        return preset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double[] getPresetAmplitudes(Preset preset, WaveType waveType, int n) {
        double[] dArray = null;
        if (preset == SINE_COSINE) {
            return SINE_COSINE_AMPLITUDES;
        }
        if (preset == SQUARE) {
            if (waveType != WaveType.SINES) return COSINE_SQUARE_AMPLITUDES;
            return SINE_SQUARE_AMPLITUDES;
        }
        if (preset == SAWTOOTH) {
            if (waveType != WaveType.SINES) throw new IllegalStateException("you can't make a sawtooth wave out of cosines because it is asymmetric");
            return SINE_SAWTOOTH_AMPLITUDES;
        }
        if (preset == TRIANGLE) {
            if (waveType != WaveType.SINES) return COSINE_TRIANGLE_AMPLITUDES;
            return SINE_TRIANGLE_AMPLITUDES;
        }
        if (preset == WAVE_PACKET) {
            return WAVE_PACKET_AMPLITUDES[n - 1];
        }
        if (preset != CUSTOM) throw new IllegalStateException("you forgot to implement a preset: " + preset);
        return null;
    }

    public static Point2D[] getPresetPoints(Preset preset, WaveType waveType) {
        Point2D[] point2DArray = null;
        if (preset == SQUARE) {
            point2DArray = waveType == WaveType.SINES ? SINE_SQUARE_POINTS : COSINE_SQUARE_POINTS;
        } else if (preset == TRIANGLE) {
            point2DArray = waveType == WaveType.SINES ? SINE_TRIANGLE_POINTS : COSINE_TRIANGLE_POINTS;
        } else if (preset == SAWTOOTH && waveType == WaveType.SINES) {
            point2DArray = SINE_SAWTOOTH_POINTS;
        }
        return point2DArray;
    }
}

