/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control.sliders;

import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.control.sliders.AbstractFourierSlider;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JLabel;

public class WavePacketXWidthSlider
extends AbstractFourierSlider {
    private DecimalFormat _xWidthFormatter;

    public WavePacketXWidthSlider() {
        super(FourierResources.getString("WavePacketXWidthSlider.format.space"));
        this.getSlider().setMinimum(79);
        this.getSlider().setMaximum(1000);
        this.getSlider().setInverted(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(1000), new JLabel(".08"));
        hashtable.put(new Integer(879), new JLabel(".2"));
        hashtable.put(new Integer(679), new JLabel(".4"));
        hashtable.put(new Integer(479), new JLabel(".6"));
        hashtable.put(new Integer(279), new JLabel(".8"));
        hashtable.put(new Integer(79), new JLabel("1"));
        this.getSlider().setLabelTable(hashtable);
        this.getSlider().setPaintLabels(true);
        this.getSlider().setMajorTickSpacing(920);
        this.getSlider().setMinorTickSpacing(200);
        this.getSlider().setPaintTicks(true);
    }

    public void setValue(double d) {
        int n = (int)(1079.5774715459477 - d * 1000.0);
        this.getSlider().setValue(n);
    }

    public double getValue() {
        int n = this.getSlider().getValue();
        double d = (1079.5774715459477 - (double)n) / 1000.0;
        if (d > 1.0) {
            d = 1.0;
        }
        return d;
    }

    protected void updateLabel() {
        String string = this.getFormat();
        double d = this.getValue();
        if (this._xWidthFormatter == null) {
            this._xWidthFormatter = new DecimalFormat("#.###");
        }
        String string2 = this._xWidthFormatter.format(d);
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        this.getLabel().setText(string3);
    }
}

