/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.control;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.fourier.FourierResources;
import edu.colorado.phet.fourier.MathStrings;
import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.model.FourierSeries;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExpandSumDialog
extends PaintImmediateDialog
implements SimpleObserver {
    private static final NumberFormat VALUE_FORMATTER = new DecimalFormat("0.##");
    private static boolean SHOW_TERMS_WITH_ZERO_AMPLITUDE = true;
    private FourierSeries _fourierSeries;
    private JLabel _label;
    private JButton _closeButton;
    private Domain _domain;
    private MathForm _mathForm;

    public ExpandSumDialog(Frame frame, FourierSeries fourierSeries) {
        super(frame);
        this.setTitle(FourierResources.getString("ExpandSumDialog.title"));
        this.setModal(false);
        this.setResizable(false);
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(1);
        this._fourierSeries = fourierSeries;
        this._fourierSeries.addObserver(this);
        this._domain = Domain.SPACE;
        this._mathForm = MathForm.WAVE_NUMBER;
        this.createUI();
        this.update();
    }

    private void createUI() {
        JPanel jPanel = this.createInputPanel();
        JPanel jPanel2 = this.createActionsPanel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel3);
        this.pack();
    }

    private JPanel createInputPanel() {
        this._label = new JLabel("Foo");
        JPanel jPanel = new JPanel();
        jPanel.add(this._label);
        return jPanel;
    }

    private JPanel createActionsPanel() {
        this._closeButton = new JButton(FourierResources.getString("ExpandSumDialog.close"));
        JPanel jPanel = new JPanel(new GridLayout(1, 1, 10, 0));
        jPanel.add(this._closeButton);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jPanel);
        return jPanel2;
    }

    public void setDomainAndMathForm(Domain domain, MathForm mathForm) {
        this._domain = domain;
        this._mathForm = mathForm;
        this.update();
    }

    public JButton getCloseButton() {
        return this._closeButton;
    }

    public void update() {
        String string = MathStrings.getFunction(this._domain);
        String string2 = MathStrings.getTerm(this._domain, this._mathForm, this._fourierSeries.getWaveType());
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(string);
        stringBuffer.append(" =  ");
        int n = 0;
        for (int i = 0; i < this._fourierSeries.getNumberOfHarmonics(); ++i) {
            double d = this._fourierSeries.getHarmonic(i).getAmplitude();
            if (!SHOW_TERMS_WITH_ZERO_AMPLITUDE && d == 0.0) continue;
            if (n != 0) {
                stringBuffer.append(" + ");
            }
            String string3 = VALUE_FORMATTER.format(d);
            Object[] objectArray = new Object[]{string3, new Integer(i + 1)};
            String string4 = MessageFormat.format(string2, objectArray);
            stringBuffer.append(string4);
            if ((n + 1) % 3 == 0) {
                stringBuffer.append("<br>");
            }
            ++n;
        }
        stringBuffer.append("</html>");
        this._label.setText(stringBuffer.toString());
        this.pack();
        if (this.isVisible()) {
            this.hide();
            this.show();
        }
    }
}

