/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.fourier.charts.AbstractPointPlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class WidthPlot
extends AbstractPointPlot {
    private static final Font LABEL_FONT = new PhetFont(1, 16);
    private static final Color LABEL_COLOR = Color.BLACK;
    private static final Color ARROW_COLOR = Color.BLACK;
    private HTMLGraphic _labelGraphic;
    private PhetShapeGraphic _labelBackgroundGraphic;
    private RoundRectangle2D _labelBackgroundShape;
    private PhetShapeGraphic _leftArrowGraphic;
    private PhetShapeGraphic _rightArrowGraphic;
    private double _width;

    public WidthPlot(Component component, Chart chart) {
        super(component, chart);
        this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this._labelBackgroundShape = new RoundRectangle2D.Double();
        this._labelBackgroundGraphic = new PhetShapeGraphic(component);
        this._labelBackgroundGraphic.setShape(this._labelBackgroundShape);
        this.addGraphic(this._labelBackgroundGraphic, 1.0);
        this._labelGraphic = new HTMLGraphic(component, LABEL_FONT, "?", LABEL_COLOR);
        this.addGraphic(this._labelGraphic, 3.0);
        this.handleLabelSizeChange();
        this._leftArrowGraphic = new PhetShapeGraphic(component);
        this._leftArrowGraphic.setColor(ARROW_COLOR);
        this.addGraphic(this._leftArrowGraphic);
        this._rightArrowGraphic = new PhetShapeGraphic(component);
        this._rightArrowGraphic.setColor(ARROW_COLOR);
        this.addGraphic(this._rightArrowGraphic);
        this.setGraphicWidth(0.0);
    }

    public void setLabelBackground(Color color) {
        this._labelBackgroundGraphic.setColor(color);
    }

    private void handleLabelSizeChange() {
        if (this._labelBackgroundGraphic.getPaint() != null) {
            int n = this._labelGraphic.getWidth() + 2;
            int n2 = this._labelGraphic.getHeight() + 2;
            this._labelBackgroundShape.setRoundRect(0.0, 0.0, n, n2, 3.0, 3.0);
            this._labelBackgroundGraphic.setShapeDirty();
            this._labelBackgroundGraphic.centerRegistrationPoint();
            this._labelBackgroundGraphic.setLocation(this._labelGraphic.getLocation());
        }
    }

    public void setLabel(String string) {
        this._labelGraphic.setHTML(string);
        this._labelGraphic.centerRegistrationPoint();
        int n = 0;
        int n2 = -(this._labelGraphic.getHeight() / 2 + 5);
        this._labelGraphic.setLocation(n, n2);
        this.handleLabelSizeChange();
    }

    public void setLabelColor(Color color) {
        this._labelGraphic.setColor(color);
    }

    public void setLabelFont(Font font) {
        this._labelGraphic.setFont(font);
        this.handleLabelSizeChange();
    }

    public void setArrowColor(Color color) {
        this._leftArrowGraphic.setColor(color);
        this._rightArrowGraphic.setColor(color);
    }

    public void setGraphicWidth(double d) {
        this._width = d;
        this.updateGraphic();
    }

    protected void updateGraphic() {
        if (this._width > 0.0) {
            float f = (float)(this.getChart().transformXDouble(this._width) - this.getChart().transformXDouble(0.0));
            if ((double)f > 37.0) {
                Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                Point2D.Double double_2 = new Point2D.Double(-f / 2.0f, 0.0);
                Arrow arrow = new Arrow(double_, double_2, 16.0, 10.0, 3.0, 100.0, false);
                this._leftArrowGraphic.setShape(arrow.getShape());
                Point2D.Double double_3 = new Point2D.Double(f / 2.0f, 0.0);
                Arrow arrow2 = new Arrow(double_, double_3, 16.0, 10.0, 3.0, 100.0, false);
                this._rightArrowGraphic.setShape(arrow2.getShape());
            } else {
                Point2D.Double double_ = new Point2D.Double(-f / 2.0f, 0.0);
                Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() - 24.0, 0.0);
                Arrow arrow = new Arrow(double_4, double_, 16.0, 10.0, 3.0, 100.0, false);
                this._leftArrowGraphic.setShape(arrow.getShape());
                Point2D.Double double_5 = new Point2D.Double(f / 2.0f, 0.0);
                Point2D.Double double_6 = new Point2D.Double(((Point2D)double_5).getX() + 24.0, 0.0);
                Arrow arrow3 = new Arrow(double_6, double_5, 16.0, 10.0, 3.0, 100.0, false);
                this._rightArrowGraphic.setShape(arrow3.getShape());
            }
        } else {
            this._leftArrowGraphic.setShape(null);
            this._rightArrowGraphic.setShape(null);
        }
    }
}

