/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier.charts;

import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.DataSet;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class ClosedPathPlot
extends DataSetGraphic {
    private PhetShapeGraphic _pathGraphic;
    private GeneralPath _pathShape;
    private ArrayList _points = new ArrayList();

    public ClosedPathPlot(Component component, Chart chart, Paint paint) {
        this(component, chart, paint, null, null);
    }

    public ClosedPathPlot(Component component, Chart chart, Paint paint, Paint paint2, Stroke stroke) {
        super(component, chart, new DataSet());
        this._pathShape = new GeneralPath();
        this._pathGraphic = new PhetShapeGraphic(component, this._pathShape, paint, stroke, paint2);
        this.addGraphic(this._pathGraphic);
    }

    public void transformChanged() {
        this.pointsAdded(this.getDataSet().getPoints());
    }

    public void cleared() {
        this._points.clear();
        this.updatePath();
    }

    public void pointAdded(Point2D point2D) {
        this._points.add(point2D);
        this.updatePath();
    }

    public void pointsAdded(Point2D[] point2DArray) {
        for (int i = 0; i < point2DArray.length; ++i) {
            this._points.add(point2DArray[i]);
        }
        this.updatePath();
    }

    private void updatePath() {
        this._pathShape.reset();
        for (int i = 0; i < this._points.size(); ++i) {
            Point2D point2D = (Point2D)this._points.get(i);
            Point2D point2D2 = this.getChart().transformDouble(point2D);
            if (i == 0) {
                this._pathShape.moveTo((float)point2D2.getX(), (float)point2D2.getY());
                continue;
            }
            this._pathShape.lineTo((float)point2D2.getX(), (float)point2D2.getY());
        }
        if (this._points.size() > 1) {
            this._pathShape.closePath();
        }
        this._pathGraphic.setShapeDirty();
    }
}

