/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.fourier;

import edu.colorado.phet.fourier.enums.Domain;
import edu.colorado.phet.fourier.enums.MathForm;
import edu.colorado.phet.fourier.enums.WaveType;

public class MathStrings {
    public static char C_LAMDA = (char)955;
    public static char C_OMEGA = (char)969;
    public static char C_PI = (char)960;
    public static char C_SIGMA = (char)931;
    public static char C_AMPLITUDE = (char)65;
    public static char C_ANGULAR_FREQUENCY = C_OMEGA;
    public static char C_FREQUENCY = (char)102;
    public static char C_INFINITY = (char)8734;
    public static char C_INTEGRAL = (char)8747;
    public static char C_LENGTH = (char)76;
    public static char C_MODE = (char)110;
    public static char C_PERIOD = (char)84;
    public static char C_SPACE = (char)120;
    public static char C_TIME = (char)116;
    public static char C_WAVELENGTH = C_LAMDA;
    public static char C_WAVE_NUMBER = (char)107;
    private static final String COEFFICIENT = C_AMPLITUDE + "<sub>{0}</sub>";
    private static final String COEFFICIENT_N = C_AMPLITUDE + "<sub>" + C_MODE + "</sub>";
    private static final String F_X = "F(" + C_SPACE + ")";
    private static final String F_T = "F(" + C_TIME + ")";
    private static final String F_XT = "F(" + C_SPACE + "," + C_TIME + ")";
    private static final String WAVE_NUMBER_X = "{0} sin( " + C_WAVE_NUMBER + " <sub>{1}</sub>" + C_SPACE + " )";
    private static final String WAVELENGTH_X = "{0} sin( 2" + C_PI + C_SPACE + " / " + C_WAVELENGTH + "<sub>{1}</sub> )";
    private static final String MODE_X = "{0} sin( 2" + C_PI + "{1}" + C_SPACE + " / " + C_LENGTH + " )";
    private static final String ANGULAR_FREQUENCY_T = "{0} sin( " + C_ANGULAR_FREQUENCY + "<sub>{1}</sub>" + C_TIME + " )";
    private static final String FREQUENCY_T = "{0} sin( 2" + C_PI + C_FREQUENCY + "<sub>{1}</sub>" + C_TIME + " )";
    private static final String PERIOD_T = "{0} sin( 2" + C_PI + C_TIME + " / " + C_PERIOD + "<sub>{1}</sub> )";
    private static final String MODE_T = "{0} sin( 2" + C_PI + "{1}" + C_TIME + " / " + C_PERIOD + " )";
    private static final String WAVENUMBER_AND_ANGULAR_FREQUENCY_XT = "{0} sin( " + C_WAVE_NUMBER + "<sub>{1}</sub>" + C_SPACE + " - " + C_ANGULAR_FREQUENCY + "<sub>{1}</sub>" + C_TIME + " )";
    private static final String WAVELENGTH_AND_PERIOD_XT = "{0} sin( 2" + C_PI + "(" + C_SPACE + "/" + C_WAVELENGTH + "<sub>{1}</sub> - " + C_TIME + "/" + C_PERIOD + "<sub>{1}</sub> ) )";
    private static final String MODE_XT = "{0} sin( 2" + C_PI + "{1}( " + C_SPACE + "/" + C_LENGTH + " - " + C_TIME + "/" + C_PERIOD + " ) )";

    public static String getFunction(Domain domain) {
        String string = null;
        if (domain == Domain.SPACE) {
            string = F_X;
        } else if (domain == Domain.TIME) {
            string = F_T;
        } else if (domain == Domain.SPACE_AND_TIME) {
            string = F_XT;
        }
        if (string == null) {
            throw new IllegalArgumentException("unsupported domain: " + domain);
        }
        return string;
    }

    public static String getCoefficient() {
        return COEFFICIENT_N;
    }

    public static String getTerm(Domain domain, MathForm mathForm, WaveType waveType) {
        String string = null;
        if (domain == Domain.SPACE) {
            if (mathForm == MathForm.WAVE_NUMBER) {
                string = WAVE_NUMBER_X;
            } else if (mathForm == MathForm.WAVELENGTH) {
                string = WAVELENGTH_X;
            } else if (mathForm == MathForm.MODE) {
                string = MODE_X;
            }
        } else if (domain == Domain.TIME) {
            if (mathForm == MathForm.ANGULAR_FREQUENCY) {
                string = ANGULAR_FREQUENCY_T;
            } else if (mathForm == MathForm.FREQUENCY) {
                string = FREQUENCY_T;
            } else if (mathForm == MathForm.PERIOD) {
                string = PERIOD_T;
            } else if (mathForm == MathForm.MODE) {
                string = MODE_T;
            }
        } else if (domain == Domain.SPACE_AND_TIME) {
            if (mathForm == MathForm.WAVE_NUMBER_AND_ANGULAR_FREQUENCY) {
                string = WAVENUMBER_AND_ANGULAR_FREQUENCY_XT;
            } else if (mathForm == MathForm.WAVELENGTH_AND_PERIOD) {
                string = WAVELENGTH_AND_PERIOD_XT;
            } else if (mathForm == MathForm.MODE) {
                string = MODE_XT;
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("illegal combination of domain (" + domain + ") " + "and math form (" + mathForm + ")");
        }
        if (waveType == WaveType.COSINES) {
            string = string.replaceAll("sin\\(", "cos(");
        }
        return string;
    }
}

