/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.AbstractTicks;
import edu.colorado.phet.common.charts.Axis;
import edu.colorado.phet.common.charts.DataSetGraphic;
import edu.colorado.phet.common.charts.GridLineSet;
import edu.colorado.phet.common.charts.LabelTable;
import edu.colorado.phet.common.charts.Orientation;
import edu.colorado.phet.common.charts.Range2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.HTMLGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.util.ArrayList;

public class Chart
extends GraphicLayerSet {
    private Component component;
    private Range2D range = new Range2D(0.0, 0.0, 1.0, 1.0);
    private ArrayList dataSetGraphics = new ArrayList();
    private Axis xAxis;
    private Axis yAxis;
    private GridLineSet verticalGridlines;
    private GridLineSet horizonalGridlines;
    private TickMarkSet verticalTicks;
    private TickMarkSet horizontalTicks;
    private Paint background = Color.white;
    private ModelViewTransform2D transform;
    private ArrayList listeners = new ArrayList();
    private GraphicLayerSet compositeDataSetGraphic;
    private PhetShapeGraphic backgroundGraphic;
    private PhetShapeGraphic frameGraphic;
    private HTMLGraphic title;
    private Dimension chartSize;
    private PhetGraphic xAxisTitleGraphic;
    private PhetGraphic yAxisTitleGraphic;

    public Chart(Component component, Range2D range2D, Dimension dimension) {
        this(component, range2D, dimension, Chart.getDefaultMinor(range2D.getWidth()), Chart.getDefaultMajor(range2D.getWidth()), Chart.getDefaultMinor(range2D.getHeight()), Chart.getDefaultMajor(range2D.getHeight()));
    }

    private static double getDefaultMinor(double d) {
        if (d < 20.0) {
            return 1.0;
        }
        double d2 = 20.0;
        return d / d2;
    }

    private static double getDefaultMajor(double d) {
        return Chart.getDefaultMinor(d) * 2.0;
    }

    public Chart(Component component, Range2D range2D, Dimension dimension, double d, double d2, double d3, double d4) {
        super(component);
        this.chartSize = dimension;
        this.component = component;
        this.range.setRange(range2D);
        this.transform = new ModelViewTransform2D(range2D.getBounds(), new Rectangle(dimension));
        this.yAxis = new Axis(this, Orientation.VERTICAL, new BasicStroke(2.0f), Color.black, d3, d4);
        this.verticalTicks = new TickMarkSet(this, Orientation.HORIZONTAL, d3, d4);
        this.verticalGridlines = new GridLineSet(this, Orientation.VERTICAL, d, d2, 0.0);
        this.xAxis = new Axis(this, Orientation.HORIZONTAL, new BasicStroke(2.0f), Color.black, d, d2);
        this.horizontalTicks = new TickMarkSet(this, Orientation.VERTICAL, d, d2);
        this.horizonalGridlines = new GridLineSet(this, Orientation.HORIZONTAL, d3, d4, 0.0);
        this.backgroundGraphic = new PhetShapeGraphic(component, this.getChartBounds(), this.background);
        this.compositeDataSetGraphic = new GraphicLayerSet(component);
        this.frameGraphic = new PhetShapeGraphic(component, this.getChartBounds(), new BasicStroke(1.0f), Color.black);
        this.title = new HTMLGraphic(component, component.getFont(), "Title", Color.black);
        this.title.setVisible(false);
        this.addGraphic(this.backgroundGraphic);
        this.addGraphic(this.verticalGridlines);
        this.addGraphic(this.horizonalGridlines);
        this.addGraphic(this.verticalTicks);
        this.addGraphic(this.horizontalTicks);
        this.addGraphic(this.xAxis);
        this.addGraphic(this.yAxis);
        this.addGraphic(this.compositeDataSetGraphic);
        this.addGraphic(this.frameGraphic);
        this.addGraphic(this.title);
    }

    public void setXAxisTitle(PhetGraphic phetGraphic) {
        if (this.xAxisTitleGraphic != null) {
            this.removeGraphic(this.xAxisTitleGraphic);
        }
        this.xAxisTitleGraphic = phetGraphic;
        this.xAxisTitleGraphic.setLocation(this.chartSize.width + 2, (int)this.transformYDouble(0.0));
        this.addGraphic(this.xAxisTitleGraphic, Double.POSITIVE_INFINITY);
    }

    public void removeAllDataSetGraphics() {
        for (int i = 0; i < this.dataSetGraphics.size(); ++i) {
            this.compositeDataSetGraphic.removeGraphic((DataSetGraphic)this.dataSetGraphics.get(i));
        }
        this.dataSetGraphics.clear();
    }

    public DataSetGraphic[] getDataSetGraphics() {
        return this.dataSetGraphics.toArray(new DataSetGraphic[0]);
    }

    public Dimension getChartSize() {
        return new Dimension(this.chartSize);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public TickMarkSet getVerticalTicks() {
        return this.verticalTicks;
    }

    public TickMarkSet getHorizontalTicks() {
        return this.horizontalTicks;
    }

    public GridLineSet getVerticalGridlines() {
        return this.verticalGridlines;
    }

    public GridLineSet getHorizonalGridlines() {
        return this.horizonalGridlines;
    }

    public void setRange(Range2D range2D) {
        this.range.setRange(range2D);
        this.transform.setModelBounds(range2D.getBounds());
        this.fireTransformChanged();
        this.autorepaint();
    }

    public Range2D getRange() {
        return new Range2D(this.range);
    }

    public void addDataSetGraphic(DataSetGraphic dataSetGraphic, double d) {
        if (dataSetGraphic.getChart() != null && dataSetGraphic.getChart() != this) {
            throw new RuntimeException("DataSetGraphic was associated with the wrong Chart instance.");
        }
        this.dataSetGraphics.add(dataSetGraphic);
        this.compositeDataSetGraphic.addGraphic(dataSetGraphic, d);
    }

    public void addDataSetGraphic(DataSetGraphic dataSetGraphic) {
        this.addDataSetGraphic(dataSetGraphic, 0.0);
    }

    public Component getComponent() {
        return this.component;
    }

    public Point transform(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        return this.transform.modelToView(point2D);
    }

    public Point transform(double d, double d2) {
        return this.transform(new Point2D.Double(d, d2));
    }

    public Point2D transformDouble(Point2D point2D) {
        if (point2D == null) {
            throw new RuntimeException("Null point");
        }
        return this.transform.modelToViewDouble(point2D);
    }

    public Point2D transformDouble(double d, double d2) {
        return this.transformDouble(new Point2D.Double(d, d2));
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public void setChartSize(int n, int n2) {
        this.chartSize = new Dimension(n, n2);
        Rectangle rectangle = new Rectangle(this.chartSize);
        this.backgroundGraphic.setShape(rectangle);
        this.frameGraphic.setShape(rectangle);
        this.transform.setViewBounds(rectangle);
        if (this.xAxisTitleGraphic != null) {
            this.xAxisTitleGraphic.setLocation(this.chartSize.width + 2, (int)this.transformYDouble(0.0));
        }
        if (this.yAxisTitleGraphic != null) {
            this.yAxisTitleGraphic.setLocation((int)this.transformXDouble(0.0), -2);
        }
        this.fireTransformChanged();
        this.setBoundsDirty();
        this.autorepaint();
    }

    public Rectangle getChartBounds() {
        return this.getNetTransform().createTransformedShape(new Rectangle(this.chartSize)).getBounds();
    }

    private void fireTransformChanged() {
        Object object;
        int n;
        for (n = 0; n < this.dataSetGraphics.size(); ++n) {
            object = (DataSetGraphic)this.dataSetGraphics.get(n);
            ((DataSetGraphic)object).transformChanged();
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            object = (Listener)this.listeners.get(n);
            object.transformChanged(this);
        }
    }

    public int transformY(double d) {
        return this.transform((Point2D)new Point2D.Double((double)0.0, (double)d)).y;
    }

    public int transformX(double d) {
        return this.transform((Point2D)new Point2D.Double((double)d, (double)0.0)).x;
    }

    public double transformXDouble(double d) {
        return this.transformDouble(new Point2D.Double(d, 0.0)).getX();
    }

    public double transformYDouble(double d) {
        return this.transformDouble(new Point2D.Double(0.0, d)).getY();
    }

    public static class GridTicks
    extends AbstractTicks {
        private int dx = 0;
        private int dy = 0;

        public GridTicks(Chart chart, Orientation orientation, Stroke stroke, Color color, double d) {
            super(chart, orientation, stroke, color, d);
        }

        public int getVerticalTickX() {
            Chart chart = this.getChart();
            return chart.transformX(chart.getRange().getMinX()) + this.dx;
        }

        public int getHorizontalTickY() {
            Chart chart = this.getChart();
            return chart.transformY(chart.getRange().getMinY()) + this.dy;
        }
    }

    public static interface Listener {
        public void transformChanged(Chart var1);
    }

    public static class TickMarkSet
    extends CompositePhetGraphic {
        private GridTicks majorTicks;
        private GridTicks minorTicks;

        public TickMarkSet(Chart chart, Orientation orientation, double d, double d2) {
            super(chart.getComponent());
            this.minorTicks = new GridTicks(chart, orientation, new BasicStroke(2.0f), Color.black, d);
            this.majorTicks = new GridTicks(chart, orientation, new BasicStroke(2.0f), Color.black, d2);
            this.minorTicks.setVisible(false);
            this.addGraphic(this.minorTicks);
            this.addGraphic(this.majorTicks);
            this.setRangeLabelsVisible(false);
        }

        public void setMajorTicksVisible(boolean bl) {
            this.majorTicks.setVisible(bl);
        }

        public void setMinorTicksVisible(boolean bl) {
            this.minorTicks.setVisible(bl);
        }

        public void setMajorTickLabelsVisible(boolean bl) {
            this.majorTicks.setLabelsVisible(bl);
        }

        public void setMinorTickLabelsVisible(boolean bl) {
            this.minorTicks.setLabelsVisible(bl);
        }

        public void setMajorTickSpacing(double d) {
            this.majorTicks.setSpacing(d);
        }

        public void setMinorTickSpacing(double d) {
            this.minorTicks.setSpacing(d);
        }

        public void setMajorTickFont(Font font) {
            this.majorTicks.setFont(font);
        }

        public void setMinorTickFont(Font font) {
            this.minorTicks.setFont(font);
        }

        public void setMajorTickStroke(Stroke stroke) {
            this.majorTicks.setStroke(stroke);
        }

        public void setMinorTickStroke(Stroke stroke) {
            this.minorTicks.setStroke(stroke);
        }

        public void setMajorLabels(LabelTable labelTable) {
            this.majorTicks.setLabels(labelTable);
        }

        public void setRangeLabelsVisible(boolean bl) {
            this.majorTicks.setRangeLabelsVisible(bl);
        }

        public void setMajorNumberFormat(NumberFormat numberFormat) {
            this.majorTicks.setNumberFormat(numberFormat);
        }

        public void setRangeLabelsNumberFormat(NumberFormat numberFormat) {
            this.majorTicks.setRangeLabelsNumberFormat(numberFormat);
        }
    }
}

