/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.tugofwar;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.KnotNode;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.PullerContext;
import edu.colorado.phet.forcesandmotionbasics.tugofwar.TugOfWarCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import fj.F;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullerNode
extends PNode {
    private final Vector2D initialOffset;
    public final TugOfWarCanvas.PullerColor color;
    private final PhetPPath attachmentNode;
    private final TugOfWarCanvas.PullerSize size;
    public final double scale;
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private final int LAST_PULLER_IMAGE_INDEX = 3;
    private KnotNode knot;
    public static final F<PullerNode, Double> _weight = new F<PullerNode, Double>(){

        @Override
        public Double f(PullerNode pullerNode) {
            return pullerNode.size == TugOfWarCanvas.PullerSize.SMALL ? 400.0 : (pullerNode.size == TugOfWarCanvas.PullerSize.MEDIUM ? 600.0 : (pullerNode.size == TugOfWarCanvas.PullerSize.LARGE ? Double.valueOf(1000.0) : null));
        }
    };
    public static final F<PullerNode, Boolean> _isBlue = new F<PullerNode, Boolean>(){

        @Override
        public Boolean f(PullerNode pullerNode) {
            return pullerNode.color == TugOfWarCanvas.PullerColor.BLUE;
        }
    };
    public static final F<PullerNode, Boolean> _isRed = new F<PullerNode, Boolean>(){

        @Override
        public Boolean f(PullerNode pullerNode) {
            return pullerNode.color == TugOfWarCanvas.PullerColor.RED;
        }
    };
    public static final F<PullerNode, PBounds> _getFullBounds = new F<PullerNode, PBounds>(){

        @Override
        public PBounds f(PullerNode pullerNode) {
            return pullerNode.getFullBounds();
        }
    };
    private final SimpleObserver imageUpdater;

    public PullerNode(IUserComponent iUserComponent, final TugOfWarCanvas.PullerColor pullerColor, final TugOfWarCanvas.PullerSize pullerSize, double d, Vector2D vector2D, final PullerContext pullerContext, final ObservableProperty<TugOfWarCanvas.Mode> observableProperty) {
        this.color = pullerColor;
        this.size = pullerSize;
        this.scale = d;
        final BufferedImage bufferedImage = this.pullerImage(0);
        final PImage pImage = new PImage(this.pullerImage(0));
        this.addChild(pImage);
        this.imageUpdater = new SimpleObserver(){

            public void update() {
                if (PullerNode.this.knot != null && (observableProperty.get() == TugOfWarCanvas.Mode.GOING || observableProperty.get() == TugOfWarCanvas.Mode.PAUSED)) {
                    double d;
                    BufferedImage bufferedImage2 = PullerNode.this.pullerImage(3);
                    pImage.setImage(bufferedImage2);
                    double d2 = pullerSize == TugOfWarCanvas.PullerSize.LARGE ? 40.0 : (pullerSize == TugOfWarCanvas.PullerSize.MEDIUM ? 20.0 : (d = pullerSize == TugOfWarCanvas.PullerSize.SMALL ? 10.0 : 2.147483647E9));
                    if (pullerColor == TugOfWarCanvas.PullerColor.BLUE) {
                        pImage.setOffset((double)(bufferedImage.getWidth() - bufferedImage2.getWidth()) + d, bufferedImage.getHeight() - bufferedImage2.getHeight());
                    } else {
                        pImage.setOffset(0.0 - d, bufferedImage.getHeight() - bufferedImage2.getHeight());
                    }
                } else {
                    pImage.setImage(bufferedImage);
                    pImage.setOffset(0.0, 0.0);
                }
            }
        };
        observableProperty.addObserver(this.imageUpdater);
        this.setScale(d);
        this.setOffset(vector2D.x, vector2D.y);
        this.initialOffset = vector2D;
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new SimSharingDragHandler(iUserComponent, true){

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                pullerContext.startDrag(PullerNode.this);
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(PullerNode.this.getParent());
                PullerNode.this.translate(pDimension.width / PullerNode.this.getScale(), pDimension.height / PullerNode.this.getScale());
                pullerContext.drag(PullerNode.this);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                pullerContext.endDrag(PullerNode.this);
            }
        });
        this.attachmentNode = new PhetPPath(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0), new BasicStroke(2.0f), TRANSPARENT){
            {
                super(shape, stroke, paint);
                this.setOffset(pullerColor == TugOfWarCanvas.PullerColor.BLUE ? (double)bufferedImage.getWidth() - 5.0 : 5.0, bufferedImage.getHeight() - 100 - 4);
            }
        };
        this.addChild(this.attachmentNode);
        VoidFunction1<TugOfWarCanvas.Mode> voidFunction1 = new VoidFunction1<TugOfWarCanvas.Mode>(){

            @Override
            public void apply(TugOfWarCanvas.Mode mode) {
                PullerNode.this.updatePickable();
            }
        };
        observableProperty.addObserver(voidFunction1);
        pullerContext.addCartPositionChangeListener(new VoidFunction0(){

            public void apply() {
                PullerNode.this.updatePickable();
            }
        });
    }

    private void updatePickable() {
        boolean bl = true;
        this.setPickable(bl);
        this.setChildrenPickable(bl);
    }

    private BufferedImage pullerImage(int n) {
        return ForcesAndMotionBasicsResources.RESOURCES.getImage("pull_figure_" + PullerNode.sizeText(this.size) + this.color.name() + "_" + n + ".png");
    }

    private static String sizeText(TugOfWarCanvas.PullerSize pullerSize) {
        return pullerSize == TugOfWarCanvas.PullerSize.LARGE ? "lrg_" : (pullerSize == TugOfWarCanvas.PullerSize.SMALL ? "small_" : "");
    }

    public Point2D getGlobalAttachmentPoint() {
        return this.attachmentNode.getGlobalFullBounds().getCenter2D();
    }

    public void animateHome() {
        this.animateToPositionScaleRotation(this.initialOffset.x, this.initialOffset.y, this.scale, 0.0, 300L);
    }

    public void setKnot(KnotNode knotNode) {
        this.knot = knotNode;
        this.imageUpdater.update();
    }

    public KnotNode getKnot() {
        return this.knot;
    }

    public double getForce() {
        return this.size == TugOfWarCanvas.PullerSize.SMALL ? 50.0 : (this.size == TugOfWarCanvas.PullerSize.MEDIUM ? 100.0 : (this.size == TugOfWarCanvas.PullerSize.LARGE ? 150.0 : Double.NaN));
    }
}

