/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.motion;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNode;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNodeContext;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaterBucketNode
extends StackableNode {
    private final BufferedImage image;
    private final Property<Option<Double>> acceleration;
    private final PhetPPath water;
    private final ArrayList<Double> history = new ArrayList();
    private final StackableNodeContext context;

    public WaterBucketNode(IUserComponent iUserComponent, StackableNodeContext stackableNodeContext, BufferedImage bufferedImage, double d, int n, BooleanProperty booleanProperty, Property<Option<Double>> property) {
        super(iUserComponent, stackableNodeContext, bufferedImage, d, n, booleanProperty, false, bufferedImage, bufferedImage);
        this.image = bufferedImage;
        this.acceleration = property;
        this.water = new PhetPPath(new Color(9, 125, 159));
        this.addChild(this.water);
        this.water.moveToBack();
        this.context = stackableNodeContext;
    }

    public void stepInTime() {
        double d = this.acceleration.get().get();
        this.history.add(d);
        while (this.history.size() > 7) {
            this.history.remove(0);
        }
        double d2 = 4.5;
        double d3 = 9.0;
        double d4 = (double)this.image.getWidth() / 98.0;
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 1.0, (1.0 + d2) * d4, (10.0 + d2) * d4);
        Function.LinearFunction linearFunction2 = new Function.LinearFunction(0.0, 1.0, (9.0 - d3) * d4, (102.0 - d3) * d4);
        Function.LinearFunction linearFunction3 = new Function.LinearFunction(1.0, 0.0, (87.0 - d2) * d4, (96.0 - d2) * d4);
        Function.LinearFunction linearFunction4 = new Function.LinearFunction(1.0, 0.0, (102.0 - d3) * d4, (9.0 - d3) * d4);
        double d5 = 0.5;
        double d6 = 0.0;
        for (Double d7 : this.history) {
            d6 += d7.doubleValue();
        }
        double d8 = d6 / (double)this.history.size();
        double d9 = this.context.isInStack(this) ? -d8 / 50.0 : 0.0;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(linearFunction.evaluate(d5 + d9), linearFunction2.evaluate(d5 + d9));
        doubleGeneralPath.lineTo(linearFunction.evaluate(1.0), linearFunction2.evaluate(1.0));
        doubleGeneralPath.lineTo(linearFunction3.evaluate(1.0), linearFunction4.evaluate(1.0));
        doubleGeneralPath.lineTo(linearFunction3.evaluate(d5 - d9), linearFunction4.evaluate(d5 - d9));
        doubleGeneralPath.closePath();
        this.water.setPathTo(doubleGeneralPath.getGeneralPath());
    }
}

