/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.motion;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.activities.AnimateToScale;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNodeContext;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PDimension;
import fj.F;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StackableNode
extends PNode {
    private Vector2D initialOffset;
    private final double initialScale;
    public final BooleanProperty onSkateboard = new BooleanProperty(false);
    public final IUserComponent component;
    private final double mass;
    public static final F<StackableNode, Boolean> _isOnSkateboard = new F<StackableNode, Boolean>(){

        @Override
        public Boolean f(StackableNode stackableNode) {
            return (Boolean)stackableNode.onSkateboard.get();
        }
    };
    public static final F<StackableNode, Double> _mass = new F<StackableNode, Double>(){

        @Override
        public Double f(StackableNode stackableNode) {
            return stackableNode.mass;
        }
    };
    public final int pusherOffset;
    private final BufferedImage toolboxImage;
    private final BufferedImage flippedStackedImage;
    private double lastSign;
    private final PNode textLabel;
    private final BufferedImage flippedHandsUpImage;

    public StackableNode(IUserComponent iUserComponent, StackableNodeContext stackableNodeContext, BufferedImage bufferedImage, double d, int n, BooleanProperty booleanProperty) {
        this(iUserComponent, stackableNodeContext, bufferedImage, d, n, booleanProperty, false, bufferedImage, bufferedImage);
    }

    public StackableNode(IUserComponent iUserComponent, final StackableNodeContext stackableNodeContext, final BufferedImage bufferedImage, final double d, int n, final BooleanProperty booleanProperty, final boolean bl, final BufferedImage bufferedImage2, final BufferedImage bufferedImage3) {
        this.component = iUserComponent;
        this.mass = d;
        this.pusherOffset = n;
        this.toolboxImage = bufferedImage2;
        this.flippedStackedImage = BufferedImageUtils.flipX(bufferedImage);
        this.flippedHandsUpImage = BufferedImageUtils.flipX(bufferedImage3);
        final PImage pImage = new PImage(bufferedImage2){
            {
                super(image);
                StackableNode.this.onSkateboard.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.updateImage();
                    }
                });
                if (bl) {
                    stackableNodeContext.getAppliedForce().addObserver(new VoidFunction1<Double>(){

                        @Override
                        public void apply(Double d) {
                            this.updateImage();
                        }
                    });
                }
                SimpleObserver simpleObserver = new SimpleObserver(){

                    public void update() {
                        this.updateImage();
                    }
                };
                stackableNodeContext.getUserIsDraggingSomething().addObserver(simpleObserver);
                stackableNodeContext.addStackChangeListener(simpleObserver);
            }

            private void updateImage() {
                Image image = this.chooseImage();
                if (((Boolean)StackableNode.this.onSkateboard.get()).booleanValue() && bl && (Double)stackableNodeContext.getAppliedForce().get() != 0.0) {
                    StackableNode.this.lastSign = MathUtil.getSign((Double)stackableNodeContext.getAppliedForce().get());
                }
                this.setImage(image);
            }

            private Image chooseImage() {
                if (!((Boolean)StackableNode.this.onSkateboard.get()).booleanValue()) {
                    return bufferedImage2;
                }
                if (bl) {
                    boolean bl3;
                    boolean bl2 = bl3 = (Boolean)stackableNodeContext.getUserIsDraggingSomething().get() != false && stackableNodeContext.getStackSize() < 3 || stackableNodeContext.isInStackButNotInTop(StackableNode.this);
                    if ((Double)stackableNodeContext.getAppliedForce().get() > 0.0) {
                        return bl3 ? StackableNode.this.flippedHandsUpImage : StackableNode.this.flippedStackedImage;
                    }
                    if ((Double)stackableNodeContext.getAppliedForce().get() < 0.0) {
                        return bl3 ? bufferedImage3 : bufferedImage;
                    }
                    if (StackableNode.this.lastSign > 0.0) {
                        return bl3 ? StackableNode.this.flippedHandsUpImage : StackableNode.this.flippedStackedImage;
                    }
                    return bl3 ? bufferedImage3 : bufferedImage;
                }
                return bufferedImage;
            }
        };
        this.addChild(pImage);
        this.setScale(0.8);
        this.textLabel = new ZeroOffsetNode(new PNode(){
            {
                Pair<Integer, String> pair = StackableNode.this.getMassDisplayString(d);
                PhetPText phetPText = new PhetPText((String)pair._2, new PhetFont(18, true));
                PhetPPath phetPPath = new PhetPPath(RectangleUtils.round(RectangleUtils.expand(phetPText.getFullBounds(), 3 + (Integer)pair._1, 3.0), 18.0, 18.0), Color.white, new BasicStroke(1.0f), Color.gray);
                this.addChild(phetPPath);
                this.addChild(phetPText);
                booleanProperty.addObserver(new VoidFunction1<Boolean>(){

                    @Override
                    public void apply(Boolean bl) {
                        this.setVisible(bl);
                    }
                });
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StackableNode.this.textLabel.setOffset(pImage.getFullBounds().getCenterX() - StackableNode.this.textLabel.getFullBounds().getWidth() / 2.0, pImage.getFullBounds().getHeight() - StackableNode.this.textLabel.getFullBounds().getHeight() - 2.0);
            }
        };
        propertyChangeListener.propertyChange(null);
        pImage.addPropertyChangeListener("fullBounds", propertyChangeListener);
        this.addChild(this.textLabel);
        this.initialScale = this.getScale();
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new SimSharingDragHandler(iUserComponent, true){

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                StackableNode.this.addActivity(new AnimateToScale(1.0, StackableNode.this, 200L));
                stackableNodeContext.stackableNodePressed(StackableNode.this);
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                PDimension pDimension = pInputEvent.getDeltaRelativeTo(StackableNode.this.getParent());
                StackableNode.this.translate(pDimension.width, pDimension.height);
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                stackableNodeContext.stackableNodeDropped(StackableNode.this);
            }
        });
    }

    Pair<Integer, String> getMassDisplayString(double d) {
        String string = new DecimalFormat("0").format(d);
        return new Pair<Integer, String>(0, new MessageFormat(ForcesAndMotionBasicsResources.Strings.MASS_DISPLAY__PATTERN).format(new Object[]{string}));
    }

    public void animateHome() {
        this.animateToPositionScaleRotation(this.initialOffset.x, this.initialOffset.y, this.initialScale, 0.0, 200L);
    }

    public void setInitialOffset(double d, double d2) {
        this.initialOffset = Vector2D.v(d, d2);
        this.setOffset(d, d2);
    }

    public double getObjectMaxX() {
        return this.getOffset().getX() + (double)this.toolboxImage.getWidth() * this.getScale();
    }

    public double getInset() {
        if (this.textLabel.getOffset().getX() < 0.0) {
            return Math.abs(this.textLabel.getOffset().getX());
        }
        return 0.0;
    }

    public double getFullScaleHeight() {
        return this.getFullBounds().getHeight() / this.getScale();
    }

    public double getFullScaleWidth() {
        return this.getFullBounds().getWidth() / this.getScale();
    }
}

