/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcesandmotionbasics.motion;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.DoubleProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.forcesandmotionbasics.ForcesAndMotionBasicsResources;
import edu.colorado.phet.forcesandmotionbasics.motion.SpeedValue;
import edu.colorado.phet.forcesandmotionbasics.motion.StackableNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import fj.data.List;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PusherNode
extends PNode {
    private double lastNonzeroAppliedForce = 1.0E-6;
    private final PImage pusher;
    private final DoubleProperty appliedForce;
    private final BufferedImage pusherFallDownRight = BufferedImageUtils.flipX(ForcesAndMotionBasicsResources.Images.PUSHER_FALL_DOWN);
    private final BufferedImage pusherFallDownLeft = ForcesAndMotionBasicsResources.Images.PUSHER_FALL_DOWN;

    public PusherNode(final BooleanProperty booleanProperty, final PNode pNode, final double d, DoubleProperty doubleProperty, final Property<List<StackableNode>> property, ObservableProperty<SpeedValue> observableProperty, final ObservableProperty<Double> observableProperty2, BooleanProperty booleanProperty2, BooleanProperty booleanProperty3) {
        this.appliedForce = doubleProperty;
        this.pusher = new PImage(ForcesAndMotionBasicsResources.Images.PUSHER_STRAIGHT_ON);
        this.pusher.scale(0.7200000000000001);
        this.addChild(this.pusher);
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                boolean bl;
                double d2 = (Double)PusherNode.this.appliedForce.get();
                if (d2 != 0.0) {
                    PusherNode.this.setOffset(0.0, 0.0);
                }
                if (d2 != 0.0) {
                    PusherNode.this.lastNonzeroAppliedForce = d2;
                }
                boolean bl2 = bl = MathUtil.getSign(PusherNode.this.lastNonzeroAppliedForce) == MathUtil.getSign((Double)observableProperty2.get());
                if (d2 == 0.0) {
                    if (bl) {
                        PusherNode.this.pusher.setImage(((Boolean)booleanProperty.get()).booleanValue() ? (PusherNode.this.lastNonzeroAppliedForce > 0.0 ? PusherNode.this.pusherFallDownRight : PusherNode.this.pusherFallDownLeft) : ForcesAndMotionBasicsResources.Images.PUSHER_STRAIGHT_ON);
                        if (PusherNode.this.lastNonzeroAppliedForce > 0.0) {
                            PusherNode.this.pusher.setOffset(pNode.getFullBounds().getX() - PusherNode.this.pusher.getFullBounds().getWidth() + 0.0, d - PusherNode.this.pusher.getFullBounds().getHeight());
                        } else {
                            PusherNode.this.pusher.setOffset(pNode.getFullBounds().getMaxX(), d - PusherNode.this.pusher.getFullBounds().getHeight());
                        }
                    } else {
                        PusherNode.this.pusher.setImage(ForcesAndMotionBasicsResources.Images.PUSHER_STRAIGHT_ON);
                        PusherNode.this.pusher.setOffset(pNode.getFullBounds().getMaxX(), d - PusherNode.this.pusher.getFullBounds().getHeight());
                    }
                } else if (((List)property.get()).length() > 0) {
                    int n = ((StackableNode)((List)property.get()).index((int)0)).pusherOffset;
                    BufferedImage bufferedImage = ForcesAndMotionBasicsResources.RESOURCES.getImage("pusher_" + PusherNode.this.getImageIndex(d2) + ".png");
                    if (d2 > 0.0) {
                        PusherNode.this.pusher.setImage(bufferedImage);
                        PusherNode.this.pusher.setOffset(pNode.getFullBounds().getX() - PusherNode.this.pusher.getFullBounds().getWidth() + (double)n, d - PusherNode.this.pusher.getFullBounds().getHeight());
                    } else {
                        PusherNode.this.pusher.setImage(BufferedImageUtils.flipX(bufferedImage));
                        PusherNode.this.pusher.setOffset(pNode.getFullBounds().getMaxX() - (double)n, d - PusherNode.this.pusher.getFullBounds().getHeight());
                    }
                }
            }
        };
        doubleProperty.addObserver(simpleObserver);
        observableProperty.addObserver(simpleObserver);
        booleanProperty.addObserver(simpleObserver);
        booleanProperty2.addObserver(simpleObserver);
    }

    private int getImageIndex(Double d) {
        int n = 14;
        return (int)Math.round(Math.abs(d) / 500.0 * ((double)n - 0.5));
    }
}

