/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcelawlab.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.forcelawlab.ForceLawLabResources$;
import edu.colorado.phet.forcelawlab.model.Mass;
import edu.colorado.phet.forcelawlab.view.DragHandler;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterNode
extends PNode {
    private final Mass mass;
    private final ModelViewTransform transformMV;
    private final boolean leftOfObject;
    private final Function0<Object> gravityForce;
    private final PhetPPath shadowNode;
    private final PhetPPath ropeNode;
    private int sign;
    private final double scale;
    private final double ropeHeightFromImageBase;
    private final PImage characterImageNode;
    public volatile int bitmap$0;

    public PhetPPath shadowNode() {
        return this.shadowNode;
    }

    public PhetPPath ropeNode() {
        return this.ropeNode;
    }

    public void update() {
        this.updateRopeNode();
        this.updateCharacterNode();
        PBounds b = this.characterImageNode().getFullBounds();
        double shadowHeight = b.getHeight() / 14.0;
        int expandX = 5;
        this.shadowNode().setPathTo(new Ellipse2D.Double(b.x - (double)5, b.getMaxY() - shadowHeight, b.width + (double)10, shadowHeight));
    }

    public Point2D ropeStart() {
        return this.transformMV.modelToView(edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(this.mass.position()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int sign() {
        if ((this.bitmap$0 & 1) != 0) return this.sign;
        CharacterNode characterNode = this;
        synchronized (characterNode) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sign = this.leftOfObject ? -1 : 1;
                this.bitmap$0 |= 1;
            }
            return this.sign;
        }
    }

    public double ropeLength() {
        return this.transformMV.modelToViewDeltaX(this.mass.radius()) + (double)100;
    }

    public Vector2D ropeEnd() {
        return edu.colorado.phet.scalacommon.Predef$.MODULE$.pointToVector2D(this.ropeStart()).$plus(new Vector2D(this.ropeLength() * (double)this.sign(), 0.0));
    }

    public void updateRopeNode() {
        this.ropeNode().setPathTo(new BasicStroke(5.0f).createStrokedShape(new Line2D.Double(this.ropeStart(), edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(this.ropeEnd()))));
        BufferedImage im = BufferedImageUtils.multiScaleToHeight(ForceLawLabResources$.MODULE$.getImage("rope-pattern.png"), 5);
        TexturePaint texturePaint = new TexturePaint(im, new Rectangle2D.Double(this.ropeEnd().x(), 0.0, im.getWidth(), im.getHeight()));
        this.ropeNode().setPaint(texturePaint);
    }

    public int forceAmount() {
        double minForceToShow = 6.4E-10;
        double maxForceToShow = 1.978E-8;
        int a = (int)new Function.LinearFunction(6.4E-10, 1.978E-8, 0.0, 14.0).evaluate(this.gravityForce.apply$mcD$sp());
        return Predef$.MODULE$.intWrapper(Predef$.MODULE$.intWrapper(a).max(0)).min(14);
    }

    public double scale() {
        return this.scale;
    }

    public BufferedImage getImage() {
        BufferedImage im = ForceLawLabResources$.MODULE$.getImage(new StringBuilder().append((Object)"pull-figure/pull_figure_").append(BoxesRunTime.boxToInteger(this.forceAmount())).append((Object)".png").toString());
        BufferedImage flipIm = this.leftOfObject ? BufferedImageUtils.flipX(im) : im;
        return BufferedImageUtils.multiScale(flipIm, 0.5);
    }

    public double ropeHeightFromImageBase() {
        return this.ropeHeightFromImageBase;
    }

    public PImage characterImageNode() {
        return this.characterImageNode;
    }

    public void updateCharacterNode() {
        this.characterImageNode().setImage(this.getImage());
        this.characterImageNode().setOffset(edu.colorado.phet.scalacommon.Predef$.MODULE$.vector2DToPoint(this.ropeEnd()));
        this.characterImageNode().translate(0.0, this.ropeHeightFromImageBase() - this.characterImageNode().getFullBounds().getHeight());
        if (this.leftOfObject) {
            this.characterImageNode().translate(-this.characterImageNode().getFullBounds().getWidth(), 0.0);
        }
        this.characterImageNode().translate((double)(-40 * this.sign()) * this.scale(), 0.0);
        this.characterImageNode().translate((double)(-this.forceAmount() * this.sign()) * 1.5 * this.scale(), 0.0);
    }

    public CharacterNode(Mass mass, Mass mass2, ModelViewTransform transformMV, boolean leftOfObject, Function0<Object> gravityForce, Function0<Object> minDragX, Function0<Object> maxDragX) {
        this.mass = mass;
        this.transformMV = transformMV;
        this.leftOfObject = leftOfObject;
        this.gravityForce = gravityForce;
        this.shadowNode = new PhetPPath(Color.gray);
        this.addChild(this.shadowNode());
        this.ropeNode = new PhetPPath(null, null);
        this.addChild(this.ropeNode());
        mass.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final CharacterNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        mass2.addListener((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final CharacterNode $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.update();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.addInputEventListener(new DragHandler(mass, transformMV, minDragX, maxDragX, this));
        this.addInputEventListener(new CursorHandler());
        this.scale = 0.5;
        this.ropeHeightFromImageBase = (double)103 * this.scale();
        this.characterImageNode = new PImage(this.getImage());
        this.addChild(this.characterImageNode());
        this.update();
    }
}

