/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.forcelawlab.model;

import edu.colorado.phet.forcelawlab.ForceLawLabDefaults$;
import edu.colorado.phet.forcelawlab.model.ForceLawLabModel$;
import edu.colorado.phet.forcelawlab.model.Mass;
import edu.colorado.phet.scalacommon.math.Vector2D;
import edu.colorado.phet.scalacommon.util.Observable;
import edu.colorado.phet.scalacommon.util.Observable$class;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceLawLabModel
implements Observable {
    private final double mass1;
    private final double mass2;
    private final double mass1Position;
    private final double mass2Position;
    private final Function1<Object, Object> mass1Radius;
    private final Function1<Object, Object> mass2Radius;
    private final Mass m1;
    private final Mass m2;
    private final double minDistanceBetweenMasses;
    private final Function0<Object> mass1MaxX;
    private final Function0<Object> mass2MinX;
    private boolean isDraggingControl;
    private final ArrayBuffer<Function0<BoxedUnit>> edu$colorado$phet$scalacommon$util$Observable$$listeners;

    public Mass m1() {
        return this.m1;
    }

    public Mass m2() {
        return this.m2;
    }

    public double minDistanceBetweenMasses() {
        return this.minDistanceBetweenMasses;
    }

    public Function0<Object> mass1MaxX() {
        return this.mass1MaxX;
    }

    public Function0<Object> mass2MinX() {
        return this.mass2MinX;
    }

    public void reset() {
        this.m1().setState(this.mass1, new Vector2D(this.mass1Position, 0.0), this.mass1Radius);
        this.m2().setState(this.mass2, new Vector2D(this.mass2Position, 0.0), this.mass2Radius);
    }

    public Vector2D rFull() {
        return this.m1().position().$minus(this.m2().position());
    }

    public Vector2D r() {
        return this.rFull();
    }

    public Vector2D getGravityForce() {
        return this.r().$times(ForceLawLabDefaults$.MODULE$.G()).$times(this.m1().mass()).$times(this.m2().mass()).$div(Math.pow(this.r().magnitude(), 3.0));
    }

    public void update(double dt) {
    }

    public ForceLawLabModel(double mass1, double mass2, double mass1Position, double mass2Position, Function1<Object, Object> mass1Radius, Function1<Object, Object> mass2Radius, double springConstant, double springRestingLength, double wallWidth, double wallHeight, double wallMaxX, String mass1Name, String mass2Name) {
        this.mass1 = mass1;
        this.mass2 = mass2;
        this.mass1Position = mass1Position;
        this.mass2Position = mass2Position;
        this.mass1Radius = mass1Radius;
        this.mass2Radius = mass2Radius;
        Observable$class.$init$(this);
        this.m1 = new Mass(mass1, new Vector2D(mass1Position, 0.0), mass1Name, mass1Radius);
        this.m2 = new Mass(mass2, new Vector2D(mass2Position, 0.0), mass2Name, mass2Radius);
        this.minDistanceBetweenMasses = 0.1;
        this.mass1MaxX = new $anonfun$1(this);
        this.mass2MinX = new $anonfun$2(this);
        this.isDraggingControl = false;
        this.m1().addListenerByName((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final ForceLawLabModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.notifyListeners();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.m2().addListenerByName((Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final ForceLawLabModel $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.notifyListeners();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

