/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;

public class RulerNode
extends PhetPNode {
    private static final Color BACKGROUND_COLOR = new Color(236, 225, 113);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Stroke BACKGROUND_STROKE = new BasicStroke();
    private static final Color TICK_COLOR = Color.BLACK;
    private static final Stroke TICK_STROKE = new BasicStroke();
    private static final String DEFAULT_FONT_NAME = PhetFont.getDefaultFontName();
    private double distanceBetweenFirstAndLastTick;
    private double insetWidth;
    private double height;
    private String[] majorTickLabels;
    private Font majorTickFont;
    private String units;
    private Font unitsFont;
    private String unitsMajorTickLabel;
    private int numMinorTicksBetweenMajors;
    private double majorTickHeight;
    private double minorTickHeight;
    private Stroke tickStroke = TICK_STROKE;
    private double unitsSpacing = 3.0;
    private double fontScale = 1.0;
    private PNode parentNode;
    private PPath backgroundNode;

    public RulerNode(double d, double d2, double d3, String[] stringArray, Font font, String string, Font font2, int n, double d4, double d5) {
        this.distanceBetweenFirstAndLastTick = d;
        this.insetWidth = d2;
        this.height = d3;
        this.majorTickLabels = stringArray;
        this.majorTickFont = font;
        this.units = string;
        this.unitsFont = font2;
        this.numMinorTicksBetweenMajors = n;
        this.majorTickHeight = d4;
        this.minorTickHeight = d5;
        this.parentNode = new PNode();
        this.addChild(this.parentNode);
        this.backgroundNode = new PPath();
        this.backgroundNode.setPaint(BACKGROUND_COLOR);
        this.backgroundNode.setStrokePaint(BACKGROUND_STROKE_COLOR);
        this.backgroundNode.setStroke(BACKGROUND_STROKE);
        this.parentNode.addChild(this.backgroundNode);
        this.update();
    }

    protected void update() {
        this.parentNode.removeAllChildren();
        double d = this.distanceBetweenFirstAndLastTick + 2.0 * this.insetWidth;
        this.backgroundNode.setPathToRectangle(0.0f, 0.0f, (float)d, (float)this.height);
        this.parentNode.addChild(this.backgroundNode);
        if (this.majorTickLabels != null && this.majorTickLabels.length > 0) {
            double d2 = d - 2.0 * this.insetWidth;
            double d3 = d2 / (double)(this.majorTickLabels.length - 1);
            double d4 = d3 / (double)(this.numMinorTicksBetweenMajors + 1);
            for (int i = 0; i < this.majorTickLabels.length; ++i) {
                String string = this.majorTickLabels[i];
                PText pText = new PText(string);
                pText.setFont(this.majorTickFont);
                pText.setScale(this.fontScale);
                double d5 = d3 * (double)i + this.insetWidth;
                double d6 = this.height / 2.0 - pText.getFullBounds().getHeight() / 2.0;
                pText.setOffset(d5 - pText.getFullBounds().getWidth() / 2.0, d6);
                if (this.insetWidth != 0.0 || i != 0 && i != this.majorTickLabels.length - 1) {
                    this.parentNode.addChild(pText);
                }
                DoubleGeneralPath doubleGeneralPath = this.createTickMark(d5, this.height, this.majorTickHeight);
                PPath pPath = new PPath(doubleGeneralPath.getGeneralPath(), this.tickStroke);
                pPath.setStrokePaint(TICK_COLOR);
                this.parentNode.addChild(pPath);
                if (i < this.majorTickLabels.length - 1) {
                    for (int j = 1; j <= this.numMinorTicksBetweenMajors; ++j) {
                        DoubleGeneralPath doubleGeneralPath2 = this.createTickMark(d5 + (double)j * d4, this.height, this.minorTickHeight);
                        PPath pPath2 = new PPath(doubleGeneralPath2.getGeneralPath(), this.tickStroke);
                        pPath2.setStrokePaint(TICK_COLOR);
                        this.parentNode.addChild(pPath2);
                    }
                }
                if (this.units == null) continue;
                PText pText2 = null;
                if (this.unitsMajorTickLabel != null) {
                    if (this.unitsMajorTickLabel.equals(string)) {
                        pText2 = new PText(this.units);
                    }
                } else if (i == 0 && this.insetWidth != 0.0 || i == 1 && this.insetWidth == 0.0) {
                    pText2 = new PText(this.units);
                }
                if (pText2 == null) continue;
                pText2.setFont(this.unitsFont);
                pText2.setScale(this.fontScale);
                this.parentNode.addChild(pText2);
                double d7 = pText.getOffset().getX() + pText.getFullBounds().getWidth() + this.unitsSpacing;
                double d8 = pText.getOffset().getY() + (pText.getFullBounds().getHeight() - pText2.getFullBounds().getHeight());
                pText2.setOffset(d7, d8);
            }
        }
    }

    protected DoubleGeneralPath createTickMark(double d, double d2, double d3) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(d, 0.0);
        doubleGeneralPath.lineTo(d, d3);
        doubleGeneralPath.moveTo(d, d2 - d3);
        doubleGeneralPath.lineTo(d, d2);
        return doubleGeneralPath;
    }
}

