/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.servicemanager.PhetServiceManager;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.ToolTipHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PhetTabbedPane
extends JPanel {
    public static final Font DEFAULT_TAB_FONT = new PhetFont(16, true);
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(240, 240, 240);
    public static final Color DEFAULT_SELECTED_TAB_COLOR = new Color(180, 205, 255);
    public static final Color DEFAULT_UNSELECTED_TAB_COLOR = new Color(100, 125, 255);
    public static final Color DEFAULT_SELECTED_TEXT_COLOR = Color.BLACK;
    public static final Color DEFAULT_UNSELECTED_TEXT_COLOR = new Color(40, 40, 40);
    private TabPane tabPane;
    private JComponent component;
    private Font tabFont;
    private Color selectedTabColor;
    private Color unselectedTabColor;
    private Color selectedTextColor;
    private Color unselectedTextColor;
    private ArrayList changeListeners = new ArrayList();

    public PhetTabbedPane() {
        super(new BorderLayout());
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.tabFont = DEFAULT_TAB_FONT;
        this.selectedTabColor = DEFAULT_SELECTED_TAB_COLOR;
        this.unselectedTabColor = DEFAULT_UNSELECTED_TAB_COLOR;
        this.selectedTextColor = DEFAULT_SELECTED_TEXT_COLOR;
        this.unselectedTextColor = DEFAULT_UNSELECTED_TEXT_COLOR;
        this.tabPane = new TabPane(this.selectedTabColor, this.unselectedTabColor);
        this.add((Component)this.tabPane, "North");
        ComponentListener componentListener = new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                PhetTabbedPane.this.relayoutComponents();
            }

            public void componentShown(ComponentEvent componentEvent) {
                PhetTabbedPane.this.relayoutComponents();
            }
        };
        this.addComponentListener(componentListener);
        this.relayoutComponents();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.relayoutComponents();
    }

    public void setLogoVisible(boolean bl) {
        this.tabPane.setLogoVisible(bl);
    }

    public int getTabCount() {
        return this.tabPane.getTabCount();
    }

    private void relayoutComponents() {
        if (this.component != null) {
            Rectangle rectangle = this.component.getBounds();
            for (int i = 0; i < this.getTabCount(); ++i) {
                this.tabPane.getTabs()[i].getComponent().setSize(rectangle.width, rectangle.height);
                this.updateLayout(this.tabPane.getTabs()[i].getComponent());
            }
        }
    }

    private void updateLayout(Component component) {
        component.doLayout();
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.updateLayout(container.getComponent(i));
            }
        }
    }

    public void removeTabAt(int n) {
        AbstractTabNode abstractTabNode = this.getTab(n);
        AbstractTabNode abstractTabNode2 = this.getSelectedTab();
        this.tabPane.removeTabAt(n);
        if (abstractTabNode2 == abstractTabNode && this.getTabCount() > 0) {
            if (n < this.getTabCount()) {
                this.setSelectedIndex(n);
            } else {
                this.setSelectedIndex(n - 1);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public int getSelectedIndex() {
        return this.tabPane.getSelectedIndex();
    }

    public void setSelectedTabColor(Color color) {
        this.selectedTabColor = color;
        this.tabPane.setSelectedTabColor(color);
    }

    public Color getSelectedTabColor() {
        return this.selectedTabColor;
    }

    public void setUnselectedTabColor(Color color) {
        this.unselectedTabColor = color;
        this.tabPane.setUnselectedTabColor(color);
    }

    public Color getUnselectedTabColor() {
        return this.unselectedTabColor;
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor = color;
        this.tabPane.setSelectedTextColor(color);
    }

    public Color getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setUnselectedTextColor(Color color) {
        this.unselectedTextColor = color;
        this.tabPane.setUnselectedTextColor(color);
    }

    public Color getUnselectedTextColor() {
        return this.unselectedTextColor;
    }

    public void addTab(IUserComponent iUserComponent, String string, JComponent jComponent) {
        AbstractTabNode abstractTabNode = this.createTab(iUserComponent, string, jComponent);
        abstractTabNode.addInputEventListener(new TabInputListener(abstractTabNode));
        if (this.tabPane.getTabs().length == 0) {
            this.setSelectedTab(abstractTabNode);
            this.tabPane.setSelectedTab(abstractTabNode);
        } else {
            abstractTabNode.setSelected(false);
        }
        this.tabPane.addTab(abstractTabNode);
        this.relayoutComponents();
    }

    protected AbstractTabNode createTab(IUserComponent iUserComponent, String string, JComponent jComponent) {
        return new HTMLTabNode(iUserComponent, string, jComponent, this.selectedTabColor, this.unselectedTabColor, this.selectedTextColor, this.unselectedTextColor, this.tabFont);
    }

    public void setSelectedIndex(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            throw new RuntimeException("Illegal tab index: " + n + ", tab count=" + this.getTabCount());
        }
        this.setSelectedTab(this.tabPane.getTabs()[n]);
    }

    protected void setSelectedTab(AbstractTabNode abstractTabNode) {
        this.setComponent(abstractTabNode.getComponent());
        abstractTabNode.setSelected(true);
        for (int i = 0; i < this.tabPane.getTabs().length; ++i) {
            AbstractTabNode abstractTabNode2 = this.tabPane.getTabs()[i];
            if (abstractTabNode2 == abstractTabNode) continue;
            abstractTabNode2.setSelected(false);
        }
        this.tabPane.setSelectedTab(abstractTabNode);
        this.notifySelectionChanged();
    }

    private void notifySelectionChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.changeListeners.get(i);
            changeListener.stateChanged(changeEvent);
        }
    }

    private AbstractTabNode getSelectedTab() {
        return this.tabPane.getSelectedTab();
    }

    private void setComponent(JComponent jComponent) {
        if (jComponent != this.component) {
            if (this.component != null) {
                this.remove(this.component);
            }
            this.component = jComponent;
            this.add((Component)jComponent, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public AbstractTabNode getTab(int n) {
        return this.tabPane.getTab(n);
    }

    public String getTitleAt(int n) {
        return this.getTab(n).getText();
    }

    public boolean getLogoVisible() {
        return this.tabPane.getLogoVisible();
    }

    private static int darker(int n, int n2) {
        return Math.max(0, n - n2);
    }

    private static Color darker(Color color, int n) {
        return new Color(PhetTabbedPane.darker(color.getRed(), n), PhetTabbedPane.darker(color.getGreen(), n), PhetTabbedPane.darker(color.getBlue(), n));
    }

    protected class TabInputListener
    extends PBasicInputEventHandler {
        private AbstractTabNode tab;

        public TabInputListener(AbstractTabNode abstractTabNode) {
            this.tab = abstractTabNode;
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            if (this.tab.getFullBounds().contains(pInputEvent.getCanvasPosition())) {
                SimSharingManager.sendUserMessage(this.tab.userComponent, UserComponentTypes.tab, UserActions.pressed);
                PhetTabbedPane.this.setSelectedTab(this.tab);
            }
        }

        public void mouseEntered(PInputEvent pInputEvent) {
            PhetTabbedPane.this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public void mouseExited(PInputEvent pInputEvent) {
            PhetTabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private static class TabPane
    extends PSwingCanvas {
        private ArrayList tabs = new ArrayList();
        private double distBetweenTabs = -6.0;
        private TabBase tabBase;
        private int tabTopInset = 3;
        private PImage logo;
        private AbstractTabNode selectedTab;
        private boolean logoObscured = false;
        private boolean logoVisible = true;

        public TabPane(Color color, Color color2) {
            BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("logos/phet-logo-120x50.jpg");
            this.logo = new PImage(bufferedImage);
            this.logo.addInputEventListener(new CursorHandler());
            this.logo.addInputEventListener(new ToolTipHandler(PhetCommonResources.getInstance().getLocalizedString("Common.About.WebLink"), this));
            this.logo.addInputEventListener(new PBasicInputEventHandler(){

                public void mousePressed(PInputEvent pInputEvent) {
                    PhetServiceManager.showPhetPage();
                }
            });
            this.tabBase = new TabBase(color);
            this.setPanEventHandler(null);
            this.setZoomEventHandler(null);
            this.setOpaque(false);
            this.getLayer().addChild(this.logo);
            this.getLayer().addChild(this.tabBase);
            this.relayout();
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            this.relayout();
        }

        public AbstractTabNode getSelectedTab() {
            return this.selectedTab;
        }

        public void addTab(AbstractTabNode abstractTabNode) {
            this.tabs.add(abstractTabNode);
            this.getLayer().addChild(0, abstractTabNode);
            this.relayout();
            this.setSelectedTab(this.getSelectedTab() == null ? abstractTabNode : this.getSelectedTab());
        }

        private void relayout() {
            this.tabBase.setTabBaseWidth(this.getWidth());
            int n = AbstractTabNode.tabInsets.left + 10;
            double d = this.getMaxTabTextHeight();
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                abstractTabNode.setOffset(n, this.tabTopInset);
                abstractTabNode.setTabTextHeight(d);
                n = (int)((double)n + (abstractTabNode.getFullBounds().getWidth() + this.distBetweenTabs));
            }
            double d2 = (double)this.getHeight() - this.tabBase.getFullBounds().getHeight();
            this.tabBase.setOffset(0.0, d2);
            this.relayoutLogo(d2);
            for (int i = 0; i < this.tabs.size(); ++i) {
                this.getTab(i).updatePaint();
            }
            this.tabBase.updatePaint();
        }

        private void relayoutLogo(double d) {
            if (this.logo.getImage().getHeight(null) > this.getHeight()) {
                double d2 = ((double)this.getHeight() - 5.0) / (double)this.logo.getImage().getHeight(null);
                this.logo.setScale(Math.max(d2, 0.5));
            } else {
                this.logo.setScale(1.0);
            }
            this.logo.setOffset((double)this.getWidth() - this.logo.getFullBounds().getWidth(), d / 2.0 - this.logo.getFullBounds().getHeight() / 2.0);
            if (this.tabs.size() > 0) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(this.tabs.size() - 1);
                if (this.logo.getXOffset() < abstractTabNode.getFullBounds().getMaxX()) {
                    this.logoObscured = true;
                    this.updateLogoVisible();
                } else {
                    this.logoObscured = false;
                    this.updateLogoVisible();
                }
            }
        }

        public Dimension getPreferredSize() {
            this.relayout();
            int n = this.getMaxTabHeight();
            int n2 = (int)this.getLayer().getFullBounds().getWidth();
            n2 = Math.max(n2, super.getPreferredSize().width);
            return new Dimension(n2, (int)((double)n + this.tabBase.getFullBounds().getHeight()));
        }

        private double getMaxTabTextHeight() {
            double d = 0.0;
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                d = Math.max(d, abstractTabNode.getTextHeight()) + this.getTabInsetFudgeFactor();
            }
            return d;
        }

        private double getTabInsetFudgeFactor() {
            if (System.getProperty("os.name").toLowerCase().indexOf("mac os x") >= 0) {
                return 2.0;
            }
            return 0.0;
        }

        private int getMaxTabHeight() {
            int n = 0;
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                n = (int)Math.max((double)n, abstractTabNode.getFullBounds().getHeight());
            }
            return n;
        }

        public AbstractTabNode[] getTabs() {
            return this.tabs.toArray(new AbstractTabNode[0]);
        }

        public void setSelectedTab(AbstractTabNode abstractTabNode) {
            int n;
            this.selectedTab = abstractTabNode;
            for (n = 0; n < this.getTabs().length; ++n) {
                if (!this.getLayer().getChildrenReference().contains(this.getTabs()[n])) continue;
                this.getLayer().removeChild(this.getTabs()[n]);
            }
            for (n = this.getTabs().length - 1; n >= 0; --n) {
                if (this.getTabs()[n] == abstractTabNode) continue;
                this.getLayer().addChild(this.getTabs()[n]);
            }
            this.getLayer().removeChild(this.tabBase);
            this.getLayer().addChild(this.tabBase);
            this.getLayer().addChild(abstractTabNode);
        }

        public int getSelectedIndex() {
            return this.tabs.indexOf(this.selectedTab);
        }

        public int getTabCount() {
            return this.tabs.size();
        }

        protected AbstractTabNode getTab(int n) {
            return (AbstractTabNode)this.tabs.get(n);
        }

        public void removeTabAt(int n) {
            this.getLayer().removeChild((PNode)this.tabs.get(n));
            this.tabs.remove(n);
            this.relayout();
        }

        public void setSelectedTabColor(Color color) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                abstractTabNode.setSelectedTabColor(color);
            }
            this.tabBase.setTabColor(color);
        }

        public void setUnselectedTabColor(Color color) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                abstractTabNode.setUnselectedTabColor(color);
            }
        }

        public void setSelectedTextColor(Color color) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                abstractTabNode.setSelectedTextColor(color);
            }
        }

        public void setUnselectedTextColor(Color color) {
            for (int i = 0; i < this.tabs.size(); ++i) {
                AbstractTabNode abstractTabNode = (AbstractTabNode)this.tabs.get(i);
                abstractTabNode.setUnselectedTextColor(color);
            }
        }

        public void setLogoVisible(boolean bl) {
            this.logoVisible = bl;
            this.updateLogoVisible();
        }

        public boolean getLogoVisible() {
            return this.logoVisible;
        }

        private void updateLogoVisible() {
            this.logo.setVisible(this.logoVisible && !this.logoObscured);
        }
    }

    private static class TabBase
    extends PNode {
        private final PhetPPath path;
        private int tabBaseHeight = 9;
        private Color color;

        public TabBase(Color color) {
            this.color = color;
            this.path = new PhetPPath(new Rectangle(0, 0, 200, this.tabBaseHeight));
            this.path.setPaint(color);
            this.path.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, this.tabBaseHeight + 4, color.darker()));
            this.path.setStroke(null);
            this.addChild(this.path);
            this.updatePaint();
        }

        public void setTabBaseWidth(int n) {
            this.path.setPathTo(new Rectangle(0, 0, n, this.tabBaseHeight));
        }

        public void updatePaint() {
            this.path.setPaint(new GradientPaint(0.0f, 0.0f, this.color, 0.0f, this.tabBaseHeight, PhetTabbedPane.darker(this.color, 75)));
        }

        public void setTabColor(Color color) {
            this.color = color;
            this.updatePaint();
        }
    }

    private static abstract class AbstractTabNode
    extends PNode {
        private final IUserComponent userComponent;
        private String text;
        private JComponent component;
        private PNode textNode;
        private PhetPPath background;
        private boolean selected;
        private float tiltWidth = 11.0f;
        private Color selectedTabColor;
        private Color unselectedTabColor;
        private Color selectedTextColor;
        private Color unselectedTextColor;
        private PPath outlineNode;
        private Font tabFont;
        private boolean textIsCentered = true;
        private static final Insets tabInsets = new Insets(2, 15, 0, 15);

        public AbstractTabNode(IUserComponent iUserComponent, String string, JComponent jComponent, Color color, Color color2, Color color3, Color color4, Font font) {
            this.userComponent = iUserComponent;
            this.text = string;
            this.component = jComponent;
            this.selectedTabColor = color;
            this.unselectedTabColor = color2;
            this.selectedTextColor = color3;
            this.unselectedTextColor = color4;
            this.tabFont = font;
            this.textNode = this.createTextNode(string);
            this.outlineNode = new PPath(this.createTabTopBorder(this.textNode.getFullBounds().getWidth(), this.textNode.getFullBounds().getHeight()));
            this.background = new PhetPPath(this.createTabShape(this.textNode.getFullBounds().getWidth(), this.textNode.getFullBounds().getHeight()));
            this.background.setStroke(null);
            this.addChild(this.background);
            this.addChild(this.textNode);
            this.addChild(this.outlineNode);
        }

        protected Color getSelectedTextColor() {
            return this.selectedTextColor;
        }

        protected abstract PNode createTextNode(String var1);

        protected abstract void updateTextNode();

        public void setTabTextHeight(double d) {
            this.background.setPathTo(this.createTabShape(this.textNode.getFullBounds().getWidth(), d));
            this.outlineNode.setPathTo(this.createTabTopBorder(this.textNode.getFullBounds().getWidth(), d));
            if (this.textIsCentered) {
                this.textNode.setOffset(0.0, d / 2.0 - this.textNode.getHeight() / 2.0);
            }
        }

        private GeneralPath createTabTopBorder(double d, double d2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-AbstractTabNode.tabInsets.left, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            generalPath.lineTo(-AbstractTabNode.tabInsets.left, -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)(d + (double)AbstractTabNode.tabInsets.right), -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)d + (float)AbstractTabNode.tabInsets.right + this.tiltWidth, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            return generalPath;
        }

        private GeneralPath createTabShape(double d, double d2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(-AbstractTabNode.tabInsets.left, -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)(d + (double)AbstractTabNode.tabInsets.right), -AbstractTabNode.tabInsets.top);
            generalPath.lineTo((float)d + (float)AbstractTabNode.tabInsets.right + this.tiltWidth, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            generalPath.lineTo(-AbstractTabNode.tabInsets.left, (float)(d2 + (double)AbstractTabNode.tabInsets.bottom));
            generalPath.closePath();
            return generalPath;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
            this.background.setStroke(this.getBorderStroke());
            this.outlineNode.setVisible(bl);
            this.outlineNode.setStroke(bl ? new BasicStroke(1.2f) : new BasicStroke(1.0f));
            this.updatePaint();
        }

        private void updatePaint() {
            this.background.setPaint(this.getBackgroundPaint());
            this.background.setStrokePaint(this.getBorderStrokePaint());
            this.updateTextNode();
        }

        private Paint getBorderStrokePaint() {
            return Color.gray;
        }

        private Stroke getBorderStroke() {
            return !this.selected ? new BasicStroke(1.0f) : null;
        }

        private Paint getBackgroundPaint() {
            if (this.selected) {
                return new GradientPaint(0.0f, (float)this.background.getFullBounds().getY() - 2.0f, this.selectedTabColor.brighter(), 0.0f, (float)(this.background.getFullBounds().getY() + 6.0), this.selectedTabColor);
            }
            return new GradientPaint(0.0f, (float)this.background.getFullBounds().getY() - 2.0f, this.unselectedTabColor.brighter(), 0.0f, (float)(this.background.getFullBounds().getY() + 6.0), this.unselectedTabColor);
        }

        protected Color getTextColor() {
            return this.selected ? this.selectedTextColor : this.unselectedTextColor;
        }

        public Font getTabFont() {
            return this.tabFont;
        }

        public String getText() {
            return this.text;
        }

        public void setSelectedTabColor(Color color) {
            this.selectedTabColor = color;
            this.updatePaint();
        }

        public void setUnselectedTabColor(Color color) {
            this.unselectedTabColor = color;
            this.updatePaint();
        }

        public void setSelectedTextColor(Color color) {
            this.selectedTextColor = color;
            this.updatePaint();
        }

        public void setUnselectedTextColor(Color color) {
            this.unselectedTextColor = color;
            this.updatePaint();
        }

        public double getTextHeight() {
            return this.textNode.getFullBounds().getHeight();
        }
    }

    private static class HTMLTabNode
    extends AbstractTabNode {
        private HTMLNode htmlNode;

        public HTMLTabNode(IUserComponent iUserComponent, String string, JComponent jComponent, Color color, Color color2, Color color3, Color color4, Font font) {
            super(iUserComponent, string, jComponent, color, color2, color3, color4, font);
        }

        protected PNode createTextNode(String string) {
            this.htmlNode = new HTMLNode(string, this.getSelectedTextColor(), this.getTabFont());
            return this.htmlNode;
        }

        protected void updateTextNode() {
            this.htmlNode.setFont(this.getTabFont());
            this.htmlNode.setHTMLColor(this.getTextColor());
        }
    }
}

