/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.graphics.transforms;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ModelViewTransform {
    private AffineTransform transform;

    private ModelViewTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
    }

    public static ModelViewTransform createRectangleInvertedYMapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = rectangle2D2.getWidth() / rectangle2D.getWidth();
        double d2 = rectangle2D2.getX() - d * rectangle2D.getX();
        double d3 = -rectangle2D2.getHeight() / rectangle2D.getHeight();
        double d4 = rectangle2D2.getY() - d3 * rectangle2D.getMaxY();
        return new ModelViewTransform(new AffineTransform(d, 0.0, 0.0, d3, d2, d4));
    }

    public Point2D modelToView(Point2D point2D) {
        return this.transform.transform(point2D, null);
    }

    public Point2D modelToViewDelta(Point2D point2D) {
        return this.transform.deltaTransform(point2D, null);
    }

    public double modelToViewDeltaX(double d) {
        return this.modelToViewDelta(new Point2D.Double(d, 0.0)).getX();
    }

    public Point2D viewToModel(Point2D point2D) {
        return this.getInverseTransform().transform(point2D, null);
    }

    public Point2D viewToModelDelta(Point2D point2D) {
        return this.getInverseTransform().deltaTransform(point2D, null);
    }

    public Vector2D viewToModelDelta(Vector2D vector2D) {
        return new Vector2D(this.viewToModelDelta(vector2D.toPoint2D()));
    }

    public double viewToModelX(double d) {
        return this.viewToModel(d, 0.0).getX();
    }

    public Point2D viewToModel(double d, double d2) {
        return this.viewToModel(new Point2D.Double(d, d2));
    }

    protected AffineTransform getInverseTransform() {
        try {
            return this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.transform.equals(((ModelViewTransform)object).transform);
    }

    public int hashCode() {
        return this.transform.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.transform.toString();
    }
}

