/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing;

import edu.colorado.phet.common.phetcommon.simsharing.Log;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingMessage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SimSharingFileLogger
implements Log {
    private final String machineCookie;
    private final String sessionId;
    private boolean nearJAR;
    private BufferedWriter logWriter;
    private File file;

    public SimSharingFileLogger(String string, String string2, boolean bl) {
        this.machineCookie = string;
        this.sessionId = string2;
        this.nearJAR = bl;
    }

    private void createLogWriter() {
        if (this.nearJAR) {
            File file;
            try {
                file = new File(SimSharingFileLogger.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
            this.file = new File(file, "phet-logs/" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + "_" + this.machineCookie + "_" + this.sessionId + ".txt");
        } else {
            this.file = new File(System.getProperty("user.home"), "phet-logs/" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + "_" + this.machineCookie + "_" + this.sessionId + ".txt");
        }
        this.file.getParentFile().mkdirs();
        System.out.println("Logging sim-sharing messages to file: " + this.file);
        try {
            this.file.createNewFile();
            this.logWriter = new BufferedWriter(new FileWriter(this.file, true));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void addMessage(SimSharingMessage simSharingMessage) throws IOException {
        if (this.logWriter == null) {
            this.createLogWriter();
        }
        if (this.logWriter != null) {
            this.logWriter.write(simSharingMessage.toString());
            this.logWriter.newLine();
            this.logWriter.flush();
        }
    }

    public String getName() {
        return "file: " + (this.file == null ? "null" : this.file.getAbsolutePath());
    }

    public void shutdown() {
        try {
            this.logWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

